/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.nx584.BNx6Network;
import com.tridium.nx584.datatypes.BKeypadPinFuncParameter;
import com.tridium.nx584.datatypes.BNx6SystemStatus;
import com.tridium.nx584.enums.BNx6KeypadFunctionType;
import com.tridium.nx584.enums.BNx6SecondaryKeypadFunctionType;
import com.tridium.nx584.messages.InterfaceConfiguration;
import com.tridium.nx584.messages.InterfaceConfigurationRequest;
import com.tridium.nx584.messages.Nx6Acknowledge;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.messages.PartitionStatus;
import com.tridium.nx584.messages.PrimaryKeyFuncRequest;
import com.tridium.nx584.messages.PrimaryKeyFuncWithPinRequest;
import com.tridium.nx584.messages.SecondaryKeyFuncRequest;
import com.tridium.nx584.messages.SystemStatus;
import com.tridium.nx584.messages.ZoneBypassToggleRequest;
import com.tridium.nx584.messages.ZoneStatus;
import com.tridium.nx584.messages.ZonesSnapshot;
import com.tridium.nx584.point.BNx6PointDeviceExt;
import com.tridium.nx584.util.Nx6Util;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNx6Panel
extends BBasicDevice
implements Nx6MessageConst {
    public static final Action ping = BNx6Panel.newAction((int)20, null);
    public static final Action upload = BNx6Panel.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BNx6Panel.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property address = BNx6Panel.newProperty((int)4, (String)"", null);
    public static final Property points = BNx6Panel.newProperty((int)0, (BValue)new BNx6PointDeviceExt(), null);
    public static final Property systemStatus = BNx6Panel.newProperty((int)0, (BValue)new BNx6SystemStatus(), null);
    public static final Action requestConfig = BNx6Panel.newAction((int)4, null);
    public static final Action requestSystemStatus = BNx6Panel.newAction((int)4, null);
    public static final Action requestPartitionStatus = BNx6Panel.newAction((int)4, (BValue)BInteger.make((int)1), null);
    public static final Action requestZoneStatus = BNx6Panel.newAction((int)4, (BValue)BInteger.make((int)1), null);
    public static final Action requestZoneSnapshot = BNx6Panel.newAction((int)4, (BValue)BInteger.make((int)1), null);
    public static final Action keypadFunction = BNx6Panel.newAction((int)4, (BValue)BNx6KeypadFunctionType.turnOffAlarm, null);
    public static final Action keypadPinFunction = BNx6Panel.newAction((int)0, (BValue)new BKeypadPinFuncParameter(1234, BNx6KeypadFunctionType.turnOffAlarm), null);
    public static final Action secondaryKeypadFunction = BNx6Panel.newAction((int)0, (BValue)BNx6SecondaryKeypadFunctionType.stay, null);
    public static final Action zoneBypassToggle = BNx6Panel.newAction((int)0, (BValue)BInteger.make((int)1), null);
    public static final Type TYPE;
    boolean establishCom;
    static /* synthetic */ Class class$com$tridium$nx584$BNx6Panel;

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public BNx6PointDeviceExt getPoints() {
        return (BNx6PointDeviceExt)this.get(points);
    }

    public void setPoints(BNx6PointDeviceExt bNx6PointDeviceExt) {
        this.set(points, (BValue)bNx6PointDeviceExt, null);
    }

    public BNx6SystemStatus getSystemStatus() {
        return (BNx6SystemStatus)this.get(systemStatus);
    }

    public void setSystemStatus(BNx6SystemStatus bNx6SystemStatus) {
        this.set(systemStatus, (BValue)bNx6SystemStatus, null);
    }

    public void requestConfig() {
        this.invoke(requestConfig, null, null);
    }

    public void requestSystemStatus() {
        this.invoke(requestSystemStatus, null, null);
    }

    public void requestPartitionStatus(BInteger bInteger) {
        this.invoke(requestPartitionStatus, (BValue)bInteger, null);
    }

    public void requestZoneStatus(BInteger bInteger) {
        this.invoke(requestZoneStatus, (BValue)bInteger, null);
    }

    public void requestZoneSnapshot(BInteger bInteger) {
        this.invoke(requestZoneSnapshot, (BValue)bInteger, null);
    }

    public void keypadFunction(BNx6KeypadFunctionType bNx6KeypadFunctionType) {
        this.invoke(keypadFunction, (BValue)bNx6KeypadFunctionType, null);
    }

    public void keypadPinFunction(BKeypadPinFuncParameter bKeypadPinFuncParameter) {
        this.invoke(keypadPinFunction, (BValue)bKeypadPinFuncParameter, null);
    }

    public void secondaryKeypadFunction(BNx6SecondaryKeypadFunctionType bNx6SecondaryKeypadFunctionType) {
        this.invoke(secondaryKeypadFunction, (BValue)bNx6SecondaryKeypadFunctionType, null);
    }

    public void zoneBypassToggle(BInteger bInteger) {
        this.invoke(zoneBypassToggle, (BValue)bInteger, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BNx6Network getNx6Network() {
        return (BNx6Network)this.getNetwork();
    }

    public Type getNetworkType() {
        return BNx6Network.TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        try {
            if (!bNx6Network.establishComm(this)) {
                this.pingFail("comm setup error");
                return;
            }
            SystemStatus systemStatus = Nx6Util.getSystemStatus(bNx6Network);
            this.getSystemStatus().updateSystemStatus(systemStatus);
            this.pingOk();
        }
        catch (Exception exception) {
            this.pingFail("caught exception");
            exception.printStackTrace();
        }
    }

    public void doRequestConfig() {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        InterfaceConfigurationRequest interfaceConfigurationRequest = new InterfaceConfigurationRequest();
        InterfaceConfiguration interfaceConfiguration = (InterfaceConfiguration)bNx6Network.sendSync(interfaceConfigurationRequest);
        System.out.println(interfaceConfiguration);
    }

    public void doRequestSystemStatus() {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        SystemStatus systemStatus = Nx6Util.getSystemStatus(bNx6Network);
        System.out.println(systemStatus);
    }

    public void doRequestZoneStatus(BInteger bInteger) {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        ZoneStatus zoneStatus = Nx6Util.getZoneStatus(bNx6Network, bInteger.getInt());
        System.out.println(zoneStatus);
    }

    public void doRequestZoneSnapshot(BInteger bInteger) {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        ZonesSnapshot zonesSnapshot = Nx6Util.getZonesSnapshot(bNx6Network, bInteger.getInt());
        System.out.println(zonesSnapshot);
    }

    public void doRequestPartitionStatus(BInteger bInteger) {
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        PartitionStatus partitionStatus = Nx6Util.getPartitionsStatus(bNx6Network, bInteger.getInt());
        System.out.println(partitionStatus);
    }

    public void doKeypadFunction(BNx6KeypadFunctionType bNx6KeypadFunctionType) {
        if (this.log().isTraceOn()) {
            System.out.println("\n*** doKeypadFunction " + (Object)((Object)bNx6KeypadFunctionType));
        }
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        PrimaryKeyFuncRequest primaryKeyFuncRequest = new PrimaryKeyFuncRequest();
        primaryKeyFuncRequest.setFunction(bNx6KeypadFunctionType.getOrdinal());
        Nx6Acknowledge nx6Acknowledge = (Nx6Acknowledge)bNx6Network.sendSync(primaryKeyFuncRequest);
        this.verifyAck(nx6Acknowledge);
    }

    public void doKeypadPinFunction(BKeypadPinFuncParameter bKeypadPinFuncParameter) {
        if (this.log().isTraceOn()) {
            System.out.println("\n*** doKeypadPinFunction " + (Object)((Object)bKeypadPinFuncParameter.getFunction()));
        }
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        PrimaryKeyFuncWithPinRequest primaryKeyFuncWithPinRequest = new PrimaryKeyFuncWithPinRequest();
        primaryKeyFuncWithPinRequest.setFunction(bKeypadPinFuncParameter.getFunction().getOrdinal());
        primaryKeyFuncWithPinRequest.setPin(Nx6Util.intToPin(bKeypadPinFuncParameter.getPin()));
        Nx6Acknowledge nx6Acknowledge = (Nx6Acknowledge)bNx6Network.sendSync(primaryKeyFuncWithPinRequest);
        this.verifyAck(nx6Acknowledge);
    }

    public void doSecondaryKeypadFunction(BNx6SecondaryKeypadFunctionType bNx6SecondaryKeypadFunctionType) {
        if (this.log().isTraceOn()) {
            System.out.println("\n*** doSecondaryKeypadFunction " + (Object)((Object)bNx6SecondaryKeypadFunctionType));
        }
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        SecondaryKeyFuncRequest secondaryKeyFuncRequest = new SecondaryKeyFuncRequest();
        secondaryKeyFuncRequest.setFunction(bNx6SecondaryKeypadFunctionType.getOrdinal());
        Nx6Acknowledge nx6Acknowledge = (Nx6Acknowledge)bNx6Network.sendSync(secondaryKeyFuncRequest);
        this.verifyAck(nx6Acknowledge);
    }

    public void doZoneBypassToggle(BInteger bInteger) {
        if (this.log().isTraceOn()) {
            System.out.println("\n*** doZoneBypassToggle " + bInteger.getInt());
        }
        BNx6Network bNx6Network = (BNx6Network)this.getNetwork();
        ZoneBypassToggleRequest zoneBypassToggleRequest = new ZoneBypassToggleRequest();
        zoneBypassToggleRequest.setZone(bInteger.getInt());
        Nx6Acknowledge nx6Acknowledge = (Nx6Acknowledge)bNx6Network.sendSync(zoneBypassToggleRequest);
        this.verifyAck(nx6Acknowledge);
    }

    private final void verifyAck(Nx6Acknowledge nx6Acknowledge) {
        if (nx6Acknowledge.msgType == 31) {
            throw new LocalizableRuntimeException("nx584", "keyFunction.reject");
        }
        if (nx6Acknowledge.msgType != 29) {
            throw new LocalizableRuntimeException("nx584", "keyFunction.fail");
        }
    }

    protected Log log() {
        return BNx6Network.getNxLog();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.establishCom = true;
    }

    public BNx6Panel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nx584$BNx6Panel;
        if (clazz == null) {
            clazz = class$com$tridium$nx584$BNx6Panel = BNx6Panel.class("[Lcom.tridium.nx584.BNx6Panel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

