/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.seriestransform.exceptions.SchemaException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BTransformFunction
extends BObject {
    public static final Type TYPE;
    private static Hashtable table;
    public static final Log log;
    public static final Lexicon lex;
    private static final String ERR_SERIES_NOT_FOUND = "functions.err.seriesNotFound";
    static /* synthetic */ Class class$javax$baja$seriestransform$graph$BTransformFunction;

    public Type getType() {
        return TYPE;
    }

    public abstract void applyFunction(Map var1, String[] var2, Property var3, BComplex var4) throws TransformException;

    public abstract String getFunctionName();

    public abstract String getFunctionDesc();

    public abstract Type getReturnType();

    public abstract Type[] getArgumentTypes();

    public boolean isCumulative() {
        return true;
    }

    public final List getSeriesRecords(Map map, String string) {
        List list = new LinkedList();
        if (string != null && map.containsKey(string)) {
            list = (List)map.get(string);
        } else {
            log.error(this.getFunctionName() + " failed.");
            log.error(lex.getText(ERR_SERIES_NOT_FOUND, new Object[]{string}));
        }
        return list;
    }

    public static final BUnit getUnits(Property property) {
        BFacets bFacets = property.getFacets();
        BUnit bUnit = BUnit.NULL;
        if (bFacets != null && bFacets.get("units") != null) {
            bUnit = (BUnit)bFacets.get("units");
        }
        return bUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setRecordValue(BComplex bComplex, Property property, BValue bValue) throws SchemaException {
        if (bValue == null) return;
        if (bComplex.getProperty(property.getName()) == null) {
            BFacets bFacets = property.getFacets();
            if (!(bComplex instanceof BComponent)) throw new SchemaException(lex.getText("fault.msg.schema.invalidField", (Object[])new String[]{property.getName()}));
            ((BComponent)bComplex).add(property.getName(), bValue, 0, bFacets, null);
            return;
        } else {
            bComplex.set(property, bValue);
        }
    }

    public static final BNumber convertToUnits(BNumber bNumber, BUnit bUnit, BUnit bUnit2) {
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        if (bUnit2 == null) {
            bUnit2 = BUnit.NULL;
        }
        if (bUnit.isNull() && bUnit2.isNull() || bUnit.encodeToString().equals(bUnit2.encodeToString())) {
            return bNumber;
        }
        if (bUnit.isNull() || bUnit2.isNull() || bNumber == null || !bUnit.isConvertible(bUnit2)) {
            return BDouble.NaN;
        }
        double d = bUnit.convertTo(bUnit2, bNumber.getDouble());
        return BDouble.make((double)d);
    }

    public static final String getSeriesName(String string) {
        String string2 = "";
        if (string != null) {
            String[] stringArray = TextUtil.split((String)string, (char)'.');
            string2 = stringArray.length > 1 ? stringArray[0] : string;
        }
        return string2;
    }

    public static final String getFieldName(String string) {
        String string2 = "";
        if (string != null) {
            String[] stringArray = TextUtil.split((String)string, (char)'.');
            string2 = stringArray.length > 1 ? stringArray[1] : string;
        }
        return string2;
    }

    private static final void loadFunctionTable() {
        Registry registry = Sys.getRegistry();
        TypeInfo[] typeInfoArray = registry.getConcreteTypes(TYPE.getTypeInfo());
        int n = 0;
        while (n < typeInfoArray.length) {
            TypeInfo typeInfo = typeInfoArray[n];
            BTransformFunction bTransformFunction = (BTransformFunction)typeInfo.getInstance();
            table.put(typeInfo.getTypeSpec(), bTransformFunction);
            ++n;
        }
    }

    public static final BTransformFunction getFunction(BTypeSpec bTypeSpec) {
        if (table.isEmpty()) {
            BTransformFunction.loadFunctionTable();
        }
        return (BTransformFunction)((Object)table.get(bTypeSpec));
    }

    public static final List getAllFunctions() {
        LinkedList<BTransformFunction> linkedList = new LinkedList<BTransformFunction>();
        if (table.isEmpty()) {
            BTransformFunction.loadFunctionTable();
        }
        Set set = table.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BTypeSpec bTypeSpec = (BTypeSpec)iterator.next();
            BTransformFunction bTransformFunction = (BTransformFunction)((Object)table.get(bTypeSpec));
            linkedList.add(bTransformFunction);
        }
        return linkedList;
    }

    public String toString(Context context) {
        return this.getFunctionName();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$seriestransform$graph$BTransformFunction;
        if (clazz == null) {
            clazz = class$javax$baja$seriestransform$graph$BTransformFunction = BTransformFunction.class("[Ljavax.baja.seriestransform.graph.BTransformFunction;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        table = new Hashtable();
        log = Log.getLog((String)"seriesTransform.functions");
        Class clazz2 = class$javax$baja$seriestransform$graph$BTransformFunction;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$seriestransform$graph$BTransformFunction = BTransformFunction.class("[Ljavax.baja.seriestransform.graph.BTransformFunction;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

