/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import com.tridium.seriestransform.NGraphNodeParams;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BNodeContainer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.baja.agent.AgentList;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.seriestransform.graph.QueryParams;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BGraphNode
extends BComponent
implements BIStatus {
    public static final Property status = BGraphNode.newProperty((int)11, (BValue)BStatus.DEFAULT, null);
    public static final Property faultCause = BGraphNode.newProperty((int)3, (String)"", null);
    public static final Property transformInputs = BGraphNode.newProperty((int)10, (BValue)new BStatusSchema(), null);
    public static final Property transformOutput = BGraphNode.newProperty((int)11, (BValue)new BStatusSchema(), null);
    public static final Action schemaCheck = BGraphNode.newAction((int)4, null);
    public static final Topic schemaModified = BGraphNode.newTopic((int)4, null);
    public static final Type TYPE;
    public static final Log log;
    protected static final Lexicon lex;
    protected static final String SCHEMA_FAULT_INVALID_FIELD = "fault.msg.schema.invalidField";
    protected static final String SCHEMA_FAULT_INVALID_TYPE = "fault.msg.schema.invalidType";
    protected static final String SCHEMA_FAULT_UNMATCHED_FIELD = "fault.msg.schema.unmatchedfields";
    protected static final String SCHEMA_FAULT_NO_SOURCES = "fault.msg.schema.nosources";
    private static final String ERR_INVALID_LINK = "graphnode.link.invalidsource";
    private TypeInfo[] illegalChildTypes;
    static /* synthetic */ Class class$javax$baja$seriestransform$graph$BGraphNode;
    static /* synthetic */ Class class$javax$baja$sys$BLink;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BStatusSchema getTransformInputs() {
        return (BStatusSchema)this.get(transformInputs);
    }

    public void setTransformInputs(BStatusSchema bStatusSchema) {
        this.set(transformInputs, (BValue)bStatusSchema, null);
    }

    public BStatusSchema getTransformOutput() {
        return (BStatusSchema)this.get(transformOutput);
    }

    public void setTransformOutput(BStatusSchema bStatusSchema) {
        this.set(transformOutput, (BValue)bStatusSchema, null);
    }

    public void schemaCheck() {
        this.invoke(schemaCheck, null, null);
    }

    public void fireSchemaModified(BSeriesSchema bSeriesSchema) {
        this.fire(schemaModified, (BValue)bSeriesSchema, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BSeriesTransformTable[] resolve(QueryParams queryParams, BOrd bOrd) throws TransformException {
        return this.resolve(queryParams, bOrd, null);
    }

    public final BSeriesTransformTable[] resolve(QueryParams queryParams, BOrd bOrd, Context context) throws TransformException {
        if (queryParams == null) {
            queryParams = new NQueryParameters();
        }
        BSeriesTransformTable[] bSeriesTransformTableArray = this.resolveSources(queryParams, bOrd, context);
        GraphNodeParams graphNodeParams = this.decodeArgs(queryParams);
        return this.doResolve(bSeriesTransformTableArray, graphNodeParams, bOrd, context);
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] bSeriesTransformTableArray, GraphNodeParams graphNodeParams, BOrd bOrd) throws TransformException {
        return null;
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] bSeriesTransformTableArray, GraphNodeParams graphNodeParams, BOrd bOrd, Context context) throws TransformException {
        return this.doResolve(bSeriesTransformTableArray, graphNodeParams, bOrd);
    }

    public abstract BSeriesSchema getSchema();

    public abstract void doCheckSchema() throws ConfigException;

    public final void doSchemaCheck() {
        try {
            this.doCheckSchema();
            this.clearFault();
        }
        catch (ConfigException configException) {
            this.markFault(configException.getMessage());
        }
    }

    private final GraphNodeParams decodeArgs(QueryParams queryParams) {
        String string = this.getSlotPath().getBody();
        NGraphNodeParams nGraphNodeParams = new NGraphNodeParams(queryParams);
        SlotPath[] slotPathArray = queryParams.getSlotPaths();
        int n = 0;
        while (n < slotPathArray.length) {
            SlotPath slotPath = slotPathArray[n];
            String string2 = slotPath.getBody();
            if (string2.startsWith(string)) {
                BValue bValue = queryParams.get(slotPath);
                String string3 = string2.substring(string.length() + 1);
                nGraphNodeParams.put(string3, bValue);
            }
            ++n;
        }
        return nGraphNodeParams;
    }

    private final BSeriesTransformTable[] resolveSources(QueryParams queryParams, BOrd bOrd, Context context) throws TransformException {
        LinkedList<BSeriesTransformTable> linkedList = new LinkedList<BSeriesTransformTable>();
        Class clazz = class$javax$baja$sys$BLink;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BLink = BGraphNode.class("[Ljavax.baja.sys.BLink;", false);
        }
        BLink[] bLinkArray = (BLink[])this.getChildren(clazz);
        int n = 0;
        while (n < bLinkArray.length) {
            BLink bLink = bLinkArray[n];
            bLink.activate();
            String string = bLink.getSourceSlotName();
            BComponent bComponent = bLink.getSourceComponent();
            BValue bValue = bComponent.get(string);
            if (bValue instanceof BStatusSchema && bComponent instanceof BGraphNode) {
                BComponent bComponent2 = this.getParent().asComponent();
                BOrd bOrd2 = bComponent2.getSlotPathOrd();
                BOrd bOrd3 = bComponent.getSlotPathOrd();
                if (bOrd3.equals((Object)bOrd2)) {
                    this.resolveCompositedLinks(queryParams, bOrd, linkedList, (BNodeContainer)bComponent, context);
                } else {
                    BGraphNode bGraphNode = (BGraphNode)bComponent;
                    BSeriesTransformTable[] bSeriesTransformTableArray = bGraphNode.resolve(queryParams, bOrd, context);
                    int n2 = 0;
                    while (n2 < bSeriesTransformTableArray.length) {
                        BSeriesTransformTable bSeriesTransformTable = bSeriesTransformTableArray[n2];
                        linkedList.add(bSeriesTransformTable);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return linkedList.toArray(new BSeriesTransformTable[0]);
    }

    private final void resolveCompositedLinks(QueryParams queryParams, BOrd bOrd, List list, BNodeContainer bNodeContainer, Context context) throws TransformException {
        Class clazz = class$javax$baja$sys$BLink;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BLink = BGraphNode.class("[Ljavax.baja.sys.BLink;", false);
        }
        Object[] objectArray = bNodeContainer.getChildren(clazz);
        int n = 0;
        while (n < objectArray.length) {
            BLink bLink = (BLink)objectArray[n];
            if (bLink.getTargetSlotName().equals("lnk" + this.getName())) {
                bLink.activate();
                BComponent bComponent = bLink.getSourceComponent();
                if (bComponent instanceof BGraphNode) {
                    BGraphNode bGraphNode = (BGraphNode)bComponent;
                    BSeriesTransformTable[] bSeriesTransformTableArray = bGraphNode.resolve(queryParams, bOrd, context);
                    int n2 = 0;
                    while (n2 < bSeriesTransformTableArray.length) {
                        list.add(bSeriesTransformTableArray[n2]);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    public final BGraphNode[] getSources() {
        LinkedList<BGraphNode> linkedList = new LinkedList<BGraphNode>();
        BLink[] bLinkArray = this.getLinks();
        int n = 0;
        while (n < bLinkArray.length) {
            BLink bLink = bLinkArray[n];
            String string = bLink.getSourceSlotName();
            if (string.equals(transformOutput.getName())) {
                try {
                    bLink.activate();
                    BGraphNode bGraphNode = (BGraphNode)bLink.getSourceComponent();
                    linkedList.add(bGraphNode);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return linkedList.toArray(new BGraphNode[0]);
    }

    public final String[] getSrcFieldNames() {
        HashSet<String> hashSet = new HashSet<String>();
        BGraphNode[] bGraphNodeArray = this.getSources();
        int n = 0;
        while (n < bGraphNodeArray.length) {
            BGraphNode bGraphNode = bGraphNodeArray[n];
            String string = bGraphNode.getName();
            BSeriesSchema bSeriesSchema = bGraphNode.getSchema();
            String[] stringArray = bSeriesSchema.getFieldNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                String string3 = string + '.' + string2;
                hashSet.add(string3);
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new String[0]);
    }

    public final void markFault(String string) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(string);
    }

    public final void clearFault() {
        this.setStatus(BStatus.ok);
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformOutput().setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("wiresheet:WireSheet");
        return agentList;
    }

    public final boolean isChildLegal(BComponent bComponent) {
        TypeInfo[] typeInfoArray = this.getIllegalChildTypes();
        TypeInfo typeInfo = bComponent.getType().getTypeInfo();
        int n = 0;
        while (n < typeInfoArray.length) {
            if (typeInfo == typeInfoArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNodeContainer;
    }

    public final TypeInfo[] getIllegalChildTypes() {
        return this.illegalChildTypes;
    }

    public final void setIllegalChildTypes(TypeInfo[] typeInfoArray) {
        this.illegalChildTypes = typeInfoArray;
    }

    protected final LinkCheck doCheckLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        BValue bValue;
        Type type;
        BValue bValue2 = this.get(slot2.getName());
        if (bValue2 != null && (type = bValue2.getType()) == BStatusSchema.TYPE && (bValue = bComponent.get(slot.getName())) != null) {
            boolean bl;
            Type type2 = bValue.getType();
            String string = slot.getName();
            String string2 = slot2.getName();
            boolean bl2 = false;
            if (type == BStatusSchema.TYPE && type2 == BStatusSchema.TYPE && !string.equals(string2)) {
                bl2 = true;
            }
            if (!(bl = bl2) || bl && this == bComponent) {
                return LinkCheck.makeInvalid((String)lex.getText(ERR_INVALID_LINK));
            }
        }
        return super.doCheckLink(bComponent, slot, slot2, context);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 3: {
                BLink bLink;
                Property property;
                if (!(object instanceof Property) || !(property = (Property)object).getType().equals(BLink.TYPE) || !this.isInputSchemaLink(bLink = (BLink)this.get(property))) break;
                this.checkForSchemaChange();
                break;
            }
            case 4: {
                BLink bLink;
                if (!(object2 instanceof BLink) || !this.isInputSchemaLink(bLink = (BLink)object2)) break;
                this.checkForSchemaChange();
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final boolean isInputSchemaLink(BLink bLink) {
        boolean bl = false;
        String string = bLink.getSourceSlotName();
        if (string.equals(transformOutput.getName())) {
            bl = true;
        }
        return bl;
    }

    private final void checkForSchemaChange() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BNodeContainer) {
                ((BNodeContainer)bComplex).forceSchemaCheck();
                break;
            }
            bComplex = bComplex.getParent();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.illegalChildTypes = Sys.getRegistry().getTypes(TYPE.getTypeInfo());
    }

    public BGraphNode() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$seriestransform$graph$BGraphNode;
        if (clazz == null) {
            clazz = class$javax$baja$seriestransform$graph$BGraphNode = BGraphNode.class("[Ljavax.baja.seriestransform.graph.BGraphNode;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"seriesTransform");
        Class clazz2 = class$javax$baja$seriestransform$graph$BGraphNode;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$seriestransform$graph$BGraphNode = BGraphNode.class("[Ljavax.baja.seriestransform.graph.BGraphNode;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

