/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.scale;

import com.tridium.seriestransform.IntervalSeriesCursor;
import java.util.Map;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Slot;
import javax.baja.util.IFilter;

public class ScaleCursor
extends IntervalSeriesCursor {
    private Map scaleFactors;
    private Cursor innerCursor;
    private BComplex currentRecord;
    private IFilter filter;
    private String[] fieldNames;

    public double getDouble(Column column) {
        BValue bValue;
        BDouble bDouble = this.getScaleFactor(column.getName());
        BComplex bComplex = (BComplex)this.get();
        if (bDouble != null && bComplex != null && (bValue = bComplex.get(column.getName())) != null && bValue instanceof BNumber) {
            double d = ((BNumber)bValue).getDouble();
            Double d2 = new Double(bDouble.getDouble() * d);
            return d2;
        }
        return Double.NaN;
    }

    public BFacets getFacets(Column column) {
        Slot slot;
        BComplex bComplex = (BComplex)this.get();
        if (bComplex != null && (slot = bComplex.getSlot(column.getName())) != null) {
            return bComplex.getSlotFacets(slot);
        }
        return BFacets.NULL;
    }

    public float getFloat(Column column) {
        BValue bValue;
        BDouble bDouble = this.getScaleFactor(column.getName());
        BComplex bComplex = (BComplex)this.get();
        if (bDouble != null && bComplex != null && (bValue = bComplex.get(column.getName())) != null && bValue instanceof BNumber) {
            double d = ((BNumber)bValue).getDouble();
            Double d2 = new Double(bDouble.getDouble() * d);
            return d2.floatValue();
        }
        return Float.NaN;
    }

    public int getInt(Column column) {
        BValue bValue;
        BDouble bDouble = this.getScaleFactor(column.getName());
        BComplex bComplex = (BComplex)this.get();
        if (bDouble != null && bComplex != null && (bValue = bComplex.get(column.getName())) != null && bValue instanceof BNumber) {
            double d = ((BNumber)bValue).getDouble();
            Double d2 = new Double(bDouble.getDouble() * d);
            return d2.intValue();
        }
        return Integer.MIN_VALUE;
    }

    public long getLong(Column column) {
        BValue bValue;
        BDouble bDouble = this.getScaleFactor(column.getName());
        BComplex bComplex = (BComplex)this.get();
        if (bDouble != null && bComplex != null && (bValue = bComplex.get(column.getName())) != null && bValue instanceof BNumber) {
            double d = ((BNumber)bValue).getDouble();
            Double d2 = new Double(bDouble.getDouble() * d);
            return d2.longValue();
        }
        return Long.MIN_VALUE;
    }

    public BObject get() {
        return this.currentRecord;
    }

    public boolean next() {
        if (this.innerCursor.next()) {
            this.currentRecord = (BComplex)this.innerCursor.get();
            if (this.filter != null && !this.filter.accept((Object)this.currentRecord)) {
                return this.next();
            }
            int n = 0;
            while (n < this.fieldNames.length) {
                String string = this.fieldNames[n];
                BValue bValue = this.currentRecord.get(string);
                BValue bValue2 = this.scaleValue(string, bValue);
                this.currentRecord.set(string, bValue2);
                ++n;
            }
            return true;
        }
        return false;
    }

    private final BDouble getScaleFactor(String string) {
        if (this.scaleFactors != null && this.scaleFactors.containsKey(string)) {
            Object v = this.scaleFactors.get(string);
            if (v instanceof Double) {
                Double d = (Double)v;
                return BDouble.make((double)d);
            }
            if (v instanceof BDouble) {
                return (BDouble)v;
            }
        }
        return null;
    }

    private final BValue scaleValue(String string, BValue bValue) {
        BDouble bDouble = this.getScaleFactor(string);
        if (bDouble != null && bValue instanceof BNumber) {
            BNumber bNumber = (BNumber)bValue;
            if (bValue instanceof BLong) {
                return BLong.make((long)(bDouble.getLong() * bNumber.getLong()));
            }
            if (bValue instanceof BFloat) {
                return BFloat.make((float)(bDouble.getFloat() * bNumber.getFloat()));
            }
            if (bValue instanceof BInteger) {
                return BInteger.make((int)(bDouble.getInt() * bNumber.getInt()));
            }
            if (bValue instanceof BDouble) {
                return BDouble.make((double)(bDouble.getDouble() * bNumber.getDouble()));
            }
        }
        return bValue;
    }

    public ScaleCursor(BSeriesSchema bSeriesSchema, BITable bITable, Map map) {
        this(bSeriesSchema, bITable, map, null);
    }

    public ScaleCursor(BSeriesSchema bSeriesSchema, BITable bITable, Map map, IFilter iFilter) {
        this.fieldNames = bSeriesSchema.getFieldNames();
        this.scaleFactors = map;
        this.innerCursor = bITable.cursor();
        this.filter = iFilter;
    }
}

