/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.quantize;

import com.tridium.collection.BGenericTable;
import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import java.util.LinkedList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.util.IFilter;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuantizationCursor
extends IntervalSeriesCursor {
    private static final String ERR_UNORDERED_TIMESTAMPS = "cursors.quantization.interval.unordered";
    private static final String ERR_SMALL_INTERVAL = lex.getText("cursors.quantization.interval.toosmall");
    private static final String ERR_INVALID_SCHEMA = lex.getText("fault.msg.invalidIntervalSchema");
    private BComponent currentRecord;
    private BITable timeSeries;
    private Cursor innerCursor;
    private String keyField;
    private BRelTime definedInterval;
    private BSeriesIntervalEnum intervalType;
    private boolean isNextAvailable;

    protected void initTimes() {
        super.initTimes(this.timeSeries.toTable());
        this.intervalDefined = this.intervalType != BSeriesIntervalEnum.auto && (this.intervalType != BSeriesIntervalEnum.custom || this.definedInterval.getMillis() >= 1000L);
        if (!this.intervalDefined) {
            this.makeDefaultInterval();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean next() {
        if (this.isNextAvailable) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(this.innerCursor.get() instanceof BComplex)) continue;
            var1_1 = (BComplex)this.innerCursor.get();
            if (this.filter != null && !this.filter.accept((Object)var1_1)) {
                return this.next();
            }
            var2_2 = (BAbsTime)var1_1.get(this.keyField);
            if (var2_2 == null || var2_2.equals((Object)BAbsTime.DEFAULT)) continue;
            if (this.intervalStartTime == null || this.intervalStartTime == BAbsTime.DEFAULT) {
                var3_3 = this.makeBaselineTimestamp(var2_2);
                this.initInterval(var3_3);
            }
            if (this.intervalCalibrated(var2_2)) {
                var1_1.set(this.keyField, (BValue)this.intervalStartTime);
                QuantizationCursor.copyRecord(var1_1, this.currentRecord);
                return true;
            }
            return false;
lbl17:
            // 3 sources

            ** while (this.isNextAvailable = this.innerCursor.next())
        }
lbl18:
        // 1 sources

        return false;
    }

    public BObject get() {
        return this.currentRecord;
    }

    private final BAbsTime makeBaselineTimestamp(BAbsTime bAbsTime) {
        if (this.intervalType == BSeriesIntervalEnum.yearly) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)BMonth.january, (int)1);
        }
        if (this.intervalType == BSeriesIntervalEnum.monthly) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)1);
        }
        if (this.intervalType == BSeriesIntervalEnum.daily || this.definedInterval.getDays() > 0) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay());
        }
        if (this.intervalType == BSeriesIntervalEnum.hourly || this.definedInterval.getHours() > 0) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)0);
        }
        if (this.intervalType == BSeriesIntervalEnum.thirtyMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 30);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (this.intervalType == BSeriesIntervalEnum.fifteenMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 15);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (this.intervalType == BSeriesIntervalEnum.fiveMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 5);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (this.definedInterval.getMinutes() > 0) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), this.definedInterval.getMinutes());
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (this.definedInterval.getSeconds() > 0) {
            int n = this.getBaseQuantum(bAbsTime.getSecond(), this.definedInterval.getSeconds());
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)n, (int)0);
        }
        if (this.definedInterval.getMillis() > 0L) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)0);
        }
        return bAbsTime;
    }

    private final int getBaseQuantum(int n, int n2) {
        if (n2 == 0 || n == 0) {
            return 0;
        }
        return n / n2 * n2;
    }

    private final boolean intervalCalibrated(BAbsTime bAbsTime) {
        if (bAbsTime == null) {
            return false;
        }
        if (this.intervalStartTime == null && this.intervalEndTime == null) {
            return true;
        }
        if (this.intervalStartTime == null && this.intervalEndTime != null) {
            return bAbsTime.isBefore(this.intervalEndTime);
        }
        if (this.intervalStartTime != null && this.intervalEndTime == null) {
            return !bAbsTime.isBefore(this.intervalStartTime);
        }
        if (this.intervalStartTime != null && this.intervalStartTime.getMillis() <= bAbsTime.getMillis() && bAbsTime.isBefore(this.intervalEndTime)) {
            return true;
        }
        if (bAbsTime.getMillis() >= this.intervalEndTime.getMillis()) {
            if (bAbsTime.getMillis() - this.intervalEndTime.getMillis() > this.definedInterval.getMillis()) {
                bAbsTime = this.makeBaselineTimestamp(bAbsTime);
                this.initInterval(bAbsTime);
            } else {
                this.updateIntervalPeriod();
            }
            return this.intervalCalibrated(bAbsTime);
        }
        if (bAbsTime.isBefore(this.intervalStartTime)) {
            String string = lex.getText(ERR_UNORDERED_TIMESTAMPS, new Object[]{bAbsTime});
            log.error(string);
            throw new RuntimeException(string);
        }
        return false;
    }

    protected void initInterval(BAbsTime bAbsTime) {
        this.intervalStartTime = bAbsTime;
        switch (this.intervalType.getOrdinal()) {
            case 0: {
                if (!this.intervalDefined) {
                    this.makeDefaultInterval();
                }
                if (!this.intervalDefined) break;
                this.intervalEndTime = this.intervalStartTime.add(this.definedInterval);
                break;
            }
            case 1: {
                this.intervalEndTime = this.intervalStartTime.add(this.definedInterval);
                break;
            }
            case 2: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)5));
                break;
            }
            case 3: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)15));
                break;
            }
            case 4: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)30));
                break;
            }
            case 5: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.HOUR);
                break;
            }
            case 6: {
                this.intervalEndTime = this.intervalStartTime.nextDay();
                break;
            }
            case 7: {
                this.intervalEndTime = this.intervalStartTime.nextMonth();
                break;
            }
            case 8: {
                this.intervalEndTime = this.intervalStartTime.nextYear();
                break;
            }
        }
    }

    protected void makeDefaultInterval() {
        TableCursor tableCursor;
        int n;
        Cursor cursor = this.timeSeries.cursor();
        LinkedList<BRelTime> linkedList = new LinkedList<BRelTime>();
        BAbsTime bAbsTime = BAbsTime.DEFAULT;
        int n2 = 100;
        if (cursor instanceof TableCursor && (n2 = (int)((double)(n = (tableCursor = (TableCursor)cursor).getTable().size()) * 0.1)) <= 1) {
            n2 = n;
        }
        while (cursor.next() && linkedList.size() < n2) {
            tableCursor = (BComplex)cursor.get();
            BAbsTime bAbsTime2 = (BAbsTime)tableCursor.get(this.keyField);
            if (bAbsTime2 == null) {
                throw new BajaRuntimeException(ERR_INVALID_SCHEMA);
            }
            if (bAbsTime != BAbsTime.DEFAULT) {
                BRelTime bRelTime = bAbsTime.delta(bAbsTime2);
                if (bRelTime.getSeconds() > 0) {
                    linkedList.add(bRelTime);
                } else {
                    linkedList.add(BRelTime.makeSeconds((int)1));
                }
            }
            bAbsTime = bAbsTime2;
        }
        int n3 = linkedList.size();
        if (n3 == 0) {
            this.intervalDefined = false;
            return;
        }
        Object[] objectArray = new BRelTime[n3];
        int n4 = 0;
        BRelTime bRelTime = linkedList.iterator();
        while (bRelTime.hasNext()) {
            objectArray[n4] = (BRelTime)bRelTime.next();
            ++n4;
        }
        SortUtil.sort((Object[])objectArray);
        bRelTime = BRelTime.DEFAULT;
        if (n3 % 2 == 1) {
            int n5 = (int)Math.floor(n3 / 2);
            bRelTime = BRelTime.makeSeconds((int)objectArray[n5].getSeconds());
        } else {
            Object object = objectArray[n3 / 2];
            Object object2 = objectArray[n3 / 2 - 1];
            long l = (object.getMillis() + object2.getMillis()) / (long)2;
            BRelTime bRelTime2 = BRelTime.make((long)l);
            bRelTime = BRelTime.makeSeconds((int)bRelTime2.getSeconds());
        }
        if (bRelTime == BRelTime.DEFAULT) {
            throw new RuntimeException(ERR_SMALL_INTERVAL);
        }
        this.definedInterval = bRelTime;
        this.intervalType = BSeriesIntervalEnum.custom;
        this.intervalDefined = true;
    }

    protected void updateIntervalPeriod() {
        switch (this.intervalType.getOrdinal()) {
            case 0: 
            case 1: {
                this.intervalStartTime = this.intervalStartTime.add(this.definedInterval);
                this.intervalEndTime = this.intervalEndTime.add(this.definedInterval);
                break;
            }
            case 8: {
                this.intervalStartTime = this.intervalStartTime.nextYear();
                this.intervalEndTime = this.intervalEndTime.nextYear();
                break;
            }
            case 7: {
                this.intervalStartTime = this.intervalStartTime.nextMonth();
                this.intervalEndTime = this.intervalEndTime.nextMonth();
                break;
            }
            case 6: {
                this.intervalStartTime = this.intervalStartTime.nextDay();
                this.intervalEndTime = this.intervalEndTime.nextDay();
                break;
            }
            case 5: {
                this.intervalStartTime = this.intervalStartTime.add(BRelTime.HOUR);
                this.intervalEndTime = this.intervalEndTime.add(BRelTime.HOUR);
                break;
            }
            case 4: {
                this.intervalStartTime = this.intervalStartTime.add(THIRTY_MIN);
                this.intervalEndTime = this.intervalEndTime.add(THIRTY_MIN);
                break;
            }
            case 3: {
                this.intervalStartTime = this.intervalStartTime.add(FIFTEEN_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIFTEEN_MIN);
                break;
            }
            case 2: {
                this.intervalStartTime = this.intervalStartTime.add(FIVE_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIVE_MIN);
                break;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.currentRecord = new BComponent();
        this.definedInterval = BRelTime.DEFAULT;
        this.intervalType = BSeriesIntervalEnum.auto;
        this.isNextAvailable = true;
    }

    public QuantizationCursor(BSeriesSchema bSeriesSchema, BComponent[] bComponentArray, BSeriesInterval bSeriesInterval) {
        this(bSeriesSchema, (BITable)new BGenericTable(bComponentArray), bSeriesInterval);
    }

    public QuantizationCursor(BSeriesSchema bSeriesSchema, BITable bITable, BSeriesInterval bSeriesInterval) {
        this(bSeriesSchema, bITable, bSeriesInterval, null);
    }

    public QuantizationCursor(BSeriesSchema bSeriesSchema, BITable bITable, BSeriesInterval bSeriesInterval, IFilter iFilter) {
        this.this();
        this.timeSeries = bITable;
        this.definedInterval = bSeriesInterval.getTime();
        this.intervalType = bSeriesInterval.getDesc();
        this.filter = iFilter;
        this.innerCursor = bITable.cursor();
        this.currentRecord = QuantizationCursor.createTemplateRecord(bSeriesSchema);
        this.keyField = bSeriesSchema.getKeyField();
        this.initTimes();
    }
}

