/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite;

import com.tridium.seriestransform.composite.BCompositeConfig;
import com.tridium.seriestransform.composite.BCompositeMap;
import com.tridium.seriestransform.composite.BCompositeMapping;
import com.tridium.seriestransform.composite.BCompositeNode;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.seriestransform.graph.ui.BSchemaConfigEditor;
import com.tridium.seriestransform.source.BHistorySourceNode;
import com.tridium.seriestransform.terminal.BTerminalConfig;
import com.tridium.ui.BRoundedPopup;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCompositeBuilder
extends BSchemaConfigEditor {
    public static final Type TYPE;
    public static final Lexicon lex;
    public static final String TITLE;
    public static final String DISPLAY_HEADER;
    private static final String ERR_MISMATCHED_KEYS;
    private Set outputFields;
    private BGraphNode srcNode;
    private String[] inputFields;
    private BCompositeMap compositeMap;
    private boolean readonly;
    static /* synthetic */ Class class$com$tridium$seriestransform$composite$BCompositeBuilder;
    static /* synthetic */ Class class$com$tridium$seriestransform$composite$BCompositeMapping;

    public Type getType() {
        return TYPE;
    }

    public static BCompositeMap open(BWidget bWidget, BCompositeNode bCompositeNode) {
        return BCompositeBuilder.open(bWidget, bCompositeNode, false);
    }

    public static BCompositeMap open(BWidget bWidget, BCompositeNode bCompositeNode, boolean bl) {
        if (bCompositeNode == null) {
            return null;
        }
        BCompositeBuilder bCompositeBuilder = new BCompositeBuilder(bCompositeNode);
        bCompositeBuilder.setReadonly(bl);
        int n = BRoundedPopup.open((BWidget)bWidget, (String)bCompositeNode.getDisplayName(null), (Object)((Object)bCompositeBuilder), (int)3);
        if (n == 2) {
            return null;
        }
        return bCompositeBuilder.getCompositeMappings();
    }

    private final void createKeyDisplay() {
        Object object;
        BGraphNode[] bGraphNodeArray = this.srcNode.getSources();
        String string = null;
        BFacets bFacets = BFacets.DEFAULT;
        int n = 0;
        while (n < bGraphNodeArray.length) {
            object = bGraphNodeArray[n];
            object.lease(3);
            BSeriesSchema bSeriesSchema = object.getSchema();
            String string2 = bSeriesSchema.getKeyField();
            BFacets bFacets2 = bSeriesSchema.getFieldFacets(string2);
            if (string == null) {
                string = string2;
                bFacets = bFacets2;
            } else if (!string.equals(string2)) {
                BGraphNode.log.error(ERR_MISMATCHED_KEYS);
            } else {
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets2);
            }
            ++n;
        }
        if (string == null || this.outputFields.contains(string)) {
            return;
        }
        String string3 = "";
        if (bFacets != null) {
            try {
                string3 = bFacets.toString((Context)bFacets);
            }
            catch (RuntimeException runtimeException) {
                log.error(runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }
        object = new BTerminalConfig(string, string, string3);
        this.outputFields.add(string);
        this.addConfig((BConfigItem)((Object)object), new Command[0]);
    }

    private final void loadCompositeMaps() {
        this.compositeMap.lease(2);
        Class clazz = class$com$tridium$seriestransform$composite$BCompositeMapping;
        if (clazz == null) {
            clazz = class$com$tridium$seriestransform$composite$BCompositeMapping = BCompositeBuilder.class("[Lcom.tridium.seriestransform.composite.BCompositeMapping;", false);
        }
        Object[] objectArray = this.compositeMap.getChildren(clazz);
        int n = 0;
        while (n < objectArray.length) {
            BCompositeMapping bCompositeMapping = (BCompositeMapping)((Object)objectArray[n]);
            String string = bCompositeMapping.getInputField();
            String string2 = bCompositeMapping.getSrcSeries() + '.' + string;
            String string3 = SlotPath.unescape((String)bCompositeMapping.getOutputField());
            BFacets bFacets = bCompositeMapping.getFieldFacets();
            this.makeConfig(string2, string3, bFacets);
            ++n;
        }
        this.validateConfig();
    }

    private final void makeConfig(String string, String string2, BFacets bFacets) {
        if (string2 != null && this.outputFields.contains(string2)) {
            return;
        }
        BCompositeConfig bCompositeConfig = null;
        if (string2 != null && string != null) {
            bCompositeConfig = new BCompositeConfig(this.inputFields, string, string2, bFacets);
            this.outputFields.add(string2);
        } else {
            bCompositeConfig = new BCompositeConfig(this.inputFields);
        }
        this.linkTo((BComponent)bCompositeConfig, (Slot)BCompositeConfig.modified, (Slot)setModified);
        this.showConfig(bCompositeConfig);
    }

    private final void showConfig(BCompositeConfig bCompositeConfig) {
        this.rows.add(bCompositeConfig);
        this.addConfig(bCompositeConfig, new Command[]{new RemoveMappingCmd((BWidget)this, bCompositeConfig)});
    }

    private final String[] getCompositeFields() {
        HashSet<String> hashSet = new HashSet<String>();
        BGraphNode[] bGraphNodeArray = this.srcNode.getSources();
        int n = 0;
        while (n < bGraphNodeArray.length) {
            BGraphNode bGraphNode = bGraphNodeArray[n];
            String string = bGraphNode.getName();
            BSeriesSchema bSeriesSchema = bGraphNode.getSchema();
            String string2 = bSeriesSchema.getKeyField();
            String[] stringArray = bSeriesSchema.getFieldNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                if (!string3.equals(string2)) {
                    String string4 = string + '.' + string3;
                    hashSet.add(string4);
                }
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new String[0]);
    }

    public BCompositeMap getCompositeMappings() {
        BCompositeMap bCompositeMap = new BCompositeMap();
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            BCompositeConfig bCompositeConfig = (BCompositeConfig)((Object)iterator.next());
            String string = bCompositeConfig.getInputField();
            String string2 = bCompositeConfig.getOutputField();
            BFacets bFacets = bCompositeConfig.getFieldFacets();
            String[] stringArray = TextUtil.split((String)string, (char)'.');
            String string3 = null;
            if (stringArray.length > 1) {
                string3 = stringArray[0];
                string = stringArray[1];
            }
            BCompositeMapping bCompositeMapping = new BCompositeMapping();
            bCompositeMapping.setInputField(string);
            bCompositeMapping.setSrcSeries(string3);
            bCompositeMapping.setOutputField(string2);
            bCompositeMapping.setFieldFacets(bFacets);
            bCompositeMap.add(null, (BValue)bCompositeMapping);
        }
        return bCompositeMap;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            BCompositeConfig bCompositeConfig = (BCompositeConfig)((Object)iterator.next());
            bCompositeConfig.setReadonly(bl);
        }
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public boolean doValidate() {
        boolean bl = super.doValidate();
        if (bl) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                BCompositeConfig bCompositeConfig = (BCompositeConfig)((Object)iterator.next());
                if (!bCompositeConfig.getInvalidSrc()) continue;
                return false;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.outputFields = new HashSet();
        this.readonly = false;
    }

    public BCompositeBuilder() {
        this.this();
    }

    public BCompositeBuilder(BCompositeNode bCompositeNode) {
        this.this();
        this.srcNode = bCompositeNode;
        this.compositeMap = ((BCompositeNode)this.srcNode).getMappings();
        this.inputFields = this.getCompositeFields();
        BWidget bWidget = this.buildTableDisplay(DISPLAY_HEADER, new Command[]{new PopulateDefaultsCmd((BWidget)this, this.srcNode), new AddMappingCmd((BWidget)this)});
        this.setCenter(bWidget);
        this.createKeyDisplay();
        this.loadCompositeMaps();
    }

    static {
        Class clazz = class$com$tridium$seriestransform$composite$BCompositeBuilder;
        if (clazz == null) {
            clazz = class$com$tridium$seriestransform$composite$BCompositeBuilder = BCompositeBuilder.class("[Lcom.tridium.seriestransform.composite.BCompositeBuilder;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$seriestransform$composite$BCompositeBuilder;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$seriestransform$composite$BCompositeBuilder = BCompositeBuilder.class("[Lcom.tridium.seriestransform.composite.BCompositeBuilder;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        TITLE = lex.getText("composite.builder.title");
        DISPLAY_HEADER = lex.getText("outputSchemaEditor.schema");
        ERR_MISMATCHED_KEYS = lex.getText("fault.msg.schema.invalidkeys");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RemoveMappingCmd
    extends Command {
        BCompositeConfig elem;

        public BImage getIcon() {
            return minusIcon;
        }

        public CommandArtifact doInvoke() {
            BCompositeBuilder.this.rows.remove((Object)this.elem);
            BCompositeBuilder.this.removeConfig((BWidget)this.elem);
            BCompositeBuilder.this.setModified();
            String string = this.elem.getOutputField();
            BCompositeBuilder.this.outputFields.remove(string);
            BCompositeBuilder.this.validateConfig();
            return null;
        }

        public RemoveMappingCmd(BWidget bWidget, BCompositeConfig bCompositeConfig) {
            super(bWidget, "");
            this.elem = bCompositeConfig;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PopulateDefaultsCmd
    extends Command {
        private BGraphNode src;

        public CommandArtifact doInvoke() {
            BGraphNode[] bGraphNodeArray;
            HashSet<String> hashSet = new HashSet<String>();
            Object object = BCompositeBuilder.this.rows.iterator();
            while (object.hasNext()) {
                bGraphNodeArray = (BGraphNode[])object.next();
                String string = bGraphNodeArray.getInputField();
                hashSet.add(string);
            }
            object = new Hashtable();
            bGraphNodeArray = this.src.getSources();
            int n = 0;
            while (n < bGraphNodeArray.length) {
                BGraphNode bGraphNode = bGraphNodeArray[n];
                object.put(bGraphNode.getName(), bGraphNode);
                ++n;
            }
            String[] stringArray = BCompositeBuilder.this.getCompositeFields();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                if (!hashSet.contains(string)) {
                    String[] stringArray2 = TextUtil.split((String)string, (char)'.');
                    String string2 = stringArray2[0];
                    String string3 = stringArray2[1];
                    BGraphNode bGraphNode = (BGraphNode)((Object)object.get(string2));
                    bGraphNode.lease();
                    BSeriesSchema bSeriesSchema = bGraphNode.getSchema();
                    bSeriesSchema.lease();
                    BFacets bFacets = bSeriesSchema.getFieldFacets(string3);
                    String string4 = null;
                    string4 = this.getOrigin(bGraphNode, string3);
                    if (string4 == null) {
                        string4 = string2;
                    }
                    string4 = string4 + '_' + string3;
                    BCompositeBuilder.this.makeConfig(string, string4, bFacets);
                    BCompositeBuilder.this.setModified();
                }
                ++n2;
            }
            return null;
        }

        private final String getOrigin(BGraphNode bGraphNode, String string) {
            if (bGraphNode instanceof BHistorySourceNode) {
                BSeriesSchema bSeriesSchema = bGraphNode.getSchema();
                if (bSeriesSchema.get(string) != null) {
                    return bGraphNode.getName();
                }
            } else {
                BGraphNode[] bGraphNodeArray = bGraphNode.getSources();
                if (bGraphNodeArray.length == 1) {
                    return this.getOrigin(bGraphNodeArray[0], string);
                }
            }
            return null;
        }

        public BImage getIcon() {
            return BConfigEditor.populateDefaults;
        }

        public PopulateDefaultsCmd(BWidget bWidget, BGraphNode bGraphNode) {
            super(bWidget, "");
            this.src = bGraphNode;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AddMappingCmd
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BCompositeBuilder.this.makeConfig(null, null, BFacets.DEFAULT);
            BCompositeBuilder.this.setModified();
            return null;
        }

        public BImage getIcon() {
            return addIcon;
        }

        public AddMappingCmd(BWidget bWidget) {
            super(bWidget, "");
        }
    }
}

