/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc.jni.client.da;

import com.tridium.opc.OpcException;
import com.tridium.opc.jni.client.common.OpcServer;
import com.tridium.opc.jni.client.da.OpcBrowse;
import com.tridium.opc.jni.client.da.OpcBrowseServerAddressSpace;
import com.tridium.opc.jni.client.da.OpcGroup;
import com.tridium.opc.jni.client.da.OpcItemProperties;
import com.tridium.opc.jni.client.da.OpcNTSecurity;
import com.tridium.opc.jni.client.da.OpcPrivateSecurity;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OpcDaServer
extends OpcServer {
    private TreeMap groups;

    public synchronized OpcGroup addGroup(String string, boolean bl, int n, int n2, int n3, float f, int n4) {
        OpcGroup opcGroup = (OpcGroup)this.groups.get(string);
        if (opcGroup != null) {
            return opcGroup;
        }
        int[] nArray = this.addGroup(this.peer, string, bl, n, n2, n3, f, n4);
        if (nArray != null && nArray.length >= 3) {
            opcGroup = new OpcGroup(string, nArray[0]);
            opcGroup.serverHandle = nArray[1];
            opcGroup.revisedUpdateRate = nArray[2];
            this.groups.put(string, opcGroup);
        }
        return opcGroup;
    }

    public OpcBrowse getBrowse() {
        return (OpcBrowse)this.query(OpcBrowse.IID);
    }

    public OpcBrowseServerAddressSpace getBrowseServerAddressSpace() {
        return (OpcBrowseServerAddressSpace)this.query(OpcBrowseServerAddressSpace.IID);
    }

    public OpcItemProperties getItemProperties() {
        return (OpcItemProperties)this.query(OpcItemProperties.IID);
    }

    public OpcGroup getGroup(String string) {
        return (OpcGroup)this.groups.get(string);
    }

    public Status getStatus() {
        Status status = new Status();
        this.getStatus(this.peer, status);
        return status;
    }

    public static OpcDaServer newServer(String string) throws OpcException {
        OpcDaServer opcDaServer = new OpcDaServer();
        opcDaServer.peer = opcDaServer.createLocalServer(string);
        return opcDaServer;
    }

    public static OpcDaServer newServer(String string, String string2) throws OpcException {
        OpcDaServer opcDaServer = new OpcDaServer();
        opcDaServer.peer = opcDaServer.createRemoteServer(string, string2);
        return opcDaServer;
    }

    public void release() {
        try {
            TreeMap treeMap = new TreeMap();
            treeMap.putAll(treeMap);
            Iterator iterator = treeMap.values().iterator();
            while (iterator.hasNext()) {
                OpcGroup opcGroup = (OpcGroup)iterator.next();
                this.removeGroup(opcGroup);
            }
        }
        catch (Exception exception) {}
        this.groups.clear();
        super.release();
    }

    public void removeGroup(OpcGroup opcGroup) {
        this.groups.remove(opcGroup.getName());
        opcGroup.realRelease();
        this.removeGroup(this.peer, opcGroup.serverHandle, true);
    }

    public OpcNTSecurity getNTSecurity() {
        return (OpcNTSecurity)this.query(OpcNTSecurity.IID);
    }

    public OpcPrivateSecurity getPrivateSecurity() {
        return (OpcPrivateSecurity)this.query(OpcPrivateSecurity.IID);
    }

    public long getPeerObject() {
        return this.getPeer();
    }

    private final native int[] addGroup(long var1, String var3, boolean var4, int var5, int var6, int var7, float var8, int var9);

    private final native int createLocalServer(String var1);

    private final native int createRemoteServer(String var1, String var2);

    private final native void getStatus(long var1, Status var3);

    private final native void removeGroup(long var1, int var3, boolean var4);

    private final /* synthetic */ void this() {
        this.groups = new TreeMap();
    }

    public OpcDaServer() {
        this.this();
    }

    public static class Status {
        public static final int STATE_RUNNING = 1;
        public static final int STATE_FAILED = 2;
        public static final int STATE_NOCONFIG = 3;
        public static final int STATE_SUSPENDED = 4;
        public static final int STATE_TEST = 5;
        public static final int STATE_COMM_FAULT = 6;
        public long startTime;
        public long currentTime;
        public long lastUpdateTime;
        public int state;
        public int groupCount;
        public int bandwidth;
        public int majorVersion;
        public int minorVersion;
        public int buildNumber;
        public String vendorInfo;

        public String getStatusString() {
            switch (this.state) {
                case 1: {
                    return "Running";
                }
                case 2: {
                    return "Failed";
                }
                case 3: {
                    return "No Config";
                }
                case 4: {
                    return "Suspended";
                }
                case 5: {
                    return "Test";
                }
                case 6: {
                    return "Comm fault";
                }
            }
            return "Unknown: " + this.state;
        }

        public void init(long l, long l2, long l3, int n, int n2, int n3, int n4, int n5, int n6, String string) {
            this.startTime = l;
            this.currentTime = l2;
            this.lastUpdateTime = l3;
            this.state = n;
            this.groupCount = n2;
            this.bandwidth = n3;
            this.majorVersion = n4;
            this.minorVersion = n5;
            this.buildNumber = n6;
            this.vendorInfo = string;
        }
    }
}

