/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opc;

import com.tridium.opc.OpcException;

public class OpcEnv {
    public static final int CO_E_CLASSSTRING = -2147221005;
    public static final int CO_E_NOTINITIALIZED = -2147221008;
    public static final int CO_E_RUNAS_LOGIN_FAILURE = -2147467238;
    public static final int DISP_E_TYPEMISMATCH = -2147352571;
    public static final int E_ABORT = -2147467260;
    public static final int E_ACCESSDENIED = -2147024891;
    public static final int E_FAIL = -2147467259;
    public static final int E_HANDLE = -2147024890;
    public static final int E_INVALIDARG = -2147024809;
    public static final int E_NOTIMPL = -2147467263;
    public static final int E_NOINTERFACE = -2147467262;
    public static final int E_OUTOFMEMORY = -2147024882;
    public static final int E_PENDING = -2147483638;
    public static final int E_POINTER = -2147467261;
    public static final int E_UNEXPECTED = -2147418113;
    public static final int OPC_E_INVALIDHANDLE = -1073479679;
    public static final int OPC_E_BADTYPE = -1073479676;
    public static final int OPC_E_PUBLIC = -1073479675;
    public static final int OPC_E_BADRIGHTS = -1073479674;
    public static final int OPC_E_UNKNOWNITEMID = -1073479673;
    public static final int OPC_E_INVALIDITEMID = -1073479672;
    public static final int OPC_E_INVALIDFILTER = -1073479671;
    public static final int OPC_E_UNKNOWNPATH = -1073479670;
    public static final int OPC_E_RANGE = -1073479669;
    public static final int OPC_E_DUPLICATENAME = -1073479668;
    public static final int OPC_S_UNSUPPORTEDRATE = 262157;
    public static final int OPC_S_CLAMP = 262158;
    public static final int OPC_S_INUSE = 262159;
    public static final int OPC_E_INVALIDCONFIGFILE = -1073479664;
    public static final int OPC_E_NOTFOUND = -1073479663;
    public static final int OPC_E_INVALID_PID = -1073479165;
    public static final int OPC_E_DEADBANDNOTSET = -1073478656;
    public static final int OPC_E_DEADBANDNOTSUPPORTED = -1073478655;
    public static final int OPC_E_NOBUFFERING = -1073478654;
    public static final int OPC_E_INVALIDCONTINUATIONPOINT = -1073478653;
    public static final int OPC_S_DATAQUEUEOVERFLOW = 263172;
    public static final int OPC_E_RATENOTSET = -1073478651;
    public static final int OPC_E_NOTSUPPORTED = -1073478650;
    public static final int REGDB_E_CLASSNOTREG = -2147221164;
    public static final int RPC_E_DISCONNECTED = -2147417848;
    public static final int RPC_SERVER_NOT_AVAIL = -2147023174;
    public static final int RPC_CANNOT_START_SERVICE = -2147023838;
    public static final int RPC_CALL_FAILED = -2147023169;
    public static final int S_OK = 0;
    public static final int S_FALSE = 1;
    public static final int NUMERIC_TYPE = 1;
    public static final int BOOLEAN_TYPE = 2;
    public static final int STRING_TYPE = 3;
    public static final int INVALID_TYPE = 4;
    static Log log;
    private static ThreadLocal inited;

    public static String getDescription(int n) {
        switch (n) {
            case -2147221005: {
                return "Invalid class ID string.";
            }
            case -2147221008: {
                return "CoInitialize has not been called.";
            }
            case -2147467238: {
                return "The server process could not be started because the configured identity is incorrect. Check the username and password.";
            }
            case -2147467260: {
                return "Operation aborted.";
            }
            case -2147024891: {
                return "Access denied.";
            }
            case -2147467259: {
                return "Unspecified error.";
            }
            case -2147024890: {
                return "Invalid handle.";
            }
            case -2147024809: {
                return "Invalid argument.";
            }
            case -2147467262: {
                return "No such interface supported.";
            }
            case -2147467263: {
                return "Not implemented.";
            }
            case -2147024882: {
                return "Out of memory.";
            }
            case -2147483638: {
                return "The data necessary to complete this operation is not yet available.";
            }
            case -2147467261: {
                return "Invalid pointer.";
            }
            case -2147418113: {
                return "Catastrophic failure.";
            }
            case -1073479679: {
                return "The value of the handle is invalid.";
            }
            case -1073479676: {
                return "The server cannot convert the data between the specified format and/or requested data type and the canoncal data type.";
            }
            case -1073479675: {
                return "The requested opertion cannot be done on a public group.";
            }
            case -1073479674: {
                return "The item's access rights do not allow the operation.";
            }
            case -1073479673: {
                return "The item ID is not defined or no longer exists in the server address space.";
            }
            case -1073479672: {
                return "The item ID does not conform to the server's syntax.";
            }
            case -1073479671: {
                return "The filter string was not valid.";
            }
            case -1073479670: {
                return "The item's access path is not known to the server.";
            }
            case -1073479669: {
                return "The value was out of range.";
            }
            case -1073479668: {
                return "Duplicate name not allowed.";
            }
            case 262157: {
                return "The server does not support the requested data rate but will use the closest available rate.";
            }
            case 262158: {
                return "A value was passed to write was accepted but the output was clamped.";
            }
            case 262159: {
                return "The operation cannot be performed because the object is being referenced.";
            }
            case -1073479664: {
                return "The server's configuration file is an invalid format.";
            }
            case -1073479663: {
                return "The requested object was not found.";
            }
            case -1073479165: {
                return "The specified property ID is not valid for the item.";
            }
            case -1073478656: {
                return "The deadband has not been set for this item.";
            }
            case -1073478655: {
                return "The item does not support deadband.";
            }
            case -1073478654: {
                return "The server does not support buffering of data items that are collected at a faster rate than the group update rate.";
            }
            case -1073478653: {
                return "The continuation point is not valid.";
            }
            case 263172: {
                return "Not every detected change has been returned since the server's buffer reached its limit and had to purge out the oldest data.";
            }
            case -1073478651: {
                return "There is no sampling rate set for the specified item.";
            }
            case -1073478650: {
                return "The server does not support writing of quality and/or timestamp.";
            }
            case -2147221164: {
                return "Class not registered.";
            }
            case -2147023174: {
                return "Remote server not available on the given host.";
            }
            case -2147023838: {
                return "The remote service cannot be started, it may be disabled.";
            }
            case -2147023169: {
                return "RPC call failed, the remote process may be down.";
            }
            case -2147417848: {
                return "Remote object has been disconnected.";
            }
            case -2147352571: {
                return "Type mismatch.";
            }
        }
        return "";
    }

    public static boolean failed(int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
        }
        return bl;
    }

    public static void initializeEnv() throws OpcException {
        OpcEnv.initEnv();
    }

    public static void initializeThread() throws OpcException {
        if (inited.get() != Boolean.TRUE) {
            OpcEnv.logTrace("Init thread: " + Thread.currentThread().getName());
            OpcEnv.initThread();
            inited.set(Boolean.TRUE);
        }
    }

    public static boolean isReadable(int n) {
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isWritable(int n) {
        boolean bl = false;
        if ((n & 2) == 2) {
            bl = true;
        }
        return bl;
    }

    public static void logError(String string) {
        OpcEnv.logError(string, null);
    }

    public static void logError(String string, Throwable throwable) {
        if (log != null) {
            log.error(string, throwable);
        } else {
            System.out.println("[OPC error] " + string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void logMessage(String string) {
        OpcEnv.logMessage(string, null);
    }

    public static void logMessage(String string, Throwable throwable) {
        if (log != null) {
            log.message(string, throwable);
        } else {
            System.out.println("[OPC message] " + string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void logTrace(String string) {
        OpcEnv.logTrace(string, null);
    }

    public static void logTrace(String string, Throwable throwable) {
        if (log != null) {
            log.trace(string, throwable);
        } else {
            System.out.println("[OPC trace] " + string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void logWarning(String string) {
        OpcEnv.logWarning(string, null);
    }

    public static void logWarning(String string, Throwable throwable) {
        if (log != null) {
            log.warning(string, throwable);
        } else {
            System.out.println("[OPC warning] " + string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static String resultString(int n) {
        return "[" + Integer.toHexString(n) + "] " + OpcEnv.getDescription(n);
    }

    public static void setLog(Log log) {
        OpcEnv.log = log;
    }

    public static boolean succeeded(int n) {
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        return bl;
    }

    private static final native void initEnv();

    private static final native void initThread();

    static {
        inited = new ThreadLocal();
        System.loadLibrary("opc");
    }

    public static interface Log {
        public void error(String var1, Throwable var2);

        public void message(String var1, Throwable var2);

        public void trace(String var1, Throwable var2);

        public void warning(String var1, Throwable var2);
    }
}

