/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSysmonNp;

import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHardwareMonitorNpPlatformService
extends BPlatformService {
    public static final Property sysmonPollRate = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BRelTime.make((long)15000L), (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second"), (int)1, (int)3600));
    public static final Property cpuTemp = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius")));
    public static final Property cpuTempHi = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)60.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property cpuFanSpeed = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute")));
    public static final Property cpuFanSpeedLo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)4000.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute"), (int)0, (int)10000));
    public static final Property sysFanSpeed = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute")));
    public static final Property sysFanSpeedLo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)3000.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"revolutions per minute"), (int)0, (int)10000));
    public static final Property voltPos12 = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltPos12Lo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)9.6f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltPos12Hi = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)14.4f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltVcc5 = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVcc5Lo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)4.5f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltVcc5Hi = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)5.5f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltVcc3 = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltVcc3Lo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)2.97f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltVcc3Hi = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)3.63f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltCpuCore = BHardwareMonitorNpPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
    public static final Property voltCpuCoreLo = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)1.98f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property voltCpuCoreHi = BHardwareMonitorNpPlatformService.newProperty((int)0, (float)2.42f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt"), (int)-1000, (int)1000));
    public static final Property cpuTemperatureAlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initCpuTemperatureAlarmSupport(), null);
    public static final Property cpuTemperatureAlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property cpuFanAlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initCpuFanAlarmSupport(), null);
    public static final Property cpuFanAlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property sysFanAlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initSysFanAlarmSupport(), null);
    public static final Property sysFanAlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltagePos12AlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initPos12VoltageAlarmSupport(), null);
    public static final Property voltagePos12AlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVcc5AlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initVcc5VoltageAlarmSupport(), null);
    public static final Property voltageVcc5AlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageVcc3AlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initVcc3VoltageAlarmSupport(), null);
    public static final Property voltageVcc3AlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property voltageCpuCoreAlarmSupport = BHardwareMonitorNpPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNpPlatformService.initCpuCoreVoltageAlarmSupport(), null);
    public static final Property voltageCpuCoreAlarmProxy = BHardwareMonitorNpPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action sysmonTimerExpired = BHardwareMonitorNpPlatformService.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final int LOAD_FAILED = 1;
    private static final String ALARM_TYPE_VOLTAGE_CPU_CORE = "cpuCore";
    private static final String ALARM_TYPE_VOLTAGE_VCC3 = "vcc3";
    private static final String ALARM_TYPE_VOLTAGE_VCC5 = "vcc5";
    private static final String ALARM_TYPE_VOLTAGE_POS12 = "pos12";
    private static final String ALARM_TYPE_CPU_FAN = "cpuFan";
    private static final String ALARM_TYPE_SYS_FAN = "sysFan";
    private static final String ALARM_TYPE_TEMPERATURE = "temperature";
    int handle;
    private Clock.Ticket sysmonTicket;
    private boolean lastCpuTempOk;
    private boolean nowCpuTempOk;
    private boolean lastCpuFanSpdOk;
    private boolean nowCpuFanSpdOk;
    private boolean lastSysFanSpdOk;
    private boolean nowSysFanSpdOk;
    private float cpuTemperature;
    private float cpuFanSpd;
    private float sysFanSpd;
    private boolean[] lastVoltOk;
    private boolean[] nowVoltOk;
    private float[] newVoltages;
    private float[] oldVoltages;
    private String[] voltDesc;
    private String[] voltStatus;
    private float[] voltHiLimits;
    private float[] voltLoLimits;
    static /* synthetic */ Class class$com$tridium$platSysmonNp$BHardwareMonitorNpPlatformService;

    public BRelTime getSysmonPollRate() {
        return (BRelTime)this.get(sysmonPollRate);
    }

    public void setSysmonPollRate(BRelTime bRelTime) {
        this.set(sysmonPollRate, (BValue)bRelTime, null);
    }

    public float getCpuTemp() {
        return this.getFloat(cpuTemp);
    }

    public void setCpuTemp(float f) {
        this.setFloat(cpuTemp, f, null);
    }

    public float getCpuTempHi() {
        return this.getFloat(cpuTempHi);
    }

    public void setCpuTempHi(float f) {
        this.setFloat(cpuTempHi, f, null);
    }

    public float getCpuFanSpeed() {
        return this.getFloat(cpuFanSpeed);
    }

    public void setCpuFanSpeed(float f) {
        this.setFloat(cpuFanSpeed, f, null);
    }

    public float getCpuFanSpeedLo() {
        return this.getFloat(cpuFanSpeedLo);
    }

    public void setCpuFanSpeedLo(float f) {
        this.setFloat(cpuFanSpeedLo, f, null);
    }

    public float getSysFanSpeed() {
        return this.getFloat(sysFanSpeed);
    }

    public void setSysFanSpeed(float f) {
        this.setFloat(sysFanSpeed, f, null);
    }

    public float getSysFanSpeedLo() {
        return this.getFloat(sysFanSpeedLo);
    }

    public void setSysFanSpeedLo(float f) {
        this.setFloat(sysFanSpeedLo, f, null);
    }

    public float getVoltPos12() {
        return this.getFloat(voltPos12);
    }

    public void setVoltPos12(float f) {
        this.setFloat(voltPos12, f, null);
    }

    public float getVoltPos12Lo() {
        return this.getFloat(voltPos12Lo);
    }

    public void setVoltPos12Lo(float f) {
        this.setFloat(voltPos12Lo, f, null);
    }

    public float getVoltPos12Hi() {
        return this.getFloat(voltPos12Hi);
    }

    public void setVoltPos12Hi(float f) {
        this.setFloat(voltPos12Hi, f, null);
    }

    public float getVoltVcc5() {
        return this.getFloat(voltVcc5);
    }

    public void setVoltVcc5(float f) {
        this.setFloat(voltVcc5, f, null);
    }

    public float getVoltVcc5Lo() {
        return this.getFloat(voltVcc5Lo);
    }

    public void setVoltVcc5Lo(float f) {
        this.setFloat(voltVcc5Lo, f, null);
    }

    public float getVoltVcc5Hi() {
        return this.getFloat(voltVcc5Hi);
    }

    public void setVoltVcc5Hi(float f) {
        this.setFloat(voltVcc5Hi, f, null);
    }

    public float getVoltVcc3() {
        return this.getFloat(voltVcc3);
    }

    public void setVoltVcc3(float f) {
        this.setFloat(voltVcc3, f, null);
    }

    public float getVoltVcc3Lo() {
        return this.getFloat(voltVcc3Lo);
    }

    public void setVoltVcc3Lo(float f) {
        this.setFloat(voltVcc3Lo, f, null);
    }

    public float getVoltVcc3Hi() {
        return this.getFloat(voltVcc3Hi);
    }

    public void setVoltVcc3Hi(float f) {
        this.setFloat(voltVcc3Hi, f, null);
    }

    public float getVoltCpuCore() {
        return this.getFloat(voltCpuCore);
    }

    public void setVoltCpuCore(float f) {
        this.setFloat(voltCpuCore, f, null);
    }

    public float getVoltCpuCoreLo() {
        return this.getFloat(voltCpuCoreLo);
    }

    public void setVoltCpuCoreLo(float f) {
        this.setFloat(voltCpuCoreLo, f, null);
    }

    public float getVoltCpuCoreHi() {
        return this.getFloat(voltCpuCoreHi);
    }

    public void setVoltCpuCoreHi(float f) {
        this.setFloat(voltCpuCoreHi, f, null);
    }

    public BPlatformAlarmSupport getCpuTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(cpuTemperatureAlarmSupport);
    }

    public void setCpuTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(cpuTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getCpuTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(cpuTemperatureAlarmProxy);
    }

    public void setCpuTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(cpuTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getCpuFanAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(cpuFanAlarmSupport);
    }

    public void setCpuFanAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(cpuFanAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getCpuFanAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(cpuFanAlarmProxy);
    }

    public void setCpuFanAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(cpuFanAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getSysFanAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(sysFanAlarmSupport);
    }

    public void setSysFanAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(sysFanAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getSysFanAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(sysFanAlarmProxy);
    }

    public void setSysFanAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(sysFanAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltagePos12AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltagePos12AlarmSupport);
    }

    public void setVoltagePos12AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltagePos12AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltagePos12AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltagePos12AlarmProxy);
    }

    public void setVoltagePos12AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltagePos12AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVcc5AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVcc5AlarmSupport);
    }

    public void setVoltageVcc5AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVcc5AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVcc5AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVcc5AlarmProxy);
    }

    public void setVoltageVcc5AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVcc5AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageVcc3AlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageVcc3AlarmSupport);
    }

    public void setVoltageVcc3AlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageVcc3AlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageVcc3AlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageVcc3AlarmProxy);
    }

    public void setVoltageVcc3AlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageVcc3AlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getVoltageCpuCoreAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(voltageCpuCoreAlarmSupport);
    }

    public void setVoltageCpuCoreAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(voltageCpuCoreAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getVoltageCpuCoreAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(voltageCpuCoreAlarmProxy);
    }

    public void setVoltageCpuCoreAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(voltageCpuCoreAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void sysmonTimerExpired() {
        this.invoke(sysmonTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doStationStarted(BStation bStation) {
        this.handle = this.open();
        this.loadLibraries();
        if (this.driverOpenCode() == 1) {
            log.trace("ERROR: sysmon Load Failed -- Unable to load WinNT kernel driver required to access JaceNP hardware.");
            return;
        }
        if (this.sysmonTicket != null) {
            this.sysmonTicket.cancel();
        }
        this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)sysmonTimerExpired, null);
        this.getCpuTemperatureAlarmProxy().setAlarmSupport(this.getCpuTemperatureAlarmSupport());
        this.getCpuFanAlarmProxy().setAlarmSupport(this.getCpuFanAlarmSupport());
        this.getSysFanAlarmProxy().setAlarmSupport(this.getSysFanAlarmSupport());
        this.getVoltagePos12AlarmProxy().setAlarmSupport(this.getVoltagePos12AlarmSupport());
        this.getVoltageVcc5AlarmProxy().setAlarmSupport(this.getVoltageVcc5AlarmSupport());
        this.getVoltageVcc3AlarmProxy().setAlarmSupport(this.getVoltageVcc3AlarmSupport());
        this.getVoltageCpuCoreAlarmProxy().setAlarmSupport(this.getVoltageCpuCoreAlarmSupport());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == sysmonPollRate) {
            if (this.sysmonTicket != null) {
                this.sysmonTicket.cancel();
            }
            this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)sysmonTimerExpired, null);
        }
    }

    public void doSysmonTimerExpired() {
        try {
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord;
            log.trace("sysmon reading system measurements...");
            this.cpuTemperature = this.getCpuTemperature();
            log.trace("mainBoardTemp --> " + this.cpuTemperature);
            boolean bl = false;
            if (this.cpuTemperature < this.getCpuTempHi()) {
                bl = true;
            }
            this.nowCpuTempOk = bl;
            boolean bl2 = false;
            if (this.getCpuTemp() < this.getCpuTempHi()) {
                bl2 = true;
            }
            this.lastCpuTempOk = bl2;
            this.setCpuTemp(this.cpuTemperature);
            this.cpuFanSpd = this.getCpuFanSpd();
            log.trace("cpuFanSpeed --> " + this.cpuFanSpd);
            boolean bl3 = false;
            if (this.cpuFanSpd < this.getCpuFanSpeedLo()) {
                bl3 = true;
            }
            this.nowCpuFanSpdOk = bl3 ^ true;
            boolean bl4 = false;
            if (this.getCpuFanSpeed() < this.getCpuFanSpeedLo()) {
                bl4 = true;
            }
            this.lastCpuFanSpdOk = bl4 ^ true;
            this.setCpuFanSpeed(this.cpuFanSpd);
            this.sysFanSpd = this.getSysFanSpd();
            log.trace("sysFanSpeed --> " + this.sysFanSpd);
            boolean bl5 = false;
            if (this.sysFanSpd < this.getSysFanSpeedLo()) {
                bl5 = true;
            }
            this.nowSysFanSpdOk = bl5 ^ true;
            boolean bl6 = false;
            if (this.getSysFanSpeed() < this.getSysFanSpeedLo()) {
                bl6 = true;
            }
            this.lastSysFanSpdOk = bl6 ^ true;
            this.setSysFanSpeed(this.sysFanSpd);
            if (this.nowCpuTempOk != this.lastCpuTempOk) {
                if (this.nowCpuTempOk) {
                    log.trace("mainBoardTempRange  --> PASSED");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeToNormal();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("mainBoardTempRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowCpuFanSpdOk != this.lastCpuFanSpdOk) {
                if (this.nowCpuFanSpdOk) {
                    log.trace("CpuFanSpdRange --> PASSED");
                    bPlatformServiceAlarmRecord = this.getCpuFanAlarmSupport().makeToNormal();
                    this.getCpuFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("CpuFanSpdRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getCpuFanAlarmSupport().makeNewFaultAlarm();
                    this.getCpuFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowSysFanSpdOk != this.lastSysFanSpdOk) {
                if (this.nowSysFanSpdOk) {
                    log.trace("SysFanSpdRange --> PASSED");
                    bPlatformServiceAlarmRecord = this.getSysFanAlarmSupport().makeToNormal();
                    this.getSysFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("SysFanSpdRange --> FAILED");
                    bPlatformServiceAlarmRecord = this.getSysFanAlarmSupport().makeNewFaultAlarm();
                    this.getSysFanAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            this.newVoltages[0] = this.getVoltage(0);
            this.newVoltages[1] = this.getVoltage(1);
            this.newVoltages[2] = this.getVoltage(2);
            this.newVoltages[3] = this.getVoltage(3);
            this.oldVoltages[0] = this.getVoltPos12();
            this.oldVoltages[1] = this.getVoltVcc5();
            this.oldVoltages[2] = this.getVoltVcc3();
            this.oldVoltages[3] = this.getVoltCpuCore();
            this.setVoltPos12(this.newVoltages[0]);
            this.setVoltVcc5(this.newVoltages[1]);
            this.setVoltVcc3(this.newVoltages[2]);
            this.setVoltCpuCore(this.newVoltages[3]);
            this.getVoltStat();
            int n = 0;
            while (n < 4) {
                log.trace(this.voltStatus[n]);
                if (this.nowVoltOk[n] != this.lastVoltOk[n]) {
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord2;
                    if (this.nowVoltOk[n]) {
                        bPlatformServiceAlarmRecord2 = this.getVoltageAlarmSupport(n).makeToNormal();
                        this.getVoltageAlarmProxy(n).firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                    } else {
                        bPlatformServiceAlarmRecord2 = this.getVoltageAlarmSupport(n).makeNewFaultAlarm();
                        this.getVoltageAlarmProxy(n).firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord2);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    private final BPlatformAlarmProxy getVoltageAlarmProxy(int n) {
        switch (n) {
            case 0: {
                return this.getVoltagePos12AlarmProxy();
            }
            case 1: {
                return this.getVoltageVcc5AlarmProxy();
            }
            case 2: {
                return this.getVoltageVcc3AlarmProxy();
            }
            case 3: {
                return this.getVoltageCpuCoreAlarmProxy();
            }
        }
        return this.getVoltageCpuCoreAlarmProxy();
    }

    private final BPlatformAlarmSupport getVoltageAlarmSupport(int n) {
        switch (n) {
            case 0: {
                return this.getVoltagePos12AlarmSupport();
            }
            case 1: {
                return this.getVoltageVcc5AlarmSupport();
            }
            case 2: {
                return this.getVoltageVcc3AlarmSupport();
            }
            case 3: {
                return this.getVoltageCpuCoreAlarmSupport();
            }
        }
        return this.getVoltageCpuCoreAlarmSupport();
    }

    private final void getVoltStat() {
        try {
            this.voltHiLimits[0] = this.getVoltPos12Hi();
            this.voltHiLimits[1] = this.getVoltVcc5Hi();
            this.voltHiLimits[2] = this.getVoltVcc3Hi();
            this.voltHiLimits[3] = this.getVoltCpuCoreHi();
            this.voltLoLimits[0] = this.getVoltPos12Lo();
            this.voltLoLimits[1] = this.getVoltVcc5Lo();
            this.voltLoLimits[2] = this.getVoltVcc3Lo();
            this.voltLoLimits[3] = this.getVoltCpuCoreLo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            stringBuffer.append("  " + n + ": " + this.newVoltages[n] + '[' + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + "]\n");
            ++n;
        }
        log.trace(stringBuffer.toString());
        n = 0;
        while (n < 4) {
            if (this.voltHiLimits[n] < this.voltLoLimits[n]) {
                float f = this.voltHiLimits[n];
                this.voltHiLimits[n] = this.voltLoLimits[n];
                this.voltLoLimits[n] = f;
            }
            if (this.newVoltages[n] > this.voltHiLimits[n] || this.newVoltages[n] < this.voltLoLimits[n]) {
                this.nowVoltOk[n] = false;
                this.voltStatus[n] = "Voltage " + this.voltDesc[n] + " = " + this.newVoltages[n] + " is out of range [" + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + ']';
            } else {
                this.nowVoltOk[n] = true;
                this.voltStatus[n] = "Voltage " + this.voltDesc[n] + " = " + this.newVoltages[n] + " is in range [" + this.voltLoLimits[n] + ',' + this.voltHiLimits[n] + ']';
            }
            ++n;
        }
    }

    protected abstract void loadLibraries();

    public abstract int open();

    public abstract void close();

    public abstract int driverOpenCode();

    public abstract int getCpuTemperature();

    public abstract float getFanSpd(int var1);

    public float getCpuFanSpd() {
        return this.getFanSpd(0);
    }

    public float getSysFanSpd() {
        return this.getFanSpd(1);
    }

    public abstract float getVoltage(int var1);

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getCpuFanAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSysFanAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltagePos12AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc5AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc3AlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageCpuCoreAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getCpuFanAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSysFanAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltagePos12AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc5AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageVcc3AlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getVoltageCpuCoreAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static BPlatformAlarmSupport initCpuTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:cpuTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:cpuTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initCpuFanAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:cpuFanFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:cpuFanPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_CPU_FAN));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initSysFanAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:sysFanFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:sysFanPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_SYS_FAN));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPos12VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:voltagePos12Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:voltagePos12Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_POS12));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initVcc5VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:voltageVcc5Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:voltageVcc5Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VCC5));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initVcc3VoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:voltageVcc3Fail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:voltageVcc3Passed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_VCC3));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initCpuCoreVoltageAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNp:voltageCpuCoreFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNp:voltageCpuCOrePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_VOLTAGE_CPU_CORE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastVoltOk = new boolean[4];
        this.nowVoltOk = new boolean[4];
        this.newVoltages = new float[4];
        this.oldVoltages = new float[4];
        this.voltDesc = new String[]{ALARM_TYPE_VOLTAGE_POS12, "vcc", ALARM_TYPE_VOLTAGE_VCC3, ALARM_TYPE_VOLTAGE_CPU_CORE};
        this.voltStatus = new String[]{"ok", "ok", "ok", "ok"};
        this.voltHiLimits = new float[4];
        this.voltLoLimits = new float[4];
    }

    public BHardwareMonitorNpPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("HardwareMonitorNpPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platSysmonNp$BHardwareMonitorNpPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platSysmonNp$BHardwareMonitorNpPlatformService = BHardwareMonitorNpPlatformService.class("[Lcom.tridium.platSysmonNp.BHardwareMonitorNpPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = Log.getLog((String)"sysmon");
    }
}

