/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnetAws.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetActionCommand
extends BComponent
implements BIBacnetDataType {
    public static final Property deviceId = BBacnetActionCommand.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT_DEVICE, (BFacets)BBacnetObjectType.getObjectIdFacets((int)8));
    public static final Property objectId = BBacnetActionCommand.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property propertyId = BBacnetActionCommand.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Property propertyArrayIndex = BBacnetActionCommand.newProperty((int)0, (int)-1, null);
    public static final Property priority = BBacnetActionCommand.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)16)));
    public static final Property postDelay = BBacnetActionCommand.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)30)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    public static final Property quitOnFailure = BBacnetActionCommand.newProperty((int)0, (boolean)false, null);
    public static final Property writeSuccessful = BBacnetActionCommand.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE;
    public static final int DEVICE_ID_TAG = 0;
    public static final int OBJECT_ID_TAG = 1;
    public static final int PROPERTY_ID_TAG = 2;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 3;
    public static final int PROPERTY_VALUE_TAG = 4;
    public static final int PRIORITY_TAG = 5;
    public static final int POST_DELAY_TAG = 6;
    public static final int QUIT_ON_FAILURE_TAG = 7;
    public static final int WRITE_SUCCESSFUL_TAG = 8;
    static /* synthetic */ Class class$javax$baja$bacnetAws$datatypes$BBacnetActionCommand;

    public BBacnetObjectIdentifier getDeviceId() {
        return (BBacnetObjectIdentifier)this.get(deviceId);
    }

    public void setDeviceId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(deviceId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BEnum getPropertyId() {
        return (BEnum)this.get(propertyId);
    }

    public void setPropertyId(BEnum bEnum) {
        this.set(propertyId, (BValue)bEnum, null);
    }

    public int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public int getPostDelay() {
        return this.getInt(postDelay);
    }

    public void setPostDelay(int n) {
        this.setInt(postDelay, n, null);
    }

    public boolean getQuitOnFailure() {
        return this.getBoolean(quitOnFailure);
    }

    public void setQuitOnFailure(boolean bl) {
        this.setBoolean(quitOnFailure, bl, null);
    }

    public boolean getWriteSuccessful() {
        return this.getBoolean(writeSuccessful);
    }

    public void setWriteSuccessful(boolean bl) {
        this.setBoolean(writeSuccessful, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        this.getParent().asComponent().changed(this.getPropertyInParent(), context);
    }

    public BValue getPropertyValue() {
        return this.get("propertyValue");
    }

    public void setPropertyValue(BValue bValue) {
        Property property = this.getProperty("propertyValue");
        if (property == null) {
            this.add("propertyValue", bValue);
        } else {
            this.set("propertyValue", bValue);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        asnInput.peekTag();
        if (asnInput.isValueTag(0)) {
            this.setDeviceId(asnInput.readObjectIdentifier(0));
        }
        this.setObjectId(asnInput.readObjectIdentifier(1));
        this.setPropertyId((BEnum)BDynamicEnum.make((int)asnInput.readEnumerated(2), (BEnumRange)this.getPropertyId().getRange()));
        asnInput.peekTag();
        if (asnInput.isValueTag(3)) {
            this.setPropertyArrayIndex(asnInput.readUnsignedInt(3));
        }
        this.setPropertyValue(AsnUtil.asnToValue((byte[])asnInput.readEncodedValue(4)));
        asnInput.peekTag();
        if (asnInput.isValueTag(5)) {
            this.setPriority(asnInput.readUnsignedInt(5));
        }
        asnInput.peekTag();
        if (asnInput.isValueTag(6)) {
            this.setPostDelay(asnInput.readUnsignedInt(6));
        }
        this.setQuitOnFailure(asnInput.readBoolean(7));
        this.setWriteSuccessful(asnInput.readBoolean(8));
    }

    public void writeAsn(AsnOutput asnOutput) {
        if (this.isDeviceIdUsed()) {
            asnOutput.writeObjectIdentifier(0, this.getDeviceId());
        }
        asnOutput.writeObjectIdentifier(1, this.getObjectId());
        asnOutput.writeEnumerated(2, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            asnOutput.writeUnsignedInteger(3, (long)this.getPropertyArrayIndex());
        }
        asnOutput.writeEncodedValue(4, AsnUtil.toAsn((BValue)this.getPropertyValue()));
        if (this.isPriorityUsed()) {
            asnOutput.writeUnsignedInteger(5, (long)this.getPriority());
        }
        if (this.isPostDelayUsed()) {
            asnOutput.writeUnsignedInteger(6, (long)this.getPostDelay());
        }
        asnOutput.writeBoolean(7, this.getQuitOnFailure());
        asnOutput.writeBoolean(8, this.getWriteSuccessful());
    }

    private final boolean isDeviceIdUsed() {
        return deviceId.isEquivalentToDefaultValue((BValue)this.getDeviceId()) ^ true;
    }

    private final boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.getPropertyArrayIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    private final boolean isPriorityUsed() {
        boolean bl = false;
        if (this.getPriority() != -1) {
            bl = true;
        }
        return bl;
    }

    private final boolean isPostDelayUsed() {
        boolean bl = false;
        if (this.getPostDelay() > 0) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        this.loadSlots();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId()).append(":");
        stringBuffer.append(this.getPropertyId());
        if (this.getPropertyArrayIndex() >= 0) {
            stringBuffer.append("[").append(this.getPropertyArrayIndex()).append("]");
        }
        stringBuffer.append(":");
        if (this.getPostDelay() > 0) {
            stringBuffer.append("dly=").append(this.getPostDelay()).append(":");
        }
        stringBuffer.append("val=").append(this.getPropertyValue());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnetAws$datatypes$BBacnetActionCommand;
        if (clazz == null) {
            clazz = class$javax$baja$bacnetAws$datatypes$BBacnetActionCommand = BBacnetActionCommand.class("[Ljavax.baja.bacnetAws.datatypes.BBacnetActionCommand;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

