/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.migrate;

import java.io.File;
import java.util.LinkedList;
import javax.baja.file.FileUtil;
import javax.baja.io.BogDecoder;
import javax.baja.io.BogEncoder;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.util.TextUtil;
import javax.baja.xml.XElem;

public class MigrateToAws {
    protected static final String MODULE_AWS = "bacAws=bacnetAws";
    protected static final String MODULE_OWS = "bacOws=bacnetOws";
    protected static final String MODULE_BAC = "bac=bacnet";
    protected final File input;
    protected final File stubbed;

    public final void convert() throws Exception {
        this.log("\nMigrating " + this.input.getAbsolutePath() + " ...");
        this.stubBog();
        this.migrateBog();
    }

    protected void log(String string) {
        System.out.println(string);
    }

    private final void stubBog() throws Exception {
        XElem xElem = BogDecoder.make((File)this.input).parse();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        while (!linkedList.isEmpty()) {
            XElem xElem2 = (XElem)linkedList.removeFirst();
            this.stub(xElem2);
            XElem[] xElemArray = xElem2.elems();
            int n = 0;
            while (n < xElemArray.length) {
                linkedList.add(xElemArray[n]);
                ++n;
            }
        }
        xElem.write(this.stubbed);
    }

    private final void stub(XElem xElem) throws Exception {
        String string = xElem.get("t", null);
        if (string == null) {
            return;
        }
        String[] stringArray = TextUtil.split((String)string, (char)':');
        if ("bac".equals(stringArray[0])) {
            if ("BacnetNetwork".equals(stringArray[1])) {
                this.stub(xElem, MODULE_AWS, "bacAws:BacnetAwsNetwork");
            } else if ("BacnetDevice".equals(stringArray[1])) {
                this.stub(xElem, MODULE_AWS, "bacAws:BacnetAwsDevice");
            } else if ("BacnetDeviceFolder".equals(stringArray[1])) {
                this.stub(xElem, MODULE_AWS, "bacAws:BacnetAwsDeviceFolder");
            } else if ("LocalBacnetDevice".equals(stringArray[1])) {
                this.stub(xElem, MODULE_AWS, "bacAws:LocalBacnetAwsDevice");
            } else if ("BacnetHistoryDeviceExt".equals(stringArray[1])) {
                this.stubIfContainedBy(xElem, MODULE_AWS, "bacAws:BacnetAwsHistoryDeviceExt", "bacAws:BacnetAwsDevice");
            } else if ("BacnetConfigDeviceExt".equals(stringArray[1])) {
                this.stubIfContainedBy(xElem, MODULE_AWS, "bacAws:BacnetAwsConfigDeviceExt", "bacAws:BacnetAwsDevice");
            } else {
                this.stub(xElem, MODULE_BAC, xElem.get("t"));
            }
        } else {
            this.doStub(xElem, stringArray[0], stringArray[1]);
        }
    }

    protected void stub(XElem xElem, String string, String string2) {
        xElem.setAttr("m", string);
        xElem.setAttr("t", string2);
    }

    protected void stubIfContainedBy(XElem xElem, String string, String string2, String string3) {
        XElem xElem2 = xElem.parent();
        boolean bl = false;
        while (xElem2 != null) {
            if (xElem2.get("t", "").equals(string3)) {
                bl = true;
                break;
            }
            xElem2 = xElem2.parent();
        }
        if (bl) {
            xElem.setAttr("t", string2);
        }
    }

    protected void doStub(XElem xElem, String string, String string2) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void migrateBog() throws Exception {
        BComponent bComponent = new BogDecoder(this.stubbed).decodeDocument().asComponent();
        this.scanStubbedStation(bComponent);
        this.doMigration();
        File file = this.input.getParentFile();
        File file2 = new File(file, "preMigrate_" + this.input.getName());
        FileUtil.move((File)this.input, (File)file2);
        this.log("Backed up original bog as: " + file2.getAbsolutePath());
        BogEncoder bogEncoder = new BogEncoder(this.input);
        bogEncoder.setZipped(true);
        try {
            bogEncoder.encodeDocument((BValue)bComponent);
            this.log("Success! Migrated bog: " + this.input.getAbsolutePath());
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bogEncoder.close();
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        bogEncoder.close();
    }

    private final void scanStubbedStation(BComponent bComponent) {
        LinkedList<BComponent> linkedList = new LinkedList<BComponent>();
        linkedList.add(bComponent);
        while (!linkedList.isEmpty()) {
            BComponent bComponent2 = (BComponent)linkedList.removeFirst();
            if (this.scanned(bComponent2)) break;
            BComponent[] bComponentArray = bComponent2.getChildComponents();
            int n = 0;
            while (n < bComponentArray.length) {
                linkedList.add(bComponentArray[n]);
                ++n;
            }
        }
        linkedList.clear();
    }

    protected boolean scanned(BComponent bComponent) {
        return true;
    }

    protected void doMigration() throws Exception {
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            if (stringArray.length == 0) {
                MigrateToAws.usage("Missing bog file argument");
            }
            MigrateToAws.migrate(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    public static void usage(String string) {
        if (string != null) {
            System.err.println("ERROR: " + string);
        }
        System.out.println("  MigrateToAws <bog>\n");
        System.exit(1);
    }

    private static final void migrate(File file) throws Exception {
        Object object;
        XElem xElem = BogDecoder.make((File)file).parse();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        while (!linkedList.isEmpty()) {
            object = (XElem)linkedList.removeFirst();
            XElem[] xElemArray = object.elems();
            int n = 0;
            while (n < xElemArray.length) {
                linkedList.add(xElemArray[n]);
                ++n;
            }
        }
        object = new MigrateToAws(file);
        ((MigrateToAws)object).convert();
    }

    public MigrateToAws(File file) {
        this.input = file;
        this.stubbed = new File(file.getParentFile(), "stub_" + file.getName());
        this.stubbed.deleteOnExit();
        Log.getLog((String)"sys.xml").setSeverity(3);
    }
}

