/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetFile;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRestoreJob
extends BDeviceManagerJob {
    public static final Type TYPE;
    static Lexicon lex;
    private BBacnetAwsNetwork bacnetAws;
    private BRestoreConfig params;
    private BackupFileComparator backupFileComparator;
    static /* synthetic */ Class class$com$tridium$bacnetAws$job$BRestoreJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.progress(0);
        if (log.isTraceOn()) {
            log.trace("Restoring device at " + this.params.getDeviceAddress() + "...");
        }
        String string = null;
        String string2 = this.params.getPassword().getString();
        if (string2.length() > 0) {
            string = string2;
        }
        try {
            Object object;
            long l;
            long l2;
            boolean bl;
            long l3 = 0L;
            long l4 = 0L;
            try {
                l3 = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 139));
            }
            catch (Exception exception) {
                this.log().message("Protocol Revision cannot be determined: " + exception);
            }
            this.progress(2);
            try {
                l4 = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 120));
            }
            catch (Exception exception) {
                this.log().message("Vendor ID cannot be determined: " + exception);
            }
            this.progress(4);
            int n = 6;
            boolean bl2 = false;
            if (l3 < 10L && l4 == 36L) {
                bl2 = true;
            }
            n = this.readBRProp(338, bl2, -1, 9);
            boolean bl3 = false;
            if (n >= 0) {
                bl3 = bl = true;
            }
            if (n > 0 && n < 5) {
                throw new IllegalStateException("Cannot restore device; BackupAndRestoreState " + BBacnetBackupState.tag((int)n) + " is not IDLE!");
            }
            this.progress(6);
            int n2 = 90;
            try {
                this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)n2));
            }
            catch (BacnetException bacnetException) {
                this.log().message("Could not write Backup_Failure_Timeout property:" + (Object)((Object)bacnetException));
                n2 = this.readBRProp(153, false, 15, 2);
            }
            this.progress(8);
            long l5 = 60L;
            if (bl) {
                l5 = this.readBRProp(341, bl2, 60, 2);
            }
            l5 *= 1000L;
            this.progress(10);
            long l6 = 60L;
            if (bl) {
                l6 = this.readBRProp(340, bl2, 60, 2);
            }
            l6 *= 1000L;
            this.progress(12);
            this.log().message("Sending START_RESTORE command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.startRestore, string, this.params.getCharacterSet());
            this.progress(14);
            if (bl) {
                this.log().message("Monitoring Backup_And_Restore_State...");
                n = this.readBRProp(338, bl2, -1, 9);
                l2 = Clock.ticks();
                l = 0L;
                while (l < l5 && n != 4) {
                    this.log().message("Waiting for device restore preparation to complete (" + l / 1000L + " sec)...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.checkCancel(lex.getText("restore.canceled"));
                    l = Clock.ticks() - l2;
                    n = this.readBRProp(338, bl2, -1, 9);
                    if (n != -1 && n != 5) continue;
                    throw new RuntimeException("RESTORE_FAILURE received from device: unable to enter restore mode!");
                }
            }
            this.progress(20);
            this.log().message("Reading Configuration_Files list...");
            int n3 = AsnUtil.fromAsnUnsignedInt((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154, 0));
            this.checkCancel(lex.getText("restore.canceled"));
            BBacnetObjectIdentifier[] bBacnetObjectIdentifierArray = new BBacnetObjectIdentifier[n3];
            byte[] byArray = this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154);
            String[] stringArray = new String[n3];
            BValue[] bValueArray = AsnUtil.fromAsn((byte[])byArray);
            if (bValueArray.length != bBacnetObjectIdentifierArray.length) {
                throw new BajaRuntimeException("Length of Configuration_Files array:" + bValueArray.length + ", reported length:" + n3);
            }
            this.progress(25);
            BFileSystem bFileSystem = BFileSystem.INSTANCE;
            int n4 = 0;
            while (n4 < bBacnetObjectIdentifierArray.length) {
                this.checkCancel(lex.getText("restore.canceled"));
                bBacnetObjectIdentifierArray[n4] = (BBacnetObjectIdentifier)bValueArray[n4];
                this.log().message("Reading Object_Name for Configuration_Files[" + n4 + "] (" + bBacnetObjectIdentifierArray[n4] + ')');
                object = AsnUtil.fromAsnCharacterString((byte[])this.client().readProperty(this.params.getDeviceAddress(), bBacnetObjectIdentifierArray[n4], 77));
                stringArray[n4] = object;
                this.progress(n4, bBacnetObjectIdentifierArray.length, 25, 40);
                ++n4;
            }
            this.checkCancel(lex.getText("restore.canceled"));
            FilePath filePath = BRestoreJob.toFilePath(this.params.getDirectory().normalize());
            object = bFileSystem.makeDir(filePath);
            Object[] objectArray = object.listFiles();
            if (objectArray.length != bBacnetObjectIdentifierArray.length) {
                throw new BajaRuntimeException("Cannot restore: found " + objectArray.length + " backup file(s) in directory " + this.params.getDirectory() + ", but " + bBacnetObjectIdentifierArray.length + " file(s) are exposed on the remote device!");
            }
            this.progress(45);
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)this.backupFileComparator);
            int n5 = 0;
            while (n5 < objectArray.length) {
                this.checkCancel(lex.getText("restore.canceled"));
                Object object2 = objectArray[n5];
                BRestoreJob.d("file #" + n5 + ": remote fileId:" + bBacnetObjectIdentifierArray[n5] + "; local fileName=" + object2.getFileName());
                this.log().message("Reading local file data from " + object2.getFileName());
                byte[] byArray2 = object2.read();
                this.log().message("Writing remote file data to " + stringArray[n5]);
                BBacnetDevice bBacnetDevice = this.bacnetAws.lookupDeviceById(this.params.getDeviceId());
                BBacnetFile.writeFile((BBacnetDevice)bBacnetDevice, (BBacnetObjectIdentifier)bBacnetObjectIdentifierArray[n5], (byte[])byArray2);
                this.progress(n5, bBacnetObjectIdentifierArray.length, 45, 90);
                ++n5;
            }
            this.log().message("Sending END_RESTORE command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.endRestore, string, this.params.getCharacterSet());
            this.progress(95);
            if (bl) {
                n = this.readBRProp(338, bl2, -1, 9);
                l = l2 = Clock.ticks();
                while (l < l6 && n != 0) {
                    this.log().message("Waiting for device restore completion (" + l / 1000L + " sec)...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!this.isAlive()) {
                        throw new BajaRuntimeException(lex.getText("restore.canceled"));
                    }
                    l = Clock.ticks();
                    n = this.readBRProp(338, bl2, -1, 9);
                    if (n != -1 && n != 6) continue;
                    throw new RuntimeException("RESTORE_FAILURE received from device!");
                }
            }
            this.log().success("Finished Restore Procedure!");
            String string3 = MessageFormat.format(lex.getText("restore.completion"), new Long(l6));
            this.log().message(string3);
        }
        catch (Exception exception) {
            log.message("Exception restoring device: " + exception, (Throwable)exception);
            String string4 = MessageFormat.format(lex.getText("restore.fail"), exception);
            this.add("failureCause", (BValue)BString.make((String)exception.toString()));
            try {
                this.log().message("Sending ABORT_RESTORE command...");
                this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.abortRestore, string, this.params.getCharacterSet());
            }
            catch (Exception exception2) {}
            this.log().failed(string4);
            throw exception;
        }
    }

    public static FilePath toFilePath(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                return (FilePath)ordQueryArray[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    private final int readBRProp(int n, boolean bl, int n2, int n3) {
        String string = BBacnetPropertyIdentifier.tag((int)n);
        if (bl) {
            string = string + " (Niagara)";
        }
        int n4 = n2;
        try {
            switch (n3) {
                case 2: {
                    n4 = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(n, bl)));
                    break;
                }
                case 9: {
                    n4 = AsnUtil.fromAsnEnumerated((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(n, bl)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid asnType supplied to readBRProp:" + n3);
                }
            }
        }
        catch (Exception exception) {
            this.log().message("Error reading " + string + ':' + exception);
        }
        return n4;
    }

    private final int propId(int n, boolean bl) {
        return bl ? n + 1000 : n;
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.backupFileComparator = new BackupFileComparator();
    }

    public BRestoreJob() {
        this.this();
    }

    public BRestoreJob(BBacnetAwsNetwork bBacnetAwsNetwork, BRestoreConfig bRestoreConfig) {
        super((BBacnetNetwork)bBacnetAwsNetwork);
        this.this();
        this.bacnetAws = bBacnetAwsNetwork;
        this.params = bRestoreConfig;
    }

    static {
        Class clazz = class$com$tridium$bacnetAws$job$BRestoreJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetAws$job$BRestoreJob = BRestoreJob.class("[Lcom.tridium.bacnetAws.job.BRestoreJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnetAws");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BackupFileComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (!(object instanceof BIFile)) {
                throw new ClassCastException("BackupFileComparator only compares BIFiles");
            }
            if (!(object2 instanceof BIFile)) {
                throw new ClassCastException("BackupFileComparator only compares BIFiles");
            }
            try {
                BIFile bIFile = (BIFile)object;
                BIFile bIFile2 = (BIFile)object2;
                StringTokenizer stringTokenizer = new StringTokenizer(bIFile.getFileName(), "_");
                int n = stringTokenizer.countTokens();
                if (n < 3) {
                    throw new IllegalArgumentException("invalid backup file for comparison:" + bIFile.getFileName());
                }
                int n2 = 0;
                while (n2 < n - 1) {
                    stringTokenizer.nextToken();
                    ++n2;
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer = new StringTokenizer(bIFile2.getFileName(), "_");
                n = stringTokenizer.countTokens();
                if (n < 3) {
                    throw new IllegalArgumentException("invalid backup file for comparison:" + bIFile2.getFileName());
                }
                int n3 = 0;
                while (n3 < n - 1) {
                    stringTokenizer.nextToken();
                    ++n3;
                }
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                return n2 - n3;
            }
            catch (Exception exception) {
                throw new ClassCastException("BackupFileComparator cannot compare:" + exception.toString());
            }
        }

        BackupFileComparator() {
        }
    }
}

