/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.hsqldb;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.persist.HsqlProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHsqlDatabase
extends BRdbms {
    public static final Property hostAddress = BHsqlDatabase.newProperty((int)5, (BValue)BOrd.NULL, null);
    public static final Property baseDirectory = BHsqlDatabase.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IDirectory"));
    public static final Property databaseName = BHsqlDatabase.newProperty((int)0, (String)"", null);
    public static final Property checkpointDefragSize = BHsqlDatabase.newProperty((int)4, (int)2, null);
    public static final Type TYPE;
    private Properties oldPropertiesFile;
    private boolean checkedForHsql_1_8_to_2_0_Upgrade;
    private final RdbmsDialect dialect;
    static /* synthetic */ Class class$com$tridium$rdb$hsqldb$BHsqlDatabase;

    public BOrd getBaseDirectory() {
        return (BOrd)this.get(baseDirectory);
    }

    public void setBaseDirectory(BOrd bOrd) {
        this.set(baseDirectory, (BValue)bOrd, null);
    }

    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    public void setDatabaseName(String string) {
        this.setString(databaseName, string, null);
    }

    public int getCheckpointDefragSize() {
        return this.getInt(checkpointDefragSize);
    }

    public void setCheckpointDefragSize(int n) {
        this.setInt(checkpointDefragSize, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        try {
            this.getConnection().createStatement().execute("SHUTDOWN");
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbHsqlDb");
    }

    public Connection getConnection(String string, BPassword bPassword) throws SQLException {
        try {
            boolean bl = this.checkForHsql_1_8_to_2_0_Upgrade();
            FilePath filePath = (FilePath)this.getBaseDirectory().parse()[0];
            BDirectory bDirectory = BFileSystem.INSTANCE.makeDir(filePath);
            String string2 = ((BLocalFileStore)bDirectory.getStore()).getLocalFile().getAbsolutePath();
            String string3 = "jdbc:hsqldb:file:" + string2 + File.separator + this.getDatabaseName();
            Properties properties = new Properties();
            if (bl) {
                BHsqlDatabase.addProps(properties);
            }
            properties.put("user", string);
            properties.put("password", bPassword.getString());
            HsqlProperties hsqlProperties = DatabaseURL.parseURL((String)string3, (boolean)true, (boolean)true);
            hsqlProperties.addProperties(properties);
            return new JDBCConnection(hsqlProperties);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static void addProps(Properties properties) {
        properties.put("check_props", "true");
        properties.put("hsqldb.log_data", "false");
        properties.put("hsqldb.default_table_type", "cached");
        properties.put("hsqldb.applog", "0");
        properties.put("hsqldb.lock_file", "false");
    }

    private final synchronized boolean checkForHsql_1_8_to_2_0_Upgrade() throws Exception {
        if (this.checkedForHsql_1_8_to_2_0_Upgrade) {
            return false;
        }
        this.checkedForHsql_1_8_to_2_0_Upgrade = true;
        BIFile bIFile = null;
        try {
            bIFile = (BIFile)BOrd.make((String)(this.getBaseDirectory() + '/' + this.getDatabaseName() + ".properties")).get();
        }
        catch (Exception exception) {
            return true;
        }
        Properties properties = new Properties();
        properties.load(bIFile.getInputStream());
        String string = properties.getProperty("version");
        Version version = new Version(string);
        Version version2 = new Version("2.0");
        if (version.compareTo((Object)version2) < 0) {
            String string2;
            Log.getLog((String)"rdb").message("Upgrading HSQL Database from " + version + " to 2.X");
            String string3 = properties.getProperty("modified");
            if (string3 != null && string3.equals("yes")) {
                string2 = "***This HSQL " + version + " Database was being modified while the HSQL backup occured; if you plan on safely upgrading a backup of a Hsql 1.8 database to HSQL 2.X, you may need to shutdown the station using Hsql 1.8 before backing it up.";
                Log.getLog((String)"rdb").warning(string2);
            }
            BHsqlDatabase.addProps(properties);
            properties.save(bIFile.getOutputStream(), "none");
            this.oldPropertiesFile = properties;
            string2 = (BIFile)BOrd.make((String)(this.getBaseDirectory() + '/' + this.getDatabaseName() + ".script")).get();
            String string4 = FileUtil.readString((BIFile)string2);
            string4 = TextUtil.replace((String)string4, (String)" BINARY", (String)" BINARY(16)");
            string2.write(string4.getBytes());
            return true;
        }
        return true;
    }

    public RdbmsContext getRdbmsContext() {
        return this.dialect;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.checkedForHsql_1_8_to_2_0_Upgrade = false;
        this.dialect = new RdbmsDialect(){

            public final String getValidationQuery() {
                return "CALL USER()";
            }

            public final void issueCheckpoint(Connection connection) throws SQLException {
                this.executeSql(connection, "SET FILES DEFRAG " + BHsqlDatabase.this.getCheckpointDefragSize());
                this.executeSql(connection, "CHECKPOINT DEFRAG");
            }

            private final void executeSql(Connection connection, String string) throws SQLException {
                Log.getLog((String)"rdb").trace(string);
                connection.createStatement().execute(string);
            }

            public final boolean supportsBatchInsert() {
                return false;
            }

            public final boolean supportsBatchUpdate() {
                return false;
            }

            public final boolean supportsBatchDelete() {
                return true;
            }

            public final int getInsertionMode() {
                return 2;
            }

            public final String getIdentityCreation() {
                return "GENERATED BY DEFAULT AS IDENTITY";
            }

            public final String getIdentityLookup() {
                return "CALL IDENTITY()";
            }

            public final String getSequenceName(String string) {
                throw new UnsupportedOperationException();
            }

            public final String getSequenceLookup(String string) {
                throw new UnsupportedOperationException();
            }

            public final String getAlterColumn() {
                return "ALTER COLUMN";
            }

            public final String getAlterColumnSuffix() {
                return null;
            }

            public final boolean getAlterColumnSupportsNotNull() {
                return false;
            }

            public final String getStringLengthFunctionName() {
                return "CHAR_LENGTH";
            }

            public final int getMaxTableName() {
                return 128;
            }

            public final int getMaxIndexName() {
                return 128;
            }

            public final int getMaxConstraintName() {
                return 128;
            }

            public final int getMaxColumnName() {
                return 128;
            }

            public final boolean allowsUnicodeNames() {
                return false;
            }

            public final String getColumnIdentifier(String string, String string2, String string3) {
                if (string != null && string.length() > 0) {
                    return string + '.' + string2 + ".\"" + string3 + '\"';
                }
                return string2 + ".\"" + string3 + '\"';
            }

            public final String getTableIdentifier(String string, String string2) {
                if (string != null && string.length() > 0) {
                    return string + '.' + string2;
                }
                return string2;
            }

            public final String getDropIndex(String string, String string2) {
                return "DROP INDEX " + string2;
            }

            public final String getDropConstraint(String string, Constraint constraint) {
                return "ALTER TABLE " + string + " DROP CONSTRAINT " + constraint.getName();
            }

            public final String getIntType() {
                return "INTEGER";
            }

            public final String getLongType() {
                return "BIGINT";
            }

            public final String getFloatType() {
                return "REAL";
            }

            public final String getDoubleType() {
                return "DOUBLE PRECISION";
            }

            public final String getCharType() {
                BHsqlDatabase.this.getUseUnicodeEncodingScheme();
                return "CHAR";
            }

            public final String getVarCharType() {
                return BHsqlDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
            }

            public final String getUuidType() {
                return "BINARY(16)";
            }

            public final String getDateType() {
                return "DATE";
            }

            public final String getBooleanType() {
                return "BOOLEAN";
            }

            public final String getTimestampType() {
                return "TIMESTAMP";
            }

            public final boolean supportsBooleanType() {
                return true;
            }

            public final boolean supportsDateType() {
                return true;
            }

            public final boolean supportsMillisecondTimestamp() {
                boolean bl = false;
                if (BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.localTimestamp) || BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp)) {
                    bl = true;
                }
                return bl;
            }

            public final boolean useUtcTimestamps() {
                return BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
            }

            public final String getBlobType() {
                return "LONGVARBINARY";
            }

            public final boolean usesDefaultBlobTranslator() {
                return true;
            }

            public final void setBlobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, byte[] byArray) {
                throw new UnsupportedOperationException();
            }

            public final String getClobType() {
                return "LONGVARCHAR";
            }

            public final boolean usesDefaultClobTranslator() {
                return true;
            }

            public final void setClobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, String string) {
                throw new UnsupportedOperationException();
            }

            public final String getOnDelete(int n) {
                switch (n) {
                    case 1: {
                        return "CASCADE";
                    }
                    case 0: {
                        return "NO ACTION";
                    }
                }
                throw new IllegalStateException();
            }

            public final boolean supportsDropColumn() {
                return true;
            }

            public final boolean supportsRenameTable() {
                return false;
            }

            public final boolean supportsClusteredIndex() {
                return false;
            }

            public final int getJdbcTypeBlob() {
                return -4;
            }

            public final int getJdbcTypeBoolean() {
                return 16;
            }

            public final int getJdbcTypeChar() {
                return 1;
            }

            public final int getJdbcTypeClob() {
                return -1;
            }

            public final int getJdbcTypeDouble() {
                return 8;
            }

            public final int getJdbcTypeFloat() {
                return 7;
            }

            public final int getJdbcTypeInt() {
                return 4;
            }

            public final int getJdbcTypeLong() {
                return -5;
            }

            public final int getJdbcTypeTimestamp() {
                return -5;
            }

            public final int getJdbcTypeUuid() {
                return -2;
            }

            public final int getJdbcTypeVarchar() {
                return 12;
            }

            public final int getJdbcTypeDate() {
                return 91;
            }
        };
    }

    public BHsqlDatabase() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$rdb$hsqldb$BHsqlDatabase;
        if (clazz == null) {
            clazz = class$com$tridium$rdb$hsqldb$BHsqlDatabase = BHsqlDatabase.class("[Lcom.tridium.rdb.hsqldb.BHsqlDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

