/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.serial;

import javax.baja.log.Log;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSerialHelper
extends BComponent {
    public static final String noPort = "none";
    public static final Property status = BSerialHelper.newProperty((int)3, (BValue)BStatus.down, null);
    public static final Property portName = BSerialHelper.newProperty((int)64, (String)"none", null);
    public static final Property baudRate = BSerialHelper.newProperty((int)0, (BValue)BSerialBaudRate.baud9600, null);
    public static final Property dataBits = BSerialHelper.newProperty((int)0, (BValue)BSerialDataBits.dataBits8, null);
    public static final Property stopBits = BSerialHelper.newProperty((int)0, (BValue)BSerialStopBits.stopBit1, null);
    public static final Property parity = BSerialHelper.newProperty((int)0, (BValue)BSerialParity.none, null);
    public static final Property flowControlMode = BSerialHelper.newProperty((int)0, (BValue)BSerialFlowControlMode.none, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private BISerialHelperParent host;
    private BISerialPort port;
    private boolean openPortFailure;
    private boolean portParamFailure;
    private boolean flowControlFailure;
    static /* synthetic */ Class class$javax$baja$serial$BSerialHelper;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getPortName() {
        return this.getString(portName);
    }

    public void setPortName(String string) {
        this.setString(portName, string, null);
    }

    public BBaudRate getBaudRate() {
        return (BBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BBaudRate bBaudRate) {
        this.set(baudRate, (BValue)bBaudRate, null);
    }

    public BSerialDataBits getDataBits() {
        return (BSerialDataBits)this.get(dataBits);
    }

    public void setDataBits(BSerialDataBits bSerialDataBits) {
        this.set(dataBits, (BValue)bSerialDataBits, null);
    }

    public BSerialStopBits getStopBits() {
        return (BSerialStopBits)this.get(stopBits);
    }

    public void setStopBits(BSerialStopBits bSerialStopBits) {
        this.set(stopBits, (BValue)bSerialStopBits, null);
    }

    public BSerialParity getParity() {
        return (BSerialParity)this.get(parity);
    }

    public void setParity(BSerialParity bSerialParity) {
        this.set(parity, (BValue)bSerialParity, null);
    }

    public BSerialFlowControlMode getFlowControlMode() {
        return (BSerialFlowControlMode)this.get(flowControlMode);
    }

    public void setFlowControlMode(BSerialFlowControlMode bSerialFlowControlMode) {
        this.set(flowControlMode, (BValue)bSerialFlowControlMode, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setSerialHelperParent(BISerialHelperParent bISerialHelperParent) {
        this.host = bISerialHelperParent;
    }

    public BISerialHelperParent getSerialHelperParent() {
        if (this.host != null) {
            return this.host;
        }
        return (BISerialHelperParent)this.getParent();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BISerialHelperParent;
    }

    public BISerialPort open(String string) throws Exception {
        BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        ((BComponent)bISerialService).lease();
        try {
            this.port = bISerialService.openPort(this.getPortName(), string);
        }
        catch (PortNotFoundException portNotFoundException) {
            String string2 = "'" + this.getPortName() + "' not a valid comm port.";
            log.error(string2, (Throwable)((Object)portNotFoundException));
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw portNotFoundException;
        }
        catch (PortDeniedException portDeniedException) {
            String string3 = "Denied opening comm port '" + this.getPortName() + '\'';
            log.error(string3, (Throwable)((Object)portDeniedException));
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw portDeniedException;
        }
        catch (Exception exception) {
            String string4 = "Exception opening comm port '" + this.getPortName() + '\'';
            log.error(string4, (Throwable)exception);
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw exception;
        }
        this.openPortFailure = false;
        try {
            this.port.setSerialPortParams(this.getBaudRate(), this.getDataBits(), this.getStopBits(), this.getParity());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string5 = "Unsupported comm parameter for " + this.getPortName();
            log.error(string5, (Throwable)unsupportedOperationException);
            this.portParamFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            String string6 = "Exception setting comm parameters for " + this.getPortName();
            log.error(string6, (Throwable)exception);
            this.portParamFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw exception;
        }
        this.portParamFailure = false;
        try {
            this.port.setFlowControlMode(this.getFlowControlMode());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string7 = "Unsupported comm parameter (flow control mode) for " + this.getPortName();
            log.error(string7, (Throwable)unsupportedOperationException);
            this.flowControlFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            String string8 = "Exception setting flow control mode for " + this.getPortName();
            log.error(string8, (Throwable)exception);
            this.flowControlFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw exception;
        }
        this.flowControlFailure = false;
        this.computeStatus();
        return this.port;
    }

    public void changed(Property property, Context context) {
        if (this.getSerialHelperParent() != null) {
            this.getSerialHelperParent().changed(property, context);
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)portName)) {
            if (this.getPortName().equals(noPort)) {
                this.computeStatus();
            }
            this.getSerialHelperParent().reopenPort();
            return;
        }
        if (property.equals((Object)dataBits) || property.equals((Object)stopBits) || property.equals((Object)parity) || property.equals((Object)baudRate)) {
            if (this.port != null) {
                this.updatePortParms(this.getBaudRate(), this.getDataBits(), this.getStopBits(), this.getParity());
            }
        } else if (property.equals((Object)flowControlMode)) {
            try {
                if (this.port != null) {
                    this.port.setFlowControlMode(this.getFlowControlMode());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                log.error("Unsupported comm parameter", (Throwable)unsupportedOperationException);
                this.flowControlFailure = true;
                this.computeStatus();
                throw new RuntimeException("Unsupported comm parameter");
            }
            this.flowControlFailure = false;
            this.computeStatus();
        } else {
            super.changed(property, context);
        }
    }

    private final void updatePortParms(BBaudRate bBaudRate, BSerialDataBits bSerialDataBits, BSerialStopBits bSerialStopBits, BSerialParity bSerialParity) {
        try {
            this.port.setSerialPortParams(bBaudRate, bSerialDataBits, bSerialStopBits, bSerialParity);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.error("Unsupported comm parameter", (Throwable)unsupportedOperationException);
            this.portParamFailure = true;
            this.computeStatus();
            throw new RuntimeException("Unsupported comm parameter");
        }
        this.portParamFailure = false;
        this.computeStatus();
    }

    private final void computeStatus() {
        if (this.getPortName().equals(noPort)) {
            this.setStatus(BStatus.down);
            return;
        }
        if (this.openPortFailure || this.portParamFailure || this.flowControlFailure) {
            this.setStatus(BStatus.fault);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.port = null;
        this.openPortFailure = false;
        this.portParamFailure = false;
        this.flowControlFailure = false;
    }

    public BSerialHelper() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$serial$BSerialHelper;
        if (clazz == null) {
            clazz = class$javax$baja$serial$BSerialHelper = BSerialHelper.class("[Ljavax.baja.serial.BSerialHelper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = Log.getLog((String)"SerialHelper");
    }
}

