/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciBacnetParser;

import com.jci.jciBacnetParser.BacNetController;
import com.jci.jciCoreParser.BJciAbstractParseImportFile;
import com.jci.jciCoreParser.BJciGeneralParseCSV;
import com.jci.jciCoreParser.ui.BJciImportDialog;
import com.jci.jciCoreParser.util.GeneralAppPoint;
import com.jci.jciCoreParser.util.JciImportPoint;
import com.jci.jciCoreParser.util.ParseUtil;
import com.jci.jciCoreParser.util.PointOrderComparator;
import com.jci.jciCoreParser.util.WT4000CSVAppPoint;
import com.jci.jciCoreParser.util.WT4000CSVBacnetPoint;
import com.jci.jciCoreParser.util.WT4000CSVFileVersionComparator;
import com.jci.jciCoreParser.util.WT4000StatDevice;
import com.jci.jciFxDriver.BJciDeviceMixIn;
import com.jci.jciFxDriver.appliance.BJCIOptions;
import com.jci.jciSupport.BJciProxyPointMixin;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.agent.BPxView;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetPointFolder;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciBacnetParseWT4000CSV
extends BJciGeneralParseCSV {
    public static final Type TYPE;
    static Lexicon lex;
    private static final int BACNET_PT_TYPE = 0;
    private static final int DEVICE_TYPE = 1;
    private static final int BACNET_PT_INSTANCE_NUM = 2;
    private static final int DESC = 3;
    private static final int INTERNAL_DEV_TYPE = 4;
    private static final int UNITS_OR_ADDR_DETAILS = 5;
    private static final int DEVICE_NUMBER_IN_GATEWAY = 6;
    private static final int POINT_MODBUS_REG = 7;
    private static final int UTC_REG = 8;
    private static final int SECONDARY_UNITS = 9;
    private static final int BYTE_INDICATION = 1000;
    private static final int BIT_INDICATION = 1100;
    private static final int MFM = 159;
    private static final int MFR = 145;
    private static final int MCR = 161;
    private static final int MCM = 160;
    private static final int GATEWAY = 0;
    private static final String WT4000_STR = "WT4000";
    private static final String MFM_STR = "MFM";
    private static final String MFR_STR = "MFR";
    private static final String MCM_STR = "MCM";
    private static final String MCR_STR = "MCR";
    private static final String UNDERSCORE = "_";
    private static final char COMMA = ',';
    private static final double BUTTON_SPACING = 35.0;
    private static final String ACTIVE_TEXT = "On";
    private static final String INACTIVE_TEXT = "Off";
    private static final String DEFAULT_SYSTEM_TYPE = "Stat Gateway";
    private static final String REL_1_COLUMN_HEADERS = "Type String,  Type, ID,  Descriptor, Dev_type, Units,  Modbus Addr, Modbus Register,  UTC register";
    protected String sControllerType;
    protected boolean setCOVForDev;
    protected boolean setupDefaultTP;
    public BacNetController myController;
    private boolean createDevice;
    private BBacnetTuningPolicy btp;
    protected BBacnetDevice bacnetdev;
    protected BBacnetNetwork bacnetnet;
    protected Array tuningPolicyNames;
    private String sCurLine;
    private String associateDeviceLayout;
    String[] indent;
    private String subDeviceValueBindingHyperLink;
    private String subDeviceAnnotationText;
    private String subDeviceAnnotationValue;
    String[] initalButtonLayout;
    String[] initalColumn1lButtonLayout;
    String[] initalColumn2lButtonLayout;
    private XElem CanvasPaneElem;
    static /* synthetic */ Class class$com$jci$jciBacnetParser$BJciBacnetParseWT4000CSV;
    static /* synthetic */ Class class$com$jci$jciCoreParser$util$WT4000CSVBacnetPoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$driver$point$BPointFolder;

    public Type getType() {
        return TYPE;
    }

    public BObject getStation() {
        return this.getStation((BComplex)this.bacnetnet);
    }

    public void setLocalDevice(BDevice bDevice) {
        this.setBacNetDevice((BBacnetDevice)bDevice);
    }

    public void setBacNetDevice(BBacnetDevice bBacnetDevice) {
        this.bacnetdev = bBacnetDevice;
    }

    public BBacnetDevice getBacNetDevice() {
        return this.bacnetdev;
    }

    public void setDeviceInfo(BBacnetNetwork bBacnetNetwork, String string, Integer n) {
        this.bacnetnet = bBacnetNetwork;
        this.devname = string;
        this.localNetwork = bBacnetNetwork;
    }

    public void addLinks() {
    }

    public String getControllerType() {
        return this.sControllerType;
    }

    public int startParse() {
        Class clazz;
        BBacnetDevice bBacnetDevice;
        int n = 0;
        this.myController = new BacNetController();
        this.myController.setBacNetDeviceName(this.devname);
        this.myController.setBacNetNetwork(this.bacnetnet);
        if (this.bacnetdev == null) {
            bBacnetDevice = this.myController.createBacNetDevice();
            this.createDevice = true;
            this.myController.setBacNetDevice(bBacnetDevice);
        } else {
            this.myController.setBacNetDevice(this.bacnetdev);
        }
        if ((clazz = class$com$jci$jciCoreParser$util$WT4000CSVBacnetPoint) == null) {
            clazz = class$com$jci$jciCoreParser$util$WT4000CSVBacnetPoint = BJciBacnetParseWT4000CSV.class("[Lcom.jci.jciCoreParser.util.WT4000CSVBacnetPoint;", false);
        }
        this.pointsToAdd = new Array(clazz);
        this.subDevices = new HashMap();
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = BJciBacnetParseWT4000CSV.class("[Ljava.lang.String;", false);
        }
        this.tuningPolicyNames = new Array(clazz2);
        n = this.parseInitialCSVFileFormat();
        if (this.xparSysLibFile != null) {
            this.xparSysLibFile.close();
        }
        if (this.subDevices.size() > 0 && (bBacnetDevice = (BJciDeviceMixIn)this.bacnetdev.getMixIn(BJciDeviceMixIn.TYPE)) != null) {
            boolean bl = bBacnetDevice.getCreateNewGraphicFile();
            boolean bl2 = bBacnetDevice.getCreateHxGraphicFile();
            if (bl || bl2) {
                BDeviceExt bDeviceExt;
                String string = bBacnetDevice.getWBSubDeviceGraphicFileName();
                String string2 = bBacnetDevice.getHXSubDeviceGraphicFileName();
                String string3 = bBacnetDevice.getWBGraphicFileName();
                String string4 = "Graphic.px";
                String string5 = "Hx.px";
                BDeviceExt[] bDeviceExtArray = this.bacnetdev.getDeviceExts();
                BPointDeviceExt bPointDeviceExt = null;
                int n2 = 0;
                while (n2 < bDeviceExtArray.length) {
                    bDeviceExt = bDeviceExtArray[n2];
                    if (bDeviceExt instanceof BPointDeviceExt) {
                        bPointDeviceExt = (BPointDeviceExt)bDeviceExt;
                        break;
                    }
                    ++n2;
                }
                if (bPointDeviceExt != null) {
                    Class clazz3 = class$javax$baja$driver$point$BPointFolder;
                    if (clazz3 == null) {
                        clazz3 = class$javax$baja$driver$point$BPointFolder = BJciBacnetParseWT4000CSV.class("[Ljavax.baja.driver.point.BPointFolder;", false);
                    }
                    Object[] objectArray = bPointDeviceExt.getChildren(clazz3);
                    Class clazz4 = class$javax$baja$driver$point$BPointFolder;
                    if (clazz4 == null) {
                        clazz4 = class$javax$baja$driver$point$BPointFolder = BJciBacnetParseWT4000CSV.class("[Ljavax.baja.driver.point.BPointFolder;", false);
                    }
                    bDeviceExt = new Array(clazz4);
                    BPxView bPxView = (BPxView)this.bacnetdev.get("Graphic");
                    System.out.println("graphic view for bacnet dev is " + bPxView);
                    BOrd bOrd = bPxView.getPxFile();
                    System.out.println("ord for px file is " + bOrd);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        Object object;
                        String string6;
                        BPointFolder bPointFolder = (BPointFolder)objectArray[n3];
                        String string7 = this.bacnetdev.getName() + bPointFolder.getName();
                        if (bl) {
                            BPxView bPxView2;
                            string6 = bBacnetDevice.copySystemPxFile(string, string7, "G", this.bacnetdev.getNavOrd(), (BDevice)this.bacnetdev, null, string4);
                            object = bBacnetDevice.copySystemPxFile(string3, "NEW" + this.bacnetdev.getName(), "G", this.bacnetdev.getNavOrd(), (BDevice)this.bacnetdev, null, string4);
                            if (string6.length() > 0) {
                                BPxView bPxView3 = bBacnetDevice.makeView("image.png", string6);
                                if (bPointFolder.get("Graphic") == null) {
                                    bPointFolder.add("Graphic", (BValue)bPxView3);
                                    bDeviceExt.add((Object)bPointFolder);
                                }
                                String string8 = "file:^Graphics/TotPoints.px";
                                bPxView2 = bBacnetDevice.makeView("listView.png", string8);
                                bPointFolder.add("Totalization", (BValue)bPxView2);
                                bBacnetDevice.cleanUnusedPointsFromGraphic(bPointFolder, string7, false, "G");
                            }
                            if (bDeviceExt.size() > 0) {
                                System.out.println("going to process graphic");
                                this.updateGatewayGraphic(string4, (Array)bDeviceExt);
                                bPxView2 = (BPxView)this.bacnetdev.get("Graphic");
                                if (bPxView2 == null) {
                                    bPxView2 = bBacnetDevice.makeView("image.png", (String)object);
                                    this.bacnetdev.add("Graphic", (BValue)bPxView2);
                                } else {
                                    bPxView2.setPxFile(BOrd.make((String)object));
                                }
                            }
                        }
                        if (bl2 && (string6 = bBacnetDevice.copySystemPxFile(string2, string7, "H", this.bacnetdev.getNavOrd(), (BDevice)this.bacnetdev, null, string5)).length() > 0) {
                            object = bBacnetDevice.makeView("image.png", string6);
                            if (bPointFolder.get("HxGraphic") == null) {
                                bPointFolder.add("HxGraphic", (BValue)object);
                                bBacnetDevice.cleanUnusedPointsFromGraphic(bPointFolder, string7, false, "H");
                            }
                        }
                        ++n3;
                    }
                }
            }
            bBacnetDevice.loadSlots();
        }
        this.syslibRoot = null;
        this.pointsToAdd.clear();
        this.pointsToAdd = null;
        this.subDevices.clear();
        this.subDevices = null;
        this.importPointrows.clear();
        this.importPointrows = null;
        return n;
    }

    private final void updateGatewayGraphic(String string, Array array) {
        FilePath filePath = new FilePath("^");
        FilePath filePath2 = new FilePath(filePath.getBody() + "Graphics/NEW" + this.bacnetdev.getName() + string);
        FilePath filePath3 = new FilePath(filePath.getBody() + "Graphics/" + this.bacnetdev.getName() + string);
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)this.bacnetdev);
        try {
            XElem xElem;
            BIFile bIFile = bFileSpace.makeFile(filePath2);
            System.out.println("updated file is " + bIFile);
            BIFile bIFile2 = bFileSpace.makeFile(filePath3);
            System.out.println("origFile is " + bIFile2);
            XParser xParser = XParser.make((InputStream)bIFile.getInputStream());
            XElem xElem2 = xParser.parse();
            XElem xElem3 = xElem2.elem("import");
            if (xElem3 != null) {
                xElem = new XElem("module");
                xElem.addAttr("name", "bacnet");
                xElem3.addContent((XContent)xElem);
            }
            this.processGraphicElems(xElem2, array, 0);
            double d = Double.valueOf(this.initalColumn1lButtonLayout[1]);
            double d2 = Double.valueOf(this.initalColumn2lButtonLayout[1]);
            System.out.println("first y value is " + d);
            System.out.println("subPXgraphics size is " + array.size());
            d -= 35.0;
            d2 -= 35.0;
            int n = 0;
            while (n < array.size()) {
                xElem = (BPointFolder)array.get(n);
                String string2 = n % 2 == 0 ? this.initalColumn1lButtonLayout[0] + ',' + (d += 35.0) + ',' + this.initalColumn1lButtonLayout[2] + ',' + this.initalColumn1lButtonLayout[3] : this.initalColumn2lButtonLayout[0] + ',' + (d2 += 35.0) + ',' + this.initalColumn2lButtonLayout[2] + ',' + this.initalColumn2lButtonLayout[3];
                XElem xElem4 = this.makeImageButton(xElem.getName(), string2);
                System.out.println("before add content button num CanvasPane elems is " + this.CanvasPaneElem.elems().length);
                this.CanvasPaneElem.addContent((XContent)xElem4);
                System.out.println("after add content button num CanvasPane elems is " + this.CanvasPaneElem.elems().length);
                ++n;
            }
            XWriter xWriter = new XWriter(bIFile.getOutputStream());
            xWriter.prolog();
            xElem2.write(xWriter);
            xWriter.close();
            xParser.close();
            System.out.println("trying to delete " + filePath3.getBody());
            File file = new File(filePath3.getBody());
            FileUtil.delete((File)file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void processGraphicElems(XElem xElem, Array array, int n) {
        XElem xElem2;
        int n2;
        System.out.println("at level " + n + " elem is " + xElem.toString());
        System.out.println("elem has " + xElem.elems().length + " elems");
        int n3 = xElem.elems().length;
        if (n3 > 0) {
            n2 = 0;
            while (n2 < n3) {
                xElem2 = xElem.elem(n2);
                this.processGraphicElems(xElem2, array, n + 1);
                ++n2;
            }
        }
        if (xElem.name().equalsIgnoreCase("CanvasPane")) {
            this.CanvasPaneElem = xElem;
            n3 = xElem.elems().length;
            if (n3 > 0) {
                n2 = 0;
                while (n2 < n3) {
                    xElem2 = xElem.elem(n2);
                    if (xElem2.name().equalsIgnoreCase("LocalizableLabel")) {
                        String string = xElem2.get("textFormat");
                        this.associateDeviceLayout = xElem2.get("layout");
                        System.out.println("found localizablelabel with text " + string + " and layout " + this.associateDeviceLayout);
                    }
                    ++n2;
                }
            }
        }
    }

    private final XElem makeImageButton(String string, String string2) {
        String string3 = "BacnetNetwork";
        XElem xElem = new XElem("ImageButton");
        String string4 = this.bacnetdev.getName();
        xElem.addAttr("layout", string2);
        xElem.addAttr("text", string);
        XElem xElem2 = new XElem("ValueBinding");
        xElem2.addAttr("hyperlink", this.subDeviceValueBindingHyperLink + string3 + '/' + string4 + "/points/" + string + "|view:Graphic");
        XElem xElem3 = new XElem("WsAnnotation");
        xElem3.addAttr("name", this.subDeviceAnnotationText);
        xElem3.addAttr("value", this.subDeviceAnnotationValue);
        xElem.addContent((XContent)xElem2);
        xElem.addContent((XContent)xElem3);
        System.out.println("adding button " + xElem.toString());
        return xElem;
    }

    private final void writeToXmlFile(XWriter xWriter, String string) {
        if (!string.equals("")) {
            string = TextUtil.replace((String)string, (String)"'", (String)"\"");
            xWriter.write(string + '\n');
        }
    }

    private final String getTag(String string) {
        String string2 = "";
        int n = string.indexOf("<") + 1;
        while (string.charAt(n) != ' ' && string.charAt(n) != '>') {
            string2 = string2 + string.charAt(n++);
        }
        return string2;
    }

    private final String getFooter(String string) {
        return "</" + this.getTag(string) + '>';
    }

    public int parseInitialCSVFileFormat() {
        if (this.verifySysLibFile() || this.sysLibFilePath.length() == 0) {
            this.setAppGroupFromCSV();
            boolean bl = this.getCSVPoints();
            if (!bl) {
                return -1;
            }
        } else {
            this.logError(lex.getText("parseCSV.badLibraryFile"));
            return -2;
        }
        this.UnitsOfMeasure = this.determineUnitsOfMeasure();
        this.addPoints();
        this.myController.parseComplete();
        return 0;
    }

    protected boolean getCSVPoints() {
        boolean bl = false;
        int n = 0;
        try {
            this.sCurLine = this.lineReader.readLine();
            if (this.isHeader(this.sCurLine, 1)) {
                this.sCurLine = this.lineReader.readLine();
            }
            while (this.sCurLine != null) {
                this.processObj(this.sCurLine);
                ++n;
                this.sCurLine = this.lineReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logError(lex.getText("parseCSV.ErrorReading") + ' ' + lex.getText("parse.FromMethod") + ": startparse");
        }
        bl = n > 0;
        return bl;
    }

    private final boolean isHeader(String string, int n) {
        boolean bl = false;
        if (n == 1 && string.indexOf(REL_1_COLUMN_HEADERS) >= 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean processObj(String string) {
        boolean bl = false;
        WT4000CSVBacnetPoint wT4000CSVBacnetPoint = this.processLine(string);
        if (wT4000CSVBacnetPoint == null) {
            bl = false;
        } else {
            Integer n = new Integer(wT4000CSVBacnetPoint.getDeviceNum());
            WT4000StatDevice wT4000StatDevice = (WT4000StatDevice)this.subDevices.get(n);
            if (wT4000StatDevice == null) {
                this.pointsToAdd.add((Object)wT4000CSVBacnetPoint);
            } else {
                wT4000StatDevice.pointList.add((Object)wT4000CSVBacnetPoint);
            }
            bl = true;
        }
        return bl;
    }

    protected WT4000CSVBacnetPoint processLine(String string) {
        WT4000CSVBacnetPoint wT4000CSVBacnetPoint = null;
        boolean bl = false;
        String string2 = null;
        String string3 = "";
        String string4 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String string5 = null;
        String[] stringArray = ParseUtil.tocanizeString((String)string, (String)",", (boolean)false);
        if (stringArray.length >= 10 && stringArray[9] != null && stringArray[9].length() > 0) {
            bl = true;
            n6 = Integer.parseInt(stringArray[9]);
        }
        string2 = stringArray[3];
        string3 = stringArray[3];
        n = Integer.parseInt(stringArray[1]);
        n2 = Integer.parseInt(stringArray[7]);
        string4 = stringArray[0];
        string5 = stringArray[2];
        n5 = Integer.parseInt(stringArray[5]);
        if (bl) {
            if (string2.indexOf("Bit") > 0) {
                n4 = n5 % 1100;
            } else if (string2.indexOf("Byte") > 0) {
                n3 = n5 % 1000;
            } else if (n5 >= 1000 && n5 < 1100) {
                n3 = n5 % 1000;
            } else if (n5 >= 1100) {
                n4 = n5 % 1100;
            }
        }
        n7 = Integer.parseInt(stringArray[6]);
        wT4000CSVBacnetPoint = new WT4000CSVBacnetPoint(string2);
        wT4000CSVBacnetPoint.setClassid(string4);
        wT4000CSVBacnetPoint.description = string3;
        wT4000CSVBacnetPoint.setModbusRegister(n2);
        wT4000CSVBacnetPoint.setBitNum(n4);
        wT4000CSVBacnetPoint.setByteNum(n3);
        wT4000CSVBacnetPoint.setDeviceNum(n7);
        wT4000CSVBacnetPoint.setDeviceType(n);
        wT4000CSVBacnetPoint.setObjectid(string5);
        if (n6 > -1) {
            wT4000CSVBacnetPoint.setBacnetUnits(n6);
        } else {
            wT4000CSVBacnetPoint.setBacnetUnits(n5);
        }
        Integer n8 = new Integer(n7);
        if ((WT4000StatDevice)this.subDevices.get(n8) == null) {
            WT4000StatDevice wT4000StatDevice = new WT4000StatDevice();
            wT4000StatDevice.setDeviceType(n);
            wT4000StatDevice.setModbusAddress(n7);
            this.subDevices.put(n8, wT4000StatDevice);
        }
        return wT4000CSVBacnetPoint;
    }

    protected int convertClassId(String string) {
        if (string.equals("ai")) {
            return 0;
        }
        if (string.equals("av")) {
            return 2;
        }
        if (string.equals("bi")) {
            return 3;
        }
        return -1;
    }

    protected String determineNiagaraTypeAsString(WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        String string = null;
        int n = this.convertClassId(wT4000CSVBacnetPoint.getClassid());
        boolean bl = wT4000CSVBacnetPoint.isReadonly();
        switch (n) {
            case 0: {
                string = "NumericPoint";
                break;
            }
            case 1: {
                string = "NumericWritable";
                break;
            }
            case 2: {
                if (!bl) {
                    string = "NumericWritable";
                    break;
                }
                string = "NumericPoint";
                break;
            }
            case 3: {
                string = "BooleanPoint";
                break;
            }
            case 4: {
                string = "BooleanWritable";
                break;
            }
            case 5: {
                if (!bl) {
                    string = "BooleanWritable";
                    break;
                }
                string = "BooleanPoint";
                break;
            }
            case 13: {
                string = "EnumPoint";
                break;
            }
            case 14: {
                string = "EnumWritable";
                break;
            }
            case 19: {
                if (!bl) {
                    string = "EnumWritable";
                    break;
                }
                string = "EnumPoint";
                break;
            }
            default: {
                string = "BooleanPoint";
            }
        }
        return string;
    }

    protected BControlPoint determineNiagaraType(WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        BNumericPoint bNumericPoint = null;
        int n = this.convertClassId(wT4000CSVBacnetPoint.getClassid());
        boolean bl = wT4000CSVBacnetPoint.isReadonly();
        switch (n) {
            case 0: {
                bNumericPoint = new BNumericPoint();
                break;
            }
            case 1: {
                bNumericPoint = new BNumericWritable();
                break;
            }
            case 2: {
                if (!bl) {
                    bNumericPoint = new BNumericWritable();
                    break;
                }
                bNumericPoint = new BNumericPoint();
                break;
            }
            case 3: {
                bNumericPoint = new BBooleanPoint();
                break;
            }
            case 4: {
                bNumericPoint = new BBooleanWritable();
                break;
            }
            case 5: {
                if (!bl) {
                    bNumericPoint = new BBooleanWritable();
                    break;
                }
                bNumericPoint = new BBooleanPoint();
                break;
            }
            case 13: {
                bNumericPoint = new BEnumPoint();
                break;
            }
            case 14: {
                bNumericPoint = new BEnumWritable();
                break;
            }
            case 19: {
                if (!bl) {
                    bNumericPoint = new BEnumWritable();
                    break;
                }
                bNumericPoint = new BEnumPoint();
                break;
            }
            default: {
                bNumericPoint = new BStringPoint();
            }
        }
        return bNumericPoint;
    }

    protected boolean hasOccSensor(String string) {
        boolean bl = false;
        int n = Integer.parseInt(string);
        switch (n) {
            case 159: {
                bl = true;
                break;
            }
            case 145: {
                bl = false;
                break;
            }
            case 160: {
                bl = true;
                break;
            }
            case 161: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected String getDeviceName(int n) {
        String string = null;
        switch (n) {
            case 159: {
                string = MFM_STR;
                break;
            }
            case 145: {
                string = MFR_STR;
                break;
            }
            case 160: {
                string = MCM_STR;
                break;
            }
            case 161: {
                string = MCR_STR;
                break;
            }
            default: {
                string = MFM_STR;
            }
        }
        return string;
    }

    public void addPoints() {
        Object object;
        BBacnetPointFolder bBacnetPointFolder;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        XElem xElem = null;
        boolean bl = true;
        if (this.useSysLibFile) {
            objectArray2 = this.syslibRoot.elems();
            n = 0;
            while (n < objectArray2.length) {
                if (objectArray2[n].name().equals("Objects")) {
                    xElem = objectArray2[n];
                    break;
                }
                ++n;
            }
        }
        objectArray2 = this.subDevices.values().toArray();
        n = 0;
        while (n < objectArray2.length) {
            objectArray = (Object[])objectArray2[n];
            bBacnetPointFolder = this.determineSubDevice((WT4000StatDevice)objectArray);
            if (bBacnetPointFolder != null) {
                BBacnetPointDeviceExt bBacnetPointDeviceExt = this.myController.getBacNetDevice().getPoints();
                object = "WT4000_" + objectArray.getModbusAddress();
                bBacnetPointDeviceExt.add((String)object, (BValue)bBacnetPointFolder);
                BBacnetPointFolder bBacnetPointFolder2 = (BBacnetPointFolder)bBacnetPointDeviceExt.get((String)object);
                this.addPointsForDev((WT4000StatDevice)objectArray2[n], xElem, bBacnetPointFolder2);
            } else {
                this.addPointsForDev((WT4000StatDevice)objectArray2[n], xElem, bBacnetPointFolder);
            }
            ++n;
        }
        n = this.pointsToAdd.size();
        objectArray = new Object[n];
        bBacnetPointFolder = new PointOrderComparator();
        int n2 = 0;
        while (n2 < n) {
            object = (WT4000CSVAppPoint)this.pointsToAdd.get(n2);
            if (this.useSysLibFile) {
                bl = this.checkPointWithLibraryRetry((WT4000CSVAppPoint)object, xElem);
                object.setValidAdd(bl);
            } else {
                object.setValidAdd(bl);
            }
            objectArray[n2] = object;
            ++n2;
        }
        Arrays.sort(objectArray, bBacnetPointFolder);
        n2 = 0;
        while (n2 < n) {
            object = (WT4000CSVBacnetPoint)objectArray[n2];
            bl = object.getValidAdd();
            if (bl) {
                this.addProxyPoints((WT4000CSVBacnetPoint)object, null, null);
            }
            ++n2;
        }
    }

    private final void addPointsForDev(WT4000StatDevice wT4000StatDevice, XElem xElem, BBacnetPointFolder bBacnetPointFolder) {
        Object object;
        boolean bl = true;
        Array array = wT4000StatDevice.getPointList();
        int n = array.size();
        Object[] objectArray = new Object[n];
        PointOrderComparator pointOrderComparator = new PointOrderComparator();
        int n2 = 0;
        while (n2 < n) {
            object = (WT4000CSVAppPoint)array.get(n2);
            if (this.useSysLibFile) {
                bl = this.checkPointWithLibraryRetry((WT4000CSVAppPoint)object, xElem);
                object.setValidAdd(bl);
            } else {
                object.setValidAdd(bl);
            }
            objectArray[n2] = object;
            ++n2;
        }
        Arrays.sort(objectArray, pointOrderComparator);
        if (this.shell != null) {
            n2 = BJCIOptions.make().getReviewPointsOnImport() ? 1 : 0;
            if (n2 != 0) {
                System.out.println("review points is true");
                this.importPointrows.clear();
                this.constructImportPointRows(objectArray);
                object = bBacnetPointFolder == null ? lex.getText("JciImportManager.gatewayDevice") : bBacnetPointFolder.getDisplayName(null);
                System.out.println("number of import points is " + this.importPointrows.size());
                BJciImportDialog bJciImportDialog = new BJciImportDialog((BWidget)this.shell, lex.getText("JciImportManager.reveiwPoints") + ' ' + (String)object, true);
                bJciImportDialog.setParser((BJciAbstractParseImportFile)this);
                System.out.println("before do dialog testing is " + this.testing);
                bJciImportDialog.setBoundsCenteredOnScreen();
                bJciImportDialog.open();
                System.out.println("after do dialog testing is " + this.testing + " and dialog result is " + bJciImportDialog.dialogResult);
                if (bJciImportDialog.dialogResult == 1) {
                    System.out.println("dialog result is ok");
                    this.updatedPoints = bJciImportDialog.getUpdatedPoints();
                    System.out.println("length of updated points is " + this.updatedPoints.size() + " first point is " + ((JciImportPoint)this.updatedPoints.get(0)).toString());
                    this.updatePointArray(objectArray);
                }
            } else {
                System.out.println("review points false");
            }
        }
        n2 = 0;
        while (n2 < n) {
            object = (WT4000CSVBacnetPoint)objectArray[n2];
            bl = object.getValidAdd();
            if (bl) {
                this.addProxyPoints((WT4000CSVBacnetPoint)object, bBacnetPointFolder, wT4000StatDevice);
            }
            ++n2;
        }
    }

    private final WT4000CSVBacnetPoint modifyPointInPointsToAdd(JciImportPoint jciImportPoint, WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        WT4000CSVBacnetPoint wT4000CSVBacnetPoint2 = wT4000CSVBacnetPoint;
        String string = jciImportPoint.name;
        String string2 = jciImportPoint.niagaraPointType;
        boolean bl = jciImportPoint.importEnabled;
        boolean bl2 = jciImportPoint.readOnly;
        if (!string.equals(wT4000CSVBacnetPoint.currentname)) {
            wT4000CSVBacnetPoint2.currentname = string;
        }
        wT4000CSVBacnetPoint2.updatedPointType = string2;
        if (wT4000CSVBacnetPoint.isReadonly() == jciImportPoint.readOnly) {
            wT4000CSVBacnetPoint2.updatedReadOnly = false;
        } else {
            wT4000CSVBacnetPoint2.updatedReadOnly = true;
            wT4000CSVBacnetPoint2.setReadonly(bl2);
        }
        wT4000CSVBacnetPoint2.updatedReadOnly = bl2;
        wT4000CSVBacnetPoint2.validAdd = bl;
        return wT4000CSVBacnetPoint2;
    }

    private final Object[] updatePointArray(Object[] objectArray) {
        this.importPointrows.clear();
        System.out.println("importPointrows length is " + this.importPointrows.size());
        this.constructImportPointRows(objectArray);
        int n = 0;
        while (n < this.importPointrows.size()) {
            JciImportPoint jciImportPoint;
            JciImportPoint jciImportPoint2 = (JciImportPoint)this.importPointrows.get(n);
            if (!jciImportPoint2.equals((Object)(jciImportPoint = (JciImportPoint)this.updatedPoints.get(n)))) {
                System.out.println("comparing initial pt " + jciImportPoint2.toString() + " to updated point " + jciImportPoint.toString());
                WT4000CSVBacnetPoint wT4000CSVBacnetPoint = (WT4000CSVBacnetPoint)objectArray[n];
                System.out.println("orig point is " + wT4000CSVBacnetPoint.toString());
                objectArray[n] = this.modifyPointInPointsToAdd(jciImportPoint, wT4000CSVBacnetPoint);
                System.out.println("updated point is " + ((WT4000CSVBacnetPoint)objectArray[n]).toString());
            }
            ++n;
        }
        return objectArray;
    }

    private final void constructImportPointRows(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            WT4000CSVBacnetPoint wT4000CSVBacnetPoint = (WT4000CSVBacnetPoint)objectArray[n];
            boolean bl = wT4000CSVBacnetPoint.getValidAdd();
            String string = this.determineNiagaraTypeAsString(wT4000CSVBacnetPoint);
            JciImportPoint jciImportPoint = new JciImportPoint(wT4000CSVBacnetPoint.currentname, this.onlyTypePart(string), this.onlyRWPart(string), bl);
            this.importPointrows.add((Object)jciImportPoint);
            ++n;
        }
        this.testing = "did rows";
    }

    public void addProxyPoints(WT4000CSVBacnetPoint wT4000CSVBacnetPoint, BBacnetPointFolder bBacnetPointFolder, WT4000StatDevice wT4000StatDevice) {
        String string;
        BBacnetPointDeviceExt bBacnetPointDeviceExt = this.myController.getBacNetDevice().getPoints();
        BBacnetPointFolder bBacnetPointFolder2 = null;
        BControlPoint bControlPoint = null;
        BBacnetNumericProxyExt bBacnetNumericProxyExt = null;
        String string2 = null;
        String string3 = null;
        BFacets bFacets = null;
        String string4 = wT4000CSVBacnetPoint.getObjectid();
        int n = wT4000CSVBacnetPoint.getBacnetProperty();
        boolean bl = false;
        if (string4 != null) {
            String string5;
            if (bBacnetPointFolder != null) {
                bBacnetPointFolder2 = (BBacnetPointFolder)bBacnetPointFolder.get("Points");
            }
            boolean bl2 = false;
            boolean bl3 = wT4000CSVBacnetPoint.updatedReadOnly;
            if (wT4000CSVBacnetPoint.updatedPointType != null) {
                bl2 = true;
            }
            int n2 = this.convertClassId(wT4000CSVBacnetPoint.getClassid());
            string = wT4000CSVBacnetPoint.getObjectid();
            int n3 = Integer.parseInt(string);
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.make((int)n2, (int)n3);
            bControlPoint = bl2 ? this.determineNiagaraTypeFromString(wT4000CSVBacnetPoint.updatedPointType, wT4000CSVBacnetPoint.isReadonly()) : this.determineNiagaraType(wT4000CSVBacnetPoint);
            string3 = bControlPoint.getType().getTypeName();
            string2 = this.trimNiagaraType(string3);
            if (!(this.useSysLibFile && wT4000CSVBacnetPoint.currentname != null && wT4000CSVBacnetPoint.currentname.length() > 0 || (string5 = wT4000CSVBacnetPoint.originalname) == null || string5.length() <= 0)) {
                wT4000CSVBacnetPoint.currentname = string5;
            }
            if (!bl2) {
                if (n2 == 0 || n2 == 1 || n2 == 2) {
                    bBacnetNumericProxyExt = new BBacnetNumericProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue));
                    }
                    bFacets = this.createNumericFacet(wT4000CSVBacnetPoint);
                    bControlPoint.setFacets(bFacets);
                } else if (n2 == 3 || n2 == 4 || n2 == 5) {
                    bBacnetNumericProxyExt = new BBacnetBooleanProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((int)85));
                    }
                    bFacets = this.createBooleanFacet(wT4000CSVBacnetPoint);
                    bControlPoint.setFacets(bFacets);
                } else if (n2 == 13 || n2 == 14 || n2 == 19) {
                    bBacnetNumericProxyExt = new BBacnetEnumProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((int)85));
                    }
                    string5 = this.createEnumRange(wT4000CSVBacnetPoint);
                    if (string5 != null) {
                        bFacets = BFacets.makeEnum((BEnumRange)string5);
                        bControlPoint.setFacets(bFacets);
                    }
                }
            } else {
                string5 = wT4000CSVBacnetPoint.updatedPointType;
                if (string5.equalsIgnoreCase("Numeric")) {
                    bBacnetNumericProxyExt = new BBacnetNumericProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue));
                    }
                } else if (string5.equalsIgnoreCase("Boolean")) {
                    bBacnetNumericProxyExt = new BBacnetBooleanProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((int)85));
                    }
                } else if (string5.equalsIgnoreCase("Enum")) {
                    bBacnetNumericProxyExt = new BBacnetEnumProxyExt();
                    bBacnetNumericProxyExt.setObjectId(bBacnetObjectIdentifier);
                    if (BBacnetPropertyIdentifier.isValid((int)n)) {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make((int)n)));
                    } else {
                        bBacnetNumericProxyExt.setPropertyId(BDynamicEnum.make((int)85));
                    }
                }
            }
        }
        if (bControlPoint != null) {
            if (this.updateActionMenu) {
                this.myController.setUpActionMenu(bControlPoint, string3, bFacets);
            }
            bControlPoint.setProxyExt(bBacnetNumericProxyExt);
            this.addExtensions(bControlPoint, (GeneralAppPoint)wT4000CSVBacnetPoint, string2, wT4000CSVBacnetPoint.currentname);
            try {
                BBacnetProxyExt bBacnetProxyExt;
                String string6 = SlotPath.escape((String)wT4000CSVBacnetPoint.currentname);
                BControlPoint bControlPoint2 = null;
                if (bBacnetPointFolder2 != null) {
                    bBacnetPointFolder2.add(string6, bControlPoint);
                    bControlPoint2 = (BControlPoint)bBacnetPointFolder2.get(string6);
                } else {
                    bBacnetPointDeviceExt.add(string6, bControlPoint);
                    bControlPoint2 = (BControlPoint)bBacnetPointDeviceExt.get(string6);
                }
                if (bControlPoint2 != null && (string = (BJciProxyPointMixin)(bBacnetProxyExt = (BBacnetProxyExt)bControlPoint2.getProxyExt()).getMixIn(BJciProxyPointMixin.TYPE)) != null) {
                    string.setDescription(wT4000CSVBacnetPoint.description);
                }
            }
            catch (Exception exception) {
                System.out.println("error adding point " + wT4000CSVBacnetPoint);
                exception.printStackTrace();
            }
        } else {
            System.out.println("objstr is null");
        }
    }

    private final BBacnetPointFolder determineSubDevice(WT4000StatDevice wT4000StatDevice) {
        BBacnetPointFolder bBacnetPointFolder = null;
        if (wT4000StatDevice != null && wT4000StatDevice.getDeviceType() != 0) {
            bBacnetPointFolder = new BBacnetPointFolder();
            BBacnetPointFolder bBacnetPointFolder2 = new BBacnetPointFolder();
            bBacnetPointFolder.add("Points", (BValue)bBacnetPointFolder2);
        }
        return bBacnetPointFolder;
    }

    private final BEnumRange createEnumRange(WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        BEnumRange bEnumRange = BEnumRange.DEFAULT;
        return bEnumRange;
    }

    private final BFacets createNumericFacet(WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        BFacets bFacets = null;
        BUnit bUnit = null;
        int n = wT4000CSVBacnetPoint.getBacnetUnits();
        bUnit = BBacnetEngineeringUnits.getNiagaraUnits((int)n);
        bFacets = bUnit == null ? BFacets.makeNumeric() : BFacets.makeNumeric((BUnit)bUnit, (int)1);
        return bFacets;
    }

    private final BFacets createBooleanFacet(WT4000CSVBacnetPoint wT4000CSVBacnetPoint) {
        BFacets bFacets = null;
        String string = INACTIVE_TEXT;
        String string2 = ACTIVE_TEXT;
        bFacets = BFacets.makeBoolean((String)string2, (String)string);
        return bFacets;
    }

    public boolean verifyConfigFile() {
        boolean bl = false;
        try {
            int n;
            this.lineReader.reset();
            this.sCurLine = this.lineReader.readLine();
            if (this.sCurLine.indexOf(REL_1_COLUMN_HEADERS) != -1) {
                bl = true;
            } else {
                this.logError(lex.getText("parseCSV.InvalidCSV"));
                bl = false;
            }
            this.sCurLine = this.lineReader.readLine();
            this.systemtype = DEFAULT_SYSTEM_TYPE;
            String string = this.getSystemOfUnits(this.sCurLine);
            this.systemOfUnits = n = Integer.parseInt(string);
            this.resetLineNumber(this.lineReader.getLineNumber() - 2);
        }
        catch (Exception exception) {
            this.logError(lex.getText("parseCSV.ErrorReading") + ' ' + lex.getText("parse.FromMethod") + ": verifyConfigFile");
            bl = false;
        }
        return bl;
    }

    protected String getSystemOfUnits(String string) {
        String string2 = null;
        String[] stringArray = ParseUtil.tocanizeString((String)string, (String)",", (boolean)false);
        int n = Integer.parseInt(stringArray[1]);
        switch (n) {
            case 159: {
                string2 = "1";
                break;
            }
            case 145: {
                string2 = "1";
                break;
            }
            case 160: {
                string2 = "0";
                break;
            }
            case 161: {
                string2 = "0";
                break;
            }
            default: {
                string2 = "1";
            }
        }
        return string2;
    }

    protected int determineUnitsOfMeasure() {
        int n = this.systemOfUnits;
        return n;
    }

    protected void setAppGroupFromCSV() {
        String string = "";
        if (this.systemtype != null) {
            string = this.systemtype;
        }
        this.setAppGroup(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sControllerType = "WT4000Gateway";
        this.setCOVForDev = false;
        this.setupDefaultTP = false;
        this.createDevice = false;
        this.btp = null;
        this.subDeviceValueBindingHyperLink = "station:|slot:/Drivers/";
        this.subDeviceAnnotationText = "wsAnnotation";
        this.subDeviceAnnotationValue = "10,10,8";
        this.initalColumn1lButtonLayout = new String[]{"642", "90", "75", "30"};
        this.initalColumn2lButtonLayout = new String[]{"745", "90", "75", "30"};
    }

    public BJciBacnetParseWT4000CSV() {
        this.this();
        this.libraryIssues = 0;
        this.verComp = new WT4000CSVFileVersionComparator();
    }

    static {
        Class clazz = class$com$jci$jciBacnetParser$BJciBacnetParseWT4000CSV;
        if (clazz == null) {
            clazz = class$com$jci$jciBacnetParser$BJciBacnetParseWT4000CSV = BJciBacnetParseWT4000CSV.class("[Lcom.jci.jciBacnetParser.BJciBacnetParseWT4000CSV;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$jci$jciBacnetParser$BJciBacnetParseWT4000CSV;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciBacnetParser$BJciBacnetParseWT4000CSV = BJciBacnetParseWT4000CSV.class("[Lcom.jci.jciBacnetParser.BJciBacnetParseWT4000CSV;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

