/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.history.BTrendFlags;
import javax.baja.log.Log;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlServerDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$sqlserver$BSqlServerDeprecatedDialect == null ? (class$com$tridium$rdb$sqlserver$BSqlServerDeprecatedDialect = BSqlServerDeprecatedDialect.class$("com.tridium.rdb.sqlserver.BSqlServerDeprecatedDialect")) : class$com$tridium$rdb$sqlserver$BSqlServerDeprecatedDialect));
    static /* synthetic */ Class class$com$tridium$rdb$sqlserver$BSqlServerDeprecatedDialect;

    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms bRdbms, Connection connection, String string) throws SQLException {
        AutoCloseable autoCloseable;
        String string2 = null;
        try {
            autoCloseable = connection.createStatement();
            ResultSet resultSet = autoCloseable.executeQuery("select db_name() as current_db");
            resultSet.next();
            string2 = resultSet.getString("current_db");
            resultSet.close();
            autoCloseable.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            Log.getLog((String)"rdb").error("Unable to determine Sql Server catalog.");
        }
        autoCloseable = connection.getMetaData().getTables(string2, null, string, new String[]{"TABLE"});
        boolean bl = autoCloseable.next();
        autoCloseable.close();
        return bl;
    }

    public String makeAlterColumnTypeSql(String string, String string2, BSqlType bSqlType, int n) {
        String string3 = "ALTER TABLE " + string + " ALTER COLUMN [" + string2 + "] " + this.getDataType(bSqlType) + "(" + n + ")";
        return string3;
    }

    public String makeDropIndexSql(String string, String string2) {
        return "DROP INDEX " + string + " ON " + string2;
    }

    public String getSqlType(Type type, BFacets bFacets) {
        int n = this.getVarcharSize(bFacets);
        if (type.equals(BString.TYPE)) {
            return this.getStringType(n);
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "REAL";
        }
        if (type.equals(BDouble.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "DATETIME";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "BIT";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return this.getStringType(n);
    }

    private String getStringType(int n) {
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return "NVARCHAR(" + n + ")";
        }
        return "VARCHAR(" + n + ")";
    }

    public long getTimestampAccuracy() {
        return 10L;
    }

    public String getPrimaryKeySql() {
        return "INT IDENTITY PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 128;
    }

    public int getMaxIndexName() {
        return 128;
    }

    public int getMaxColumnName() {
        return 128;
    }

    public int getMaxSequenceName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSequences() {
        return false;
    }

    public boolean allowsUnicode() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

