/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.sqlserver.BConnectionPool;
import com.tridium.rdb.sqlserver.BSqlServerVersion;
import com.tridium.rdb.sqlserver.history.BSqlServerHistoryDeviceExt;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSqlServerDatabase
extends BRdbms {
    public static final Property instanceName = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    public static final Property port = BSqlServerDatabase.newProperty((int)0, (int)1433, null);
    public static final Property histories = BSqlServerDatabase.newProperty((int)0, (BValue)new BSqlServerHistoryDeviceExt(), null);
    public static final Property connectionPool = BSqlServerDatabase.newProperty((int)4, (BValue)new BConnectionPool(), null);
    public static final Property extraConnectionProperties = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    public static final Property version = BSqlServerDatabase.newProperty((int)0x10000000, (BValue)BSqlServerVersion.sqlServer2008, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$sqlserver$BSqlServerDatabase == null ? (class$com$tridium$rdb$sqlserver$BSqlServerDatabase = BSqlServerDatabase.class$("com.tridium.rdb.sqlserver.BSqlServerDatabase")) : class$com$tridium$rdb$sqlserver$BSqlServerDatabase));
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection connection) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "IDENTITY";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String string) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String string) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LEN";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String string, String string2, String string3) {
            if (string != null && string.length() > 0) {
                return string + "." + string2 + ".\"" + string3 + "\"";
            }
            return string2 + ".\"" + string3 + "\"";
        }

        public String getTableIdentifier(String string, String string2) {
            if (string != null && string.length() > 0) {
                return string + "." + string2;
            }
            return string2;
        }

        public String getDropIndex(String string, String string2) {
            return "DROP INDEX " + string + "." + string2;
        }

        public String getDropConstraint(String string, Constraint constraint) {
            return "ALTER TABLE " + string + " " + "DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE PRECISION";
        }

        public String getCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "UNIQUEIDENTIFIER";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "BIT";
        }

        public String getTimestampType() {
            return "DATETIME";
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return BSqlServerDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public boolean supportsDateType() {
            return BSqlServerDatabase.this.getVersion().getOrdinal() >= 2;
        }

        public String getBlobType() {
            return "IMAGE";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NTEXT" : "TEXT";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, String string) {
            throw new UnsupportedOperationException();
        }

        public String getOnDelete(int n) {
            switch (n) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return true;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return -7;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return 1;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return this.supportsDateType() ? 91 : 93;
        }
    };
    static /* synthetic */ Class class$com$tridium$rdb$sqlserver$BSqlServerDatabase;

    public String getInstanceName() {
        return this.getString(instanceName);
    }

    public void setInstanceName(String string) {
        this.setString(instanceName, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BSqlServerHistoryDeviceExt getHistories() {
        return (BSqlServerHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BSqlServerHistoryDeviceExt bSqlServerHistoryDeviceExt) {
        this.set(histories, (BValue)bSqlServerHistoryDeviceExt, null);
    }

    public BConnectionPool getConnectionPool() {
        return (BConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BConnectionPool bConnectionPool) {
        this.set(connectionPool, (BValue)bConnectionPool, null);
    }

    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    public void setExtraConnectionProperties(String string) {
        this.setString(extraConnectionProperties, string, null);
    }

    public BSqlServerVersion getVersion() {
        return (BSqlServerVersion)this.get(version);
    }

    public void setVersion(BSqlServerVersion bSqlServerVersion) {
        this.set(version, (BValue)bSqlServerVersion, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSqlServerDatabase() {
    }

    public BSqlServerDatabase(BOrd bOrd, int n) {
        this.setHostAddress(bOrd);
        this.setPort(n);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbSqlServer");
    }

    public Connection getConnection(String string, BPassword bPassword) throws SQLException {
        BStatus bStatus = this.getStatus();
        if (bStatus.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(string, bPassword.getString());
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

