/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.util.Logger;

public class RequestStream {
    private SharedSocket socket;
    private byte[] buffer;
    private int bufferPtr;
    private byte pktType;
    private int streamId;
    private boolean isClosed = false;
    private int bufferSize = 512;
    private int maxPrecision;

    RequestStream(SharedSocket socket, int streamId) {
        this.streamId = streamId;
        this.socket = socket;
        this.buffer = new byte[this.bufferSize];
        this.bufferPtr = 8;
    }

    void setBufferSize(int size) {
        if (size < this.bufferPtr || size == this.bufferSize) {
            return;
        }
        if (size < 512 || size > 32768) {
            throw new IllegalArgumentException("Invalid buffer size parameter " + size);
        }
        byte[] tmp = new byte[size];
        System.arraycopy(this.buffer, 0, tmp, 0, this.bufferPtr);
        this.buffer = tmp;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    int getMaxPrecision() {
        return this.maxPrecision;
    }

    void setMaxPrecision(int precision) {
        this.maxPrecision = precision;
    }

    int getStreamId() {
        return this.streamId;
    }

    void setPacketType(byte pktType) {
        this.pktType = pktType;
    }

    void write(byte b) throws IOException {
        if (this.bufferPtr == this.buffer.length) {
            this.putPacket(0);
        }
        this.buffer[this.bufferPtr++] = b;
    }

    void write(byte[] b) throws IOException {
        int bytesToWrite = b.length;
        int off = 0;
        while (bytesToWrite > 0) {
            int available = this.buffer.length - this.bufferPtr;
            if (available == 0) {
                this.putPacket(0);
                continue;
            }
            int bc = available > bytesToWrite ? bytesToWrite : available;
            System.arraycopy(b, off, this.buffer, this.bufferPtr, bc);
            off += bc;
            this.bufferPtr += bc;
            bytesToWrite -= bc;
        }
    }

    void write(byte[] b, int off, int len) throws IOException {
        int limit = off + len > b.length ? b.length : off + len;
        int bytesToWrite = limit - off;
        int i = len - bytesToWrite;
        while (bytesToWrite > 0) {
            int available = this.buffer.length - this.bufferPtr;
            if (available == 0) {
                this.putPacket(0);
                continue;
            }
            int bc = available > bytesToWrite ? bytesToWrite : available;
            System.arraycopy(b, off, this.buffer, this.bufferPtr, bc);
            off += bc;
            this.bufferPtr += bc;
            bytesToWrite -= bc;
        }
        while (i > 0) {
            this.write((byte)0);
            --i;
        }
    }

    void write(int i) throws IOException {
        this.write((byte)i);
        this.write((byte)(i >> 8));
        this.write((byte)(i >> 16));
        this.write((byte)(i >> 24));
    }

    void write(short s) throws IOException {
        this.write((byte)s);
        this.write((byte)(s >> 8));
    }

    void write(long l) throws IOException {
        this.write((byte)l);
        this.write((byte)(l >> 8));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 24));
        this.write((byte)(l >> 32));
        this.write((byte)(l >> 40));
        this.write((byte)(l >> 48));
        this.write((byte)(l >> 56));
    }

    void write(double f) throws IOException {
        long l = Double.doubleToLongBits(f);
        this.write((byte)l);
        this.write((byte)(l >> 8));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 24));
        this.write((byte)(l >> 32));
        this.write((byte)(l >> 40));
        this.write((byte)(l >> 48));
        this.write((byte)(l >> 56));
    }

    void write(float f) throws IOException {
        int l = Float.floatToIntBits(f);
        this.write((byte)l);
        this.write((byte)(l >> 8));
        this.write((byte)(l >> 16));
        this.write((byte)(l >> 24));
    }

    void write(String s) throws IOException {
        if (this.socket.getTdsVersion() >= 3) {
            int len = s.length();
            int i = 0;
            while (i < len) {
                char c = s.charAt(i);
                if (this.bufferPtr == this.buffer.length) {
                    this.putPacket(0);
                }
                this.buffer[this.bufferPtr++] = (byte)c;
                if (this.bufferPtr == this.buffer.length) {
                    this.putPacket(0);
                }
                this.buffer[this.bufferPtr++] = (byte)(c >> 8);
                ++i;
            }
        } else {
            this.writeAscii(s);
        }
    }

    void write(char[] s, int off, int len) throws IOException {
        int i = off;
        int limit = off + len > s.length ? s.length : off + len;
        while (i < limit) {
            char c = s[i];
            if (this.bufferPtr == this.buffer.length) {
                this.putPacket(0);
            }
            this.buffer[this.bufferPtr++] = (byte)c;
            if (this.bufferPtr == this.buffer.length) {
                this.putPacket(0);
            }
            this.buffer[this.bufferPtr++] = (byte)(c >> 8);
            ++i;
        }
    }

    void writeAscii(String s) throws IOException {
        String charsetName = this.socket.getCharset();
        if (charsetName != null) {
            try {
                this.write(s.getBytes(charsetName));
            }
            catch (UnsupportedEncodingException e) {
                this.write(s.getBytes());
            }
        } else {
            this.write(s.getBytes());
        }
    }

    void writeStreamBytes(InputStream in, int length) throws IOException {
        byte[] buffer = new byte[1024];
        while (length > 0) {
            int res = in.read(buffer);
            if (res < 0) {
                throw new IOException("Data in stream less than specified by length");
            }
            this.write(buffer, 0, res);
            length -= res;
        }
        if (length < 0 || in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
    }

    void writeReaderChars(Reader in, int length) throws IOException {
        char[] cbuffer = new char[512];
        byte[] bbuffer = new byte[1024];
        while (length > 0) {
            int res = in.read(cbuffer);
            if (res < 0) {
                throw new IOException("Data in stream less than specified by length");
            }
            int i = 0;
            int j = -1;
            while (i < res) {
                bbuffer[++j] = (byte)cbuffer[i];
                bbuffer[++j] = (byte)(cbuffer[i] >> 8);
                ++i;
            }
            this.write(bbuffer, 0, res * 2);
            length -= res;
        }
        if (length < 0 || in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
    }

    void writeReaderBytes(Reader in, int length) throws IOException {
        char[] buffer = new char[1024];
        int i = 0;
        while (i < length) {
            int result = in.read(buffer);
            if (result == -1) {
                throw new IOException("Data in stream less than specified by length");
            }
            if (i + result > length) {
                throw new IOException("More data in stream than specified by length");
            }
            this.write(Support.encodeString(this.socket.getCharset(), new String(buffer, 0, result)));
            i += result;
        }
    }

    void write(BigDecimal value) throws IOException {
        byte maxLen;
        byte prec = (byte)this.maxPrecision;
        byte by = maxLen = prec <= 28 ? (byte)13 : 17;
        if (value == null) {
            this.write((byte)0);
        } else {
            byte signum = value.signum() < 0 ? (byte)0 : 1;
            BigInteger bi = value.unscaledValue();
            byte[] mantisse = bi.abs().toByteArray();
            byte len = (byte)(mantisse.length + 1);
            if (len > maxLen) {
                throw new IOException("BigDecimal to big to send");
            }
            if (this.socket.getServerType() == 2) {
                this.write(len);
                this.write(signum == 0 ? (byte)1 : 0);
                int i = 0;
                while (i < mantisse.length) {
                    this.write(mantisse[i]);
                    ++i;
                }
            } else {
                this.write(len);
                this.write(signum);
                int i = mantisse.length - 1;
                while (i >= 0) {
                    this.write(mantisse[i]);
                    --i;
                }
            }
        }
    }

    void flush() throws IOException {
        this.putPacket(1);
    }

    void close() throws IOException {
        this.isClosed = true;
    }

    int getTdsVersion() {
        return this.socket.getTdsVersion();
    }

    int getServerType() {
        return this.socket.getServerType();
    }

    private void putPacket(int last) throws IOException {
        if (this.isClosed) {
            throw new IOException("RequestStream is closed");
        }
        this.buffer[0] = this.pktType;
        this.buffer[1] = (byte)last;
        this.buffer[2] = (byte)(this.bufferPtr >> 8);
        this.buffer[3] = (byte)this.bufferPtr;
        this.buffer[4] = 0;
        this.buffer[5] = 0;
        this.buffer[6] = this.socket.getTdsVersion() >= 3 ? (byte)1 : 0;
        this.buffer[7] = 0;
        if (Logger.isActive()) {
            Logger.logPacket(this.streamId, false, this.buffer);
        }
        this.buffer = this.socket.sendNetPacket(this.streamId, this.buffer);
        this.bufferPtr = 8;
    }
}

