/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.xml;

import com.tridium.eas.xml.XmlBlob;
import com.tridium.eas.xml.XmlBoolean;
import com.tridium.eas.xml.XmlDouble;
import com.tridium.eas.xml.XmlInteger;
import com.tridium.eas.xml.XmlLong;
import com.tridium.eas.xml.XmlString;
import com.tridium.eas.xml.XmlSupport;
import java.io.IOException;
import java.util.Vector;

public class XmlMessage
implements XmlSupport {
    public static String TYPE = "EasMessage";
    public static final XmlSupport[] noChildren = new XmlSupport[0];
    public XmlSupport[] children = noChildren;
    public int count;
    public String name;

    public XmlMessage(String string) {
        this.name = string;
    }

    public XmlMessage() {
    }

    public String getType() {
        return TYPE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (this.count >= this.children.length) {
            if (this.count == 0) {
                this.children = new XmlSupport[8];
            } else {
                XmlSupport[] xmlSupportArray = new XmlSupport[this.count * 2];
                System.arraycopy(this.children, 0, xmlSupportArray, 0, this.count);
                this.children = xmlSupportArray;
            }
        }
        this.children[this.count++] = xmlSupport;
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[this.count];
        System.arraycopy(this.children, 0, xmlSupportArray, 0, this.count);
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  type: " + this.getType());
        stringBuffer.append("\n  name: " + this.getName());
        stringBuffer.append("\n  elements: ");
        XmlSupport[] xmlSupportArray = this.getChildObjects();
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                if (xmlSupportArray[i] == null) continue;
                stringBuffer.append(xmlSupportArray[i].toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public final XmlSupport get(String string) throws IOException {
        for (int i = 0; i < this.count; ++i) {
            if (!string.equals(this.children[i].getName())) continue;
            return this.children[i];
        }
        throw new IOException("Missing key \"" + string + "\"");
    }

    public final XmlSupport[] list(String string) {
        Vector<XmlSupport> vector = new Vector<XmlSupport>();
        for (int i = 0; i < this.count; ++i) {
            if (!string.equals(this.children[i].getName())) continue;
            vector.addElement(this.children[i]);
        }
        Object[] objectArray = new XmlSupport[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final XmlSupport getOptional(String string) {
        for (int i = 0; i < this.count; ++i) {
            if (!string.equals(this.children[i].getName())) continue;
            return this.children[i];
        }
        return null;
    }

    public final XmlMessage getMessage(String string) throws IOException {
        return (XmlMessage)this.get(string);
    }

    public final boolean getBoolean(String string) throws IOException {
        return ((XmlBoolean)this.get((String)string)).value;
    }

    public final int getInt(String string) throws IOException {
        return ((XmlInteger)this.get((String)string)).value;
    }

    public final long getLong(String string) throws IOException {
        return ((XmlLong)this.get((String)string)).value;
    }

    public final double getDouble(String string) throws IOException {
        return ((XmlDouble)this.get((String)string)).value;
    }

    public final String getString(String string) throws IOException {
        return ((XmlString)this.get((String)string)).value;
    }

    public final long getTime(String string) throws IOException {
        return ((XmlLong)this.get((String)string)).value;
    }

    public final byte[] getBlob(String string) throws IOException {
        return ((XmlBlob)this.get((String)string)).data;
    }

    public final boolean getBoolean(String string, boolean bl) {
        XmlBoolean xmlBoolean = (XmlBoolean)this.getOptional(string);
        if (xmlBoolean == null) {
            return bl;
        }
        return xmlBoolean.value;
    }

    public final int getInt(String string, int n) {
        XmlInteger xmlInteger = (XmlInteger)this.getOptional(string);
        if (xmlInteger == null) {
            return n;
        }
        return xmlInteger.value;
    }

    public final long getLong(String string, long l) {
        XmlLong xmlLong = (XmlLong)this.getOptional(string);
        if (xmlLong == null) {
            return l;
        }
        return xmlLong.value;
    }

    public final double getDouble(String string, double d) {
        XmlDouble xmlDouble = (XmlDouble)this.getOptional(string);
        if (xmlDouble == null) {
            return d;
        }
        return xmlDouble.value;
    }

    public final String getString(String string, String string2) {
        XmlString xmlString = (XmlString)this.getOptional(string);
        if (xmlString == null) {
            return string2;
        }
        return xmlString.value;
    }

    public final long getTime(String string, long l) {
        XmlLong xmlLong = (XmlLong)this.getOptional(string);
        if (xmlLong == null) {
            return l;
        }
        return xmlLong.value;
    }

    public final byte[] getBlob(String string, byte[] byArray) {
        XmlBlob xmlBlob = (XmlBlob)this.getOptional(string);
        if (xmlBlob == null) {
            return byArray;
        }
        return xmlBlob.data;
    }

    public final void add(XmlSupport xmlSupport) {
        this.addChildObject(xmlSupport);
    }

    public final void add(String string, boolean bl) {
        this.add(new XmlBoolean(string, bl));
    }

    public final void add(String string, int n) {
        this.add(new XmlInteger(string, n));
    }

    public final void add(String string, double d) {
        this.add(new XmlDouble(string, d));
    }

    public final void add(String string, String string2) {
        this.add(new XmlString(string, string2));
    }

    public final void add(String string, long l) {
        this.add(new XmlLong(string, l));
    }

    public final void add(String string, byte[] byArray) {
        this.add(new XmlBlob(string, byArray));
    }

    public final void add(String string, byte[] byArray, int n) {
        this.add(new XmlBlob(string, byArray, n));
    }

    public final XmlMessage add(String string, XmlMessage xmlMessage) {
        xmlMessage.name = string;
        this.add(xmlMessage);
        return xmlMessage;
    }
}

