/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.xml;

import com.tridium.eas.xml.XmlSupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.xml.XWriter;

public class XmlEncoder
extends XWriter {
    protected int indent = 0;

    public XmlEncoder(File file) throws IOException {
        super(file);
    }

    public XmlEncoder(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public void encodeDocument(XmlSupport xmlSupport) throws IOException {
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<easGraph version=\"3.0\">\n");
        this.encode(xmlSupport);
        this.w("</easGraph>\n");
        this.flush();
    }

    public void encode(XmlSupport xmlSupport) throws IOException {
        this.encode(XmlEncoder.encodeXmlString(xmlSupport.getName()), xmlSupport);
    }

    public void encode(String string, XmlSupport xmlSupport) throws IOException {
        this.w("<p");
        if (string != null) {
            this.wname(string);
        }
        this.wtype(xmlSupport);
        this.encodeValue(xmlSupport);
    }

    private void encodeSlot(XmlSupport xmlSupport) throws IOException {
        this.indent(this.indent);
        this.w("<p");
        this.wname(XmlEncoder.encodeXmlString(xmlSupport.getName()));
        this.wtype(xmlSupport);
        this.encodeValue(xmlSupport);
    }

    private void encodeValue(XmlSupport xmlSupport) throws IOException {
        XmlSupport[] xmlSupportArray = xmlSupport.getChildObjects();
        if (xmlSupportArray == null || xmlSupportArray.length <= 0) {
            this.wvalue(xmlSupport).w("/>\n");
        } else {
            this.wvalue(xmlSupport).w(">\n");
            ++this.indent;
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                this.encodeSlot(xmlSupportArray[i]);
            }
            --this.indent;
            this.indent(this.indent);
            this.w("</p>\n");
        }
    }

    private XmlEncoder wname(String string) throws IOException {
        this.w(" n=\"").w((Object)string).w('\"');
        return this;
    }

    private XmlEncoder wtype(XmlSupport xmlSupport) throws IOException {
        this.w(" t=\"").w((Object)xmlSupport.getType()).w('\"');
        return this;
    }

    private XmlEncoder wvalue(XmlSupport xmlSupport) throws IOException {
        String string = xmlSupport.encodeToString();
        if (string != null) {
            this.w(" v=\"").safe(string).w('\"');
        }
        return this;
    }

    public static String encodeXmlString(String string) {
        if (string == null || string.length() <= 0) {
            return "%00";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        char[] cArray = string.toCharArray();
        block10: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '%': {
                    stringBuffer.append("%25");
                    continue block10;
                }
                case ':': {
                    stringBuffer.append("%3A");
                    continue block10;
                }
                case ';': {
                    stringBuffer.append("%3B");
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block10;
                }
                case '=': {
                    stringBuffer.append("%3D");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block10;
                }
                case '?': {
                    stringBuffer.append("%3F");
                    continue block10;
                }
                case '@': {
                    stringBuffer.append("%40");
                    continue block10;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeXmlString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%') {
                int n = i++;
                int n2 = 0;
                try {
                    n2 += XmlEncoder.fromHex(cArray[i++]) * 16;
                    if ((n2 += XmlEncoder.fromHex(cArray[i])) == 0) {
                        stringBuffer.append("");
                        continue;
                    }
                    stringBuffer.append((char)n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    i = n;
                    stringBuffer.append(cArray[i]);
                }
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private static int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static String encodeUrl(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case ' ': {
                    stringBuffer.append("%20");
                    continue block6;
                }
                case '%': {
                    stringBuffer.append("%25");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("%26");
                    continue block6;
                }
                case '=': {
                    stringBuffer.append("%3D");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }
}

