/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.web;

import com.tridium.eas.BEasReport;
import com.tridium.eas.BEasService;
import com.tridium.eas.Upload;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.enums.BHomePageSelectEnum;
import com.tridium.eas.util.MergedLexicon;
import com.tridium.eas.web.EasCostHandler;
import com.tridium.eas.web.EasPartitionHandler;
import com.tridium.eas.web.ServerTagData;
import com.tridium.eas.web.Template;
import com.tridium.eas.web.TemplateCallback;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlMessage;
import com.tridium.platform.license.BrandProps;
import com.tridium.web.WebUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.io.HtmlWriter;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.util.SortUtil;
import javax.baja.web.WebOp;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class EasServlet
implements TemplateCallback {
    private static final String JRE_URI = "/eas/jre";
    private static final String PLUGIN_DOWNLOAD_URI = "/eas/pluginDownload";
    private static final String VERSION_URI = "/eas/version";
    private static final String REPORTS_URI = "/eas/reports";
    private static final String SAVED_REPORTS_URI = "/eas/savedReports";
    private static final String REPORT_CMD_URI = "/eas/reportCommand";
    private static final String CODE_URI = "/eas/code";
    private static final String DBCONFIG_URI = "/eas/dbconfig";
    private static final String COST_URI = "/eas/cost";
    private static final String PARTITION_URI = "/eas/partition";
    private static final String DIAGNOSTICS_URI = "/eas/diagnostics";
    private static final String REPORT_ADMIN_URI = "/eas/reportAdmin";
    private static final String LOG_URI = "/eas/log";
    private static final String LOGIN_URI = "/eas/login";
    private static final String DOWNLOAD_URI = "/eas/download";
    private static final String HELP_URI = "/eas/help";
    private static final String HELPFILE_URI = "/eas/helpFile";
    private static final String SUMMARY_URI = "/eas/summary";
    private static final String DX_URI = "/eas/dx";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE = "module://eas/com/tridium/eas/web/templateSemiCustom.html";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE_V2 = "module://eas/com/tridium/eas/web/templateSemiCustom.html";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE_E2 = "module://eas/com/tridium/eas/web/templateSemiCustomE2.html";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE_E2_V2 = "module://eas/com/tridium/eas/web/templateSemiCustomE2.html";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE_COST = "module://eas/com/tridium/eas/web/templateSemiCustomCost.html";
    private static final String SEMI_CUSTOM_MAIN_TEMPLATE_COST_V2 = "module://eas/com/tridium/eas/web/templateSemiCustomCost.html";
    private static final String SUMMARY = "module://eas/com/tridium/eas/web/summary.html";
    private static final String UNDER_CONSTRUCTION = "module://eas/com/tridium/eas/web/construction.html";
    private static final String DOWNLOAD_TEMPLATE = "module://eas/com/tridium/eas/web/pluginDownload.html";
    private BEasService eas;
    private EasCostHandler costHandler;
    private EasPartitionHandler partitionHandler;
    private boolean ready = false;
    private Properties helpMap;
    private Properties brandMap;
    private EasSession easSession;
    private String easBrandString = null;
    public static final Log log = Log.getLog((String)"eas");
    static /* synthetic */ Class class$com$tridium$eas$BEasService;

    public EasServlet(BEasService bEasService) {
        this.eas = bEasService;
    }

    public EasServlet(BEasService bEasService, EasSession easSession) {
        this(bEasService);
        this.easSession = easSession;
        try {
            this.costHandler = new EasCostHandler();
            this.costHandler.setEasServlet(this);
            this.costHandler.setEasService(bEasService);
            this.costHandler.setEasSession(easSession);
            this.partitionHandler = new EasPartitionHandler();
            this.partitionHandler.setEasServlet(this);
            this.partitionHandler.setEasService(bEasService);
            this.partitionHandler.setEasSession(easSession);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init() {
        this.loadHelpMap();
        this.loadBrandMap();
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public boolean isReady() {
        return this.ready;
    }

    private void loadHelpMap() {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("/com/tridium/eas/help.properties");
        this.helpMap = new Properties();
        if (inputStream != null) {
            try {
                this.helpMap.load(inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadBrandMap() {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("/com/tridium/eas/brand.properties");
        this.brandMap = new Properties();
        if (inputStream != null) {
            try {
                this.brandMap.load(inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String readBrandProperty(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("eas.").append(string);
        String string2 = BrandProps.getLocalInstance().get(stringBuffer.toString(), null);
        if (string2 == null) {
            string2 = this.brandMap.getProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getEasBrand() {
        if (this.easBrandString == null) {
            EasServlet easServlet = this;
            synchronized (easServlet) {
                if (this.easBrandString == null) {
                    Feature feature = Sys.getLicenseManager().getFeature("tridium", "eas");
                    this.easBrandString = feature.get("brand", "vykon");
                }
            }
        }
        return this.easBrandString;
    }

    String getBrandPropertyKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getEasBrand()).append(".").append(string);
        return stringBuffer.toString();
    }

    public BUser getUser(HttpServletRequest httpServletRequest) {
        return BEasService.getUser(httpServletRequest.getRemoteUser());
    }

    private void goAway(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>\n");
        printWriter.print("<body>\n");
        printWriter.print(lexicon.getText("serviceInitializing") + "\n");
        printWriter.print("</body>\n");
        printWriter.print("</html>\n");
        printWriter.flush();
    }

    public static String getPostField(String string, Hashtable hashtable) {
        if (string == null || hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        String[] stringArray = (String[])v;
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public static String getRequestURINoPrefix(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServletPath();
        if (string == null || string.length() == 1) {
            String string2 = httpServletRequest.getRequestURI();
            if (string2 != null && string2.length() > 1 && string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        String string3 = httpServletRequest.getRequestURI();
        if (string3.startsWith(string)) {
            if (string3.length() == string.length()) {
                return "/";
            }
            String string4 = string3.substring(string.length());
            if (string4.length() > 1 && string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            return string4;
        }
        return null;
    }

    public void doGet(WebOp webOp) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        MergedLexicon mergedLexicon = MergedLexicon.make(Lexicon.make((String)"eas", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)), Lexicon.make((String)"baja", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)));
        try {
            String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
            if (!this.ready) {
                this.goAway(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.startsWith(JRE_URI)) {
                this.getJre(httpServletRequest, httpServletResponse);
            } else if (string.startsWith(PLUGIN_DOWNLOAD_URI)) {
                this.getPluginDownloadPage(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.startsWith(REPORTS_URI)) {
                this.getReport(webOp, mergedLexicon);
            } else if (string.startsWith(DBCONFIG_URI)) {
                this.getDbConfig(webOp, mergedLexicon);
            } else if (string.startsWith(REPORT_ADMIN_URI)) {
                this.getReportAdmin(webOp, mergedLexicon);
            } else if (string.startsWith(HELPFILE_URI)) {
                this.getHelpFile(string, httpServletResponse);
            } else if (string.startsWith(HELP_URI)) {
                this.getHelp(string, httpServletRequest, httpServletResponse);
            } else if (string.startsWith(COST_URI) && this.costHandler != null) {
                this.costHandler.doGet(webOp, mergedLexicon);
            } else if (string.startsWith(PARTITION_URI) && this.partitionHandler != null) {
                this.partitionHandler.doGet(webOp, mergedLexicon);
            } else if (string.length() == 0 || string.equals("/") || string.equalsIgnoreCase("/eas")) {
                this.getMain(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.startsWith(CODE_URI)) {
                String string2 = string.substring(9);
                if (string2.length() < 2) {
                    httpServletResponse.sendError(400);
                }
                this.sendFile(string2, httpServletRequest, httpServletResponse, true);
            } else if (string.startsWith(LOGIN_URI)) {
                this.getUserInfo(httpServletRequest, httpServletResponse);
            } else if (string.startsWith(REPORT_CMD_URI)) {
                this.doReportCommand(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.startsWith(LOG_URI)) {
                this.getLogInfo(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.equalsIgnoreCase(VERSION_URI)) {
                this.getVersion(httpServletResponse);
            } else if (string.equalsIgnoreCase(SAVED_REPORTS_URI)) {
                this.getSavedReports(httpServletRequest, httpServletResponse);
            } else if (string.startsWith(DOWNLOAD_URI)) {
                this.getDownload(httpServletRequest, httpServletResponse);
            } else if (string.startsWith(DIAGNOSTICS_URI)) {
                this.getDiagnostics(httpServletRequest, httpServletResponse);
            } else if (string.startsWith(SUMMARY_URI)) {
                this.getSummary(httpServletRequest, httpServletResponse, mergedLexicon);
            } else if (string.startsWith(DX_URI)) {
                DataInputStream dataInputStream = new DataInputStream((InputStream)webOp.getRequest().getInputStream());
                XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
                XmlMessage xmlMessage = (XmlMessage)xmlDecoder.decodeDocument();
                XmlMessage xmlMessage2 = this.eas.getEasServerSession().handleAction(BEasService.getUser(webOp.getRequest().getRemoteUser()).getUsername(), xmlMessage);
                if (xmlMessage2 != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XmlEncoder xmlEncoder = new XmlEncoder(byteArrayOutputStream);
                    xmlEncoder.encodeDocument(xmlMessage2);
                    httpServletResponse.setContentLength(byteArrayOutputStream.size());
                    DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)webOp.getResponse().getOutputStream());
                    byteArrayOutputStream.writeTo(dataOutputStream);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    private void getMain(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        BUser bUser = this.getUser(httpServletRequest);
        if (bUser == null) {
            httpServletResponse.sendError(403);
            return;
        }
        BOrd bOrd = null;
        boolean bl = false;
        switch (this.eas.getHomePage().getOrdinal()) {
            case 2: {
                bOrd = this.eas.getCustomHomePage();
                bl = true;
                break;
            }
            default: {
                bOrd = this.eas.isEasCostLicensed() && !this.eas.isEasE2Licensed() ? BOrd.make((String)"module://eas/com/tridium/eas/web/templateSemiCustomCost.html") : (this.eas.isEasE2Licensed() && !this.eas.isEasCostLicensed() ? BOrd.make((String)"module://eas/com/tridium/eas/web/templateSemiCustomE2.html") : BOrd.make((String)"module://eas/com/tridium/eas/web/templateSemiCustom.html"));
            }
        }
        if (bOrd == null) {
            httpServletResponse.sendError(404);
            return;
        }
        BIFile bIFile = (BIFile)bOrd.resolve().get();
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(bIFile.getMimeType());
        httpServletResponse.setDateHeader("Expires", System.currentTimeMillis());
        InputStream inputStream = bIFile.getInputStream();
        HtmlWriter htmlWriter = new HtmlWriter((Writer)httpServletResponse.getWriter());
        if (bl) {
            this.writeFullCustomAppend(htmlWriter);
        }
        Template template = new Template(htmlWriter, new BufferedReader(Template.makeReader(inputStream)), this);
        EasTemplateArg easTemplateArg = new EasTemplateArg(bUser, lexicon);
        template.generate(easTemplateArg);
        inputStream.close();
    }

    private void getHelpFile(String string, HttpServletResponse httpServletResponse) throws IOException {
        String string2 = string.substring(HELPFILE_URI.length() + 1);
        String string3 = this.helpMap.getProperty(string2);
        if (string3 != null) {
            httpServletResponse.setContentType("text/plain");
            byte[] byArray = string3.getBytes();
            httpServletResponse.setContentLength(byArray.length);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            return;
        }
        httpServletResponse.sendError(404);
    }

    private void getHelp(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string2 = string.substring(5);
        this.sendFile(string2, httpServletRequest, httpServletResponse, true);
    }

    private void getPluginDownloadPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        BOrd bOrd = BOrd.make((String)DOWNLOAD_TEMPLATE);
        BIFile bIFile = (BIFile)bOrd.resolve().get();
        if (bIFile == null) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(bIFile.getMimeType());
        InputStream inputStream = bIFile.getInputStream();
        Template template = new Template(new HtmlWriter((Writer)httpServletResponse.getWriter()), new BufferedReader(new InputStreamReader(inputStream)), this);
        EasTemplateArg easTemplateArg = new EasTemplateArg(null, lexicon);
        template.generate(easTemplateArg);
        inputStream.close();
    }

    public void insert(HtmlWriter htmlWriter, String string, Object object) throws IOException {
        EasTemplateArg easTemplateArg = (EasTemplateArg)object;
        ServerTagData serverTagData = new ServerTagData(string);
        String string2 = serverTagData.getTag();
        if (string2.equals("reportName")) {
            this.writeReportName(htmlWriter, serverTagData.getParameter("key"), (Lexicon)easTemplateArg.Arg2);
        } else if (string2.equals("templateAnchor")) {
            this.writeTemplateAnchor(htmlWriter, serverTagData.getParameter("key"));
        } else if (string2.equals("savedReports")) {
            this.writeSavedReports(htmlWriter, serverTagData.getParameter("key"), easTemplateArg);
        } else if (string2.equals("savedReportsArrowStyle")) {
            this.writeSavedReportsArrowStyle(htmlWriter, serverTagData.getParameter("key"), easTemplateArg);
        } else if (string2.equals("noReport")) {
            htmlWriter.print(object);
        } else if (string2.equals("homeLogo")) {
            this.writeHomeLogo(htmlWriter);
        } else if (string2.equals("homeLogoTable")) {
            this.writeHomeLogoTable(htmlWriter);
        } else if (string2.equals("appLogo")) {
            this.writeAppLogo(htmlWriter);
        } else if (string2.equals("appLogoTable")) {
            this.writeAppLogoTable(htmlWriter);
        } else if (string2.equals("summary")) {
            this.writeSummary(htmlWriter, (Lexicon)easTemplateArg.Arg2);
        } else if (string2.equals("localize")) {
            this.writeLocalizedName(htmlWriter, serverTagData.getParameter("key"), (Lexicon)easTemplateArg.Arg2);
        } else if (string2.equals("insertCustomPage")) {
            this.writeCustomPage(htmlWriter, easTemplateArg);
        } else if (string2.equals("helpAnchor")) {
            this.writeHelpAnchor(htmlWriter, serverTagData.getParameter("key"));
        } else if (string2.equals("userName")) {
            this.writeUserName(htmlWriter, easTemplateArg);
        } else if (string2.equals("brandLogo")) {
            this.writeBrandLogo(htmlWriter, serverTagData);
        } else if (string2.equals("shortBrandName") || string2.equals("longBrandName")) {
            this.writeBrandName(htmlWriter, string2);
        }
    }

    private void writeReportName(HtmlWriter htmlWriter, String string, Lexicon lexicon) {
        htmlWriter.print(lexicon.getText(string));
    }

    private void writeTemplateAnchor(HtmlWriter htmlWriter, String string) {
        BEasReport bEasReport = this.eas.getReports().getReportByKey(string);
        htmlWriter.print("<a");
        if (!(bEasReport != null && (this.eas.isDemo() || (bEasReport.getEasReportType() == 0 && this.eas.isEasE2Licensed() || bEasReport.getEasReportType() == 1 && this.eas.isEasCostLicensed() || bEasReport.getEasReportType() == 2 && this.eas.isEasLicensed()) && this.eas.isReportLicensed(string)))) {
            htmlWriter.print(">");
        } else {
            htmlWriter.print(" href=\"/eas" + bEasReport.getReportUri());
            htmlWriter.print("\">");
        }
    }

    private void writeHelpAnchor(HtmlWriter htmlWriter, String string) {
        String string2 = this.helpMap.getProperty(string);
        if (string2 == null) {
            return;
        }
        htmlWriter.print("<a href=\"/eas/help");
        htmlWriter.print(string2);
        htmlWriter.print("\">");
    }

    private void writeUserName(HtmlWriter htmlWriter, EasTemplateArg easTemplateArg) {
        try {
            BUser bUser = (BUser)easTemplateArg.Arg1;
            String string = bUser.getUsername();
            if (string != null) {
                htmlWriter.print(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeBrandName(HtmlWriter htmlWriter, String string) {
        String string2 = this.readBrandProperty(this.getBrandPropertyKey(string));
        if (string2 == null) {
            string2 = this.readBrandProperty("vykon." + string);
        }
        if (string2 == null) {
            string2 = "Vykon Energy Suite";
        }
        htmlWriter.print(string2);
    }

    private void writeSavedReports(HtmlWriter htmlWriter, String string, EasTemplateArg easTemplateArg) {
        Hashtable hashtable = null;
        BUser bUser = (BUser)easTemplateArg.Arg1;
        Lexicon lexicon = (Lexicon)easTemplateArg.Arg2;
        hashtable = string == null ? this.eas.getReports(null, bUser, false, true) : this.eas.getReports(string, bUser, true, true);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string2);
            BEasReport bEasReport = this.eas.getReports().getReportByKey(string2);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.elementAt(i);
                int n2 = string3.lastIndexOf(46);
                if (n2 <= 0) {
                    n2 = string3.length();
                }
                String string4 = string3.substring(0, n2);
                String string5 = string4.replace('_', ' ');
                htmlWriter.println("    <tr>");
                htmlWriter.println("      <td width=\"40\" align=\"right\" valign=\"top\" class=\"white9\">&#149;&nbsp;</td>");
                htmlWriter.print("      <td width=\"360\" align=\"left\" valign=\"top\" class=\"white9\"><a");
                if (!(bEasReport != null && (this.eas.isDemo() || (bEasReport.getEasReportType() == 0 && this.eas.isEasE2Licensed() || bEasReport.getEasReportType() == 1 && this.eas.isEasCostLicensed() || bEasReport.getEasReportType() == 2 && this.eas.isEasLicensed()) && this.eas.isReportLicensed(string2)))) {
                    htmlWriter.print(">");
                } else {
                    htmlWriter.print(" href=\"/eas" + bEasReport.getReportUri());
                    htmlWriter.print("?reportName=");
                    htmlWriter.print(string4);
                    htmlWriter.print("\" class=\"white9\">");
                }
                htmlWriter.print(string5);
                htmlWriter.println("</a></td>");
                htmlWriter.println("    </tr>");
            }
        }
    }

    private void writeSavedReportsArrowStyle(HtmlWriter htmlWriter, String string, EasTemplateArg easTemplateArg) {
        Hashtable hashtable = null;
        BUser bUser = (BUser)easTemplateArg.Arg1;
        Lexicon lexicon = (Lexicon)easTemplateArg.Arg2;
        hashtable = string == null ? this.eas.getReports(null, bUser, false, true) : this.eas.getReports(string, bUser, true, true);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string2);
            BEasReport bEasReport = this.eas.getReports().getReportByKey(string2);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.elementAt(i);
                int n2 = string3.lastIndexOf(46);
                if (n2 <= 0) {
                    n2 = string3.length();
                }
                String string4 = string3.substring(0, n2);
                String string5 = string4.replace('_', ' ');
                htmlWriter.print("            <img src=\"/eas/code/eas/com/tridium/eas/web/images/arrow.png\" align=\"middle\">&nbsp;<a");
                if (!(bEasReport != null && (this.eas.isDemo() || (bEasReport.getEasReportType() == 0 && this.eas.isEasE2Licensed() || bEasReport.getEasReportType() == 1 && this.eas.isEasCostLicensed() || bEasReport.getEasReportType() == 2 && this.eas.isEasLicensed()) && this.eas.isReportLicensed(string2)))) {
                    htmlWriter.print(">");
                } else {
                    htmlWriter.print(" href=\"/eas" + bEasReport.getReportUri());
                    htmlWriter.print("?reportName=");
                    htmlWriter.print(string4);
                    htmlWriter.print("\">");
                }
                htmlWriter.print(string5);
                htmlWriter.println("</a><br>");
            }
        }
    }

    private String getBrandLogoPath() {
        String string = this.readBrandProperty(this.getBrandPropertyKey("logo"));
        if (string == null) {
            string = "module://eas/com/tridium/eas/brand/vykon/logo.png";
        }
        return "/eas/code/" + string;
    }

    private void writeBrandLogo(HtmlWriter htmlWriter, ServerTagData serverTagData) throws IOException {
        String string = this.getBrandLogoPath();
        if (string != null) {
            Enumeration enumeration;
            htmlWriter.print("<img src=\"");
            htmlWriter.print(string);
            htmlWriter.print("\"");
            if (serverTagData != null && (enumeration = serverTagData.getParameterNames()) != null) {
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    htmlWriter.print(" " + string2 + "=" + serverTagData.getParameter(string2));
                }
            }
            htmlWriter.print(">");
        }
    }

    private void writeHomeLogo(HtmlWriter htmlWriter) throws IOException {
        String string = this.getBrandLogoPath();
        if (string != null) {
            htmlWriter.print("<img vspace=\"5\" align=\"left\" src=\"");
            htmlWriter.print(string);
            htmlWriter.print("\" border=\"0\">");
        }
    }

    private void writeHomeLogoTable(HtmlWriter htmlWriter) throws IOException {
        String string = this.getBrandLogoPath();
        if (string != null) {
            htmlWriter.print("            <td align=\"left\"><img src=\"");
            htmlWriter.print(string);
            htmlWriter.print("\"</td>");
        }
    }

    private void writeAppLogo(HtmlWriter htmlWriter) {
        String string = this.getEasBrand();
        if (string == null || !string.equalsIgnoreCase("vykon") && !string.equalsIgnoreCase("tridium")) {
            String string2 = "<img align=\"right\" vspace=\"5\" src=\"/eas/code/eas/com/tridium/eas/brand/NiagaraEnergyAppSm.gif\" border=\"0\">";
            htmlWriter.print(string2);
        }
    }

    private void writeAppLogoTable(HtmlWriter htmlWriter) {
        String string = this.getEasBrand();
        if (string == null || !string.equalsIgnoreCase("vykon") && !string.equalsIgnoreCase("tridium")) {
            htmlWriter.print("        <p>\n");
            htmlWriter.print("        <table width=\"95%\" align=\"center\">");
            htmlWriter.print("          <tr>");
            String string2 = "            <td align=\"center\"><img src=\"/eas/code/eas/com/tridium/eas/brand/NiagaraEnergyAppSm.gif\"></td>";
            htmlWriter.print(string2);
            htmlWriter.print("          </tr>");
            htmlWriter.print("        </table>");
        }
    }

    private void writeCustomPage(HtmlWriter htmlWriter, EasTemplateArg easTemplateArg) throws IOException {
        if (this.eas.getHomePage().equals((Object)BHomePageSelectEnum.useDefault)) {
            return;
        }
        BOrd bOrd = this.eas.getCustomHomePage();
        if (bOrd.isNull()) {
            return;
        }
        BIFile bIFile = null;
        try {
            bIFile = (BIFile)bOrd.get();
        }
        catch (Exception exception) {
            BEasService.log.error("Problem resolving custom home page file: " + bOrd, (Throwable)exception);
        }
        if (bIFile == null) {
            Lexicon lexicon = (Lexicon)easTemplateArg.Arg2;
            htmlWriter.print("<br><br><a style=\"color: red\">" + lexicon.getText("invalidCustomUrl") + " " + bOrd + "</a>");
            return;
        }
        InputStream inputStream = bIFile.getInputStream();
        Template template = new Template(htmlWriter, new BufferedReader(new InputStreamReader(inputStream)), this);
        template.generate(easTemplateArg);
        inputStream.close();
    }

    private void writeFullCustomAppend(HtmlWriter htmlWriter) throws IOException {
        String string;
        String string2 = this.getEasBrand();
        if (string2 != null && (string2.equalsIgnoreCase("vykon") || string2.equalsIgnoreCase("tridium")) && (string = this.getBrandLogoPath()) != null) {
            htmlWriter.print("<html><body>");
            htmlWriter.print("  <table width=\"95%\" align=\"center\">");
            htmlWriter.print("    <tr>");
            htmlWriter.print("      <td align=\"left\"><img src=\"" + string + "\"></td>");
            htmlWriter.print("      <td align=\"right\"><img src=\"/eas/code/eas/com/tridium/eas/web/images/powerLogo.png\"></td>");
            htmlWriter.print("    </tr>");
            htmlWriter.print("  </table>");
            htmlWriter.print("</body></html>");
        }
    }

    private void getDefault(HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>\n<body>\n");
        printWriter.print("EAS - Energy Suite");
        printWriter.print("\n</body>\n</html>\n");
        printWriter.flush();
    }

    private void getVersion(HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>\n<body>\n");
        printWriter.print("EAS Version 3.0");
        printWriter.print("\n</body>\n</html>\n");
        printWriter.flush();
    }

    private void getUserInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = BEasService.getUser(httpServletRequest.getRemoteUser()).getUsername();
        BPermissions bPermissions = this.getSecurityBits(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(bPermissions.encodeToString());
        if (bPermissions != BPermissions.none && string != null) {
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.flush();
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(byteArrayOutputStream.size());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    private void getJre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        System.out.println("Need to fixx EasServlet.getJre()!!!");
        httpServletResponse.sendError(500);
    }

    private void getReport(WebOp webOp, Lexicon lexicon) throws IOException {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        String string = httpServletRequest.getPathInfo();
        if (string.length() < REPORTS_URI.length() + 1) {
            httpServletResponse.sendError(400);
            return;
        }
        BEasReport[] bEasReportArray = this.eas.getReportList();
        if (bEasReportArray == null) {
            httpServletResponse.sendError(500);
            return;
        }
        String string2 = string.substring(REPORTS_URI.length() + 1);
        if (string2.equalsIgnoreCase("list")) {
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType("text/plain");
            if (this.eas.isEasLicensed()) {
                PrintWriter printWriter = httpServletResponse.getWriter();
                boolean bl = true;
                for (int i = 0; i < bEasReportArray.length; ++i) {
                    BEasReport bEasReport = bEasReportArray[i];
                    if ((bEasReport.getEasReportType() != 0 || !this.eas.isEasE2Licensed() && !this.eas.isDemo()) && (bEasReport.getEasReportType() != 1 || !this.eas.isEasCostLicensed() && !this.eas.isDemo()) || !this.eas.isReportLicensed(bEasReport.getEasKey())) continue;
                    if (!bl) {
                        printWriter.print(';');
                    }
                    bl = false;
                    printWriter.print(bEasReport.getEasKey());
                    printWriter.print(':');
                    printWriter.print(bEasReport.getReportUri());
                }
                printWriter.flush();
            }
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void getSavedReports(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        int n;
        String string;
        int n2;
        Object object;
        Object object2;
        BUser bUser = this.getUser(httpServletRequest);
        if (bUser == null) {
            httpServletResponse.sendError(403);
            return;
        }
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null) {
            hashtable3 = HttpUtils.parseQueryString((String)string2);
        }
        if (hashtable3 == null) {
            hashtable = this.eas.getReports(null, bUser, true, false);
            hashtable2 = this.eas.getReports(null, bUser, false, true);
        } else {
            boolean bl;
            object2 = EasServlet.getPostField("id", hashtable3);
            object = EasServlet.getPostField("access", hashtable3);
            n2 = object == null || ((String)object).equals("all") || ((String)object).equals("public") ? 1 : 0;
            boolean bl2 = bl = object == null || ((String)object).equals("all") || ((String)object).equals("private");
            if (n2 != 0) {
                hashtable = this.eas.getReports((String)object2, bUser, n2 != 0, false);
            }
            if (bl) {
                hashtable2 = this.eas.getReports((String)object2, bUser, false, bl);
            }
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/plain");
        object2 = httpServletResponse.getWriter();
        object = null;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((PrintWriter)object2).print(string);
                ((PrintWriter)object2).print('\n');
                object = (Vector)hashtable.get(string);
                n2 = ((Vector)object).size();
                for (n = 0; n < n2; ++n) {
                    ((PrintWriter)object2).print('+');
                    ((PrintWriter)object2).print(((Vector)object).elementAt(n));
                    ((PrintWriter)object2).print('\n');
                }
                if (hashtable2 != null && (object = (Vector)hashtable2.get(string)) != null) {
                    hashtable2.remove(string);
                    n2 = ((Vector)object).size();
                    for (n = 0; n < n2; ++n) {
                        ((PrintWriter)object2).print('-');
                        ((PrintWriter)object2).print(((Vector)object).elementAt(n));
                        ((PrintWriter)object2).print('\n');
                    }
                }
                ((PrintWriter)object2).print('\n');
            }
        }
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((PrintWriter)object2).print(string);
                ((PrintWriter)object2).print('\n');
                object = (Vector)hashtable2.get(string);
                n2 = ((Vector)object).size();
                for (n = 0; n < n2; ++n) {
                    ((PrintWriter)object2).print('-');
                    ((PrintWriter)object2).print(((Vector)object).elementAt(n));
                    ((PrintWriter)object2).print('\n');
                }
                ((PrintWriter)object2).print('\n');
            }
        }
        ((PrintWriter)object2).flush();
    }

    private void getSummary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        BOrd bOrd = null;
        BIFile bIFile = null;
        try {
            bOrd = BOrd.make((String)SUMMARY);
            bIFile = (BIFile)bOrd.resolve().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bIFile == null) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(bIFile.getMimeType());
        InputStream inputStream = bIFile.getInputStream();
        Template template = new Template(new HtmlWriter((Writer)httpServletResponse.getWriter()), new BufferedReader(new InputStreamReader(inputStream)), this);
        EasTemplateArg easTemplateArg = new EasTemplateArg(null, lexicon);
        template.generate(easTemplateArg);
        inputStream.close();
    }

    private void writeSummary(HtmlWriter htmlWriter, Lexicon lexicon) {
        BModule bModule = Sys.getModuleForClass((Class)(class$com$tridium$eas$BEasService == null ? (class$com$tridium$eas$BEasService = EasServlet.class$("com.tridium.eas.BEasService")) : class$com$tridium$eas$BEasService));
        htmlWriter.print("<table>\n");
        htmlWriter.print("  <tr align=left>\n");
        htmlWriter.print("    <td class=\"bold\">");
        htmlWriter.print(lexicon.getText("moduleVersion"));
        htmlWriter.print("</td>\n");
        htmlWriter.print("    <td>");
        htmlWriter.print(bModule.toString(null));
        htmlWriter.print("</td>\n");
        htmlWriter.print("  </tr>\n");
        int n = this.getSiteCount();
        htmlWriter.print("  <tr align=left>\n");
        htmlWriter.print("    <td class=\"bold\">");
        htmlWriter.print(lexicon.getText("configuredSites"));
        htmlWriter.print("</td>\n");
        htmlWriter.print("    <td>");
        htmlWriter.print(Integer.toString(n));
        htmlWriter.print("</td>\n");
        htmlWriter.print("  </tr>\n");
        int n2 = this.eas.getLicensedDataPointCount();
        String string = n2 == Integer.MAX_VALUE ? lexicon.getText("unlimited") : Integer.toString(n2);
        int n3 = this.eas.getDatabase().getDataPointCount();
        htmlWriter.print("  <tr align=left>\n");
        htmlWriter.print("    <td class=\"bold\">");
        htmlWriter.print(lexicon.getText("configuredDataPoints"));
        htmlWriter.print("</td>\n");
        htmlWriter.print("    <td>");
        htmlWriter.print(Integer.toString(n3) + " " + lexicon.getText("of") + " " + string);
        if (this.eas.isDemo()) {
            htmlWriter.print(" " + lexicon.getText("demo"));
        }
        htmlWriter.print("</td>\n");
        htmlWriter.print("  </tr>\n");
        int n4 = this.eas.getLicensedMeterCount();
        String string2 = n4 == Integer.MAX_VALUE ? lexicon.getText("unlimited") : Integer.toString(n4);
        int n5 = this.eas.getAttachedMeterCount();
        htmlWriter.print("  <tr align=left>\n");
        htmlWriter.print("    <td class=\"bold\">");
        htmlWriter.print(lexicon.getText("attachedMeters"));
        htmlWriter.print("</td>\n");
        htmlWriter.print("    <td>");
        htmlWriter.print(Integer.toString(n5) + " " + lexicon.getText("of") + " " + string2);
        if (this.eas.isDemo()) {
            htmlWriter.print(" " + lexicon.getText("demo"));
        }
        htmlWriter.print("</td>\n");
        htmlWriter.print("  </tr>\n");
        int n6 = this.eas.getLicensedStationCount();
        String string3 = n6 == Integer.MAX_VALUE ? lexicon.getText("unlimited") : Integer.toString(n6);
        int n7 = this.eas.getEasStationCount();
        htmlWriter.print("  <tr align=left>\n");
        htmlWriter.print("    <td class=\"bold\">");
        htmlWriter.print(lexicon.getText("configuredEasStations"));
        htmlWriter.print("</td>\n");
        htmlWriter.print("    <td>");
        htmlWriter.print(Integer.toString(n7) + " " + lexicon.getText("of") + " " + string3);
        htmlWriter.print("</td>\n");
        htmlWriter.print("  </tr>\n");
        htmlWriter.print("</table>\n");
    }

    private void writeLocalizedName(HtmlWriter htmlWriter, String string, Lexicon lexicon) {
        htmlWriter.print(lexicon.getText(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private int getSiteCount() {
        block26: {
            SQLException sQLException3;
            String string;
            ResultSet resultSet;
            Connection connection;
            Statement statement;
            block21: {
                SQLException sQLException22;
                int n;
                block22: {
                    statement = null;
                    connection = this.eas.getDatabase().getConnection();
                    resultSet = null;
                    string = null;
                    statement = connection.createStatement();
                    string = "select count(*) from " + this.eas.getDatabase().getDBSpecific().getFullTableName("EAS", "GROUPS") + " where type='P'";
                    resultSet = statement.executeQuery(string);
                    if (!resultSet.next()) break block21;
                    n = resultSet.getInt(1);
                    Object var7_7 = null;
                    if (resultSet == null) break block22;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException22) {
                        sQLException22.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException22) {
                        sQLException22.printStackTrace();
                    }
                }
                this.eas.getDatabase().freeConnection(connection);
                return n;
            }
            Object var7_8 = null;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException3) {
                    sQLException3.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3) {
                    sQLException3.printStackTrace();
                }
            }
            this.eas.getDatabase().freeConnection(connection);
            {
                break block26;
                catch (Exception exception) {
                    SQLException sQLException42;
                    System.out.println(string);
                    exception.printStackTrace();
                    Object var7_9 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42) {
                            sQLException42.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42) {
                            sQLException42.printStackTrace();
                        }
                    }
                    this.eas.getDatabase().freeConnection(connection);
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException52;
                Object var7_10 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException52) {
                        sQLException52.printStackTrace();
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException52) {
                        sQLException52.printStackTrace();
                    }
                }
                this.eas.getDatabase().freeConnection(connection);
                throw throwable;
            }
        }
        return 0;
    }

    private void writeUnderConstruction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        System.out.println("Need to fixx EasServlet.writeUnderConstruction()!!!");
        httpServletResponse.sendError(500);
    }

    private void getDbConfig(WebOp webOp, Lexicon lexicon) throws IOException {
        if (this.eas.isEasLicensed()) {
            BEasReport.writeApplet(webOp, "com.tridium.eas.ui.dbconfig.DbConfigApplication");
        } else {
            HttpServletRequest httpServletRequest = webOp.getRequest();
            HttpServletResponse httpServletResponse = webOp.getResponse();
            httpServletResponse.sendError(403, lexicon.getText("unlicensedView"));
        }
    }

    private void getReportAdmin(WebOp webOp, Lexicon lexicon) throws IOException {
        if (this.eas.isEasLicensed()) {
            BEasReport.writeApplet(webOp, "com.tridium.eas.ui.reports.admin.ReportAdmin");
        } else {
            HttpServletRequest httpServletRequest = webOp.getRequest();
            HttpServletResponse httpServletResponse = webOp.getResponse();
            httpServletResponse.sendError(403, lexicon.getText("unlicensedView"));
        }
    }

    private void getDiagnostics(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        System.out.println("Need to fixx EasServlet.getDiagnostics()!!!");
        httpServletResponse.sendError(500);
    }

    public void writeApplication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        System.out.println("Need to fixx EasServlet.writeApplication(" + string + ")!!!");
        httpServletResponse.sendError(500);
    }

    public void doPost(WebOp webOp) throws Exception {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        MergedLexicon mergedLexicon = MergedLexicon.make(Lexicon.make((String)"eas", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)), Lexicon.make((String)"baja", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)));
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        if (string.startsWith(REPORT_CMD_URI)) {
            this.doReportCommand(httpServletRequest, httpServletResponse, mergedLexicon);
        } else if (string.startsWith(DX_URI)) {
            XmlMessage xmlMessage;
            DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
            XmlDecoder xmlDecoder = new XmlDecoder(dataInputStream);
            XmlMessage xmlMessage2 = (XmlMessage)xmlDecoder.decodeDocument();
            if (BEasService.log.isTraceOn() && xmlMessage2 != null) {
                BEasService.log.trace("*** Received XmlMessage in doPost: \n" + xmlMessage2.toDebugString());
            }
            if ((xmlMessage = this.eas.getEasServerSession().handleAction(BEasService.getUser(webOp.getRequest().getRemoteUser()).getUsername(), xmlMessage2)) == null) {
                xmlMessage = new XmlMessage("noResponse");
            }
            if (BEasService.log.isTraceOn()) {
                BEasService.log.trace("*** Sending XmlMessage in doPost: \n" + xmlMessage.toDebugString());
            }
            httpServletResponse.setStatus(200);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlEncoder xmlEncoder = new XmlEncoder(byteArrayOutputStream);
            xmlEncoder.encodeDocument(xmlMessage);
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            byteArrayOutputStream.writeTo(dataOutputStream);
            dataOutputStream.close();
        } else if (string.startsWith(COST_URI) && this.costHandler != null) {
            this.costHandler.doPost(webOp, mergedLexicon);
        } else if (string.startsWith(PARTITION_URI) && this.partitionHandler != null) {
            this.partitionHandler.doPost(webOp, mergedLexicon);
        } else {
            httpServletResponse.sendError(400);
        }
    }

    private void doReportCommand(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.length() < REPORT_CMD_URI.length() + 1) {
            httpServletResponse.sendError(400);
            return;
        }
        String string2 = string.substring(REPORT_CMD_URI.length() + 1);
        if (string2.equalsIgnoreCase("save")) {
            this.saveReport(httpServletRequest, httpServletResponse, lexicon);
        } else if (string2.equalsIgnoreCase("load")) {
            this.loadReport(httpServletRequest, httpServletResponse, lexicon);
        } else if (string2.equalsIgnoreCase("delete")) {
            this.deleteReport(httpServletRequest, httpServletResponse, lexicon);
        } else {
            httpServletResponse.sendError(400, lexicon.getText("unknownCommand") + string2);
        }
    }

    private void saveReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        int n;
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportNameRequired"));
            return;
        }
        Hashtable hashtable = HttpUtils.parseQueryString((String)httpServletRequest.getQueryString());
        String string2 = EasServlet.getPostField("reportName", hashtable);
        if (string2 == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportNameRequired"));
            return;
        }
        String string3 = EasServlet.getPostField("reportId", hashtable);
        if (string3 == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportIdRequired"));
            return;
        }
        BEasReport[] bEasReportArray = this.eas.getReportList();
        if (bEasReportArray == null) {
            httpServletResponse.sendError(500);
            return;
        }
        BEasReport bEasReport = null;
        for (n = 0; n < bEasReportArray.length; ++n) {
            if (!bEasReportArray[n].getEasKey().equals(string3)) continue;
            bEasReport = bEasReportArray[n];
            break;
        }
        if (!(bEasReport == null || (bEasReport.getEasReportType() == 0 && (this.eas.isEasE2Licensed() || this.eas.isDemo()) || bEasReport.getEasReportType() == 1 && (this.eas.isEasCostLicensed() || this.eas.isDemo())) && this.eas.isReportLicensed(bEasReport.getEasKey()))) {
            httpServletResponse.sendError(403, lexicon.getText("unlicensedView"));
            return;
        }
        n = httpServletRequest.getContentLength();
        if (n <= 0) {
            httpServletResponse.sendError(411);
            return;
        }
        httpServletResponse.setStatus(100);
        httpServletResponse.getOutputStream();
        DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
        String string4 = dataInputStream.readUTF();
        byte[] byArray = new byte[n - (string4.length() + 2)];
        dataInputStream.readFully(byArray);
        if (string4.length() == 0) {
            string4 = null;
        }
        this.eas.saveReport(string4, string2, string3, byArray);
        httpServletResponse.setStatus(201);
    }

    private void loadReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportNameRequired"));
            return;
        }
        Hashtable hashtable = HttpUtils.parseQueryString((String)httpServletRequest.getQueryString());
        String string2 = EasServlet.getPostField("reportName", hashtable);
        if (string2 == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportNameRequired"));
            return;
        }
        String string3 = EasServlet.getPostField("reportId", hashtable);
        if (string3 == null) {
            httpServletResponse.sendError(400, lexicon.getText("reportIdRequired"));
            return;
        }
        BEasReport[] bEasReportArray = this.eas.getReportList();
        if (bEasReportArray == null) {
            httpServletResponse.sendError(500);
            return;
        }
        BEasReport bEasReport = null;
        for (int i = 0; i < bEasReportArray.length; ++i) {
            if (!bEasReportArray[i].getEasKey().equals(string3)) continue;
            bEasReport = bEasReportArray[i];
            break;
        }
        if (!(bEasReport == null || (bEasReport.getEasReportType() == 0 && (this.eas.isEasE2Licensed() || this.eas.isDemo()) || bEasReport.getEasReportType() == 1 && (this.eas.isEasCostLicensed() || this.eas.isDemo())) && this.eas.isReportLicensed(bEasReport.getEasKey()))) {
            httpServletResponse.sendError(403, lexicon.getText("unlicensedView"));
            return;
        }
        byte[] byArray = this.eas.loadReport(BEasService.getUser(httpServletRequest.getRemoteUser()).getUsername(), string2, string3);
        if (byArray == null) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(byArray.length);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(byArray);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private void getDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = EasServlet.getRequestURINoPrefix(httpServletRequest);
        int n = string.lastIndexOf(47);
        Upload upload = Upload.getUpload(this.getUser(httpServletRequest).getUsername(), string.substring(n + 1), this.eas.getUploadDirectory());
        if (upload == null) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(upload.getContent().length);
        httpServletResponse.setContentType(upload.getMimeType());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byte[] byArray = upload.getContent();
        servletOutputStream.write(byArray);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private void deleteReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            printWriter.print(lexicon.getText("reportNameRequired"));
            return;
        }
        Hashtable hashtable = HttpUtils.parseQueryString((String)httpServletRequest.getQueryString());
        String string2 = EasServlet.getPostField("reportName", hashtable);
        if (string2 == null) {
            printWriter.print(lexicon.getText("reportNameRequired"));
            return;
        }
        String string3 = EasServlet.getPostField("reportId", hashtable);
        if (string3 == null) {
            printWriter.print(lexicon.getText("reportIdRequired"));
            return;
        }
        BEasReport[] bEasReportArray = this.eas.getReportList();
        if (bEasReportArray == null) {
            httpServletResponse.sendError(500);
            return;
        }
        BEasReport bEasReport = null;
        for (int i = 0; i < bEasReportArray.length; ++i) {
            if (!bEasReportArray[i].getEasKey().equals(string3)) continue;
            bEasReport = bEasReportArray[i];
            break;
        }
        if (!(bEasReport == null || (bEasReport.getEasReportType() == 0 && (this.eas.isEasE2Licensed() || this.eas.isDemo()) || bEasReport.getEasReportType() == 1 && (this.eas.isEasCostLicensed() || this.eas.isDemo())) && this.eas.isReportLicensed(bEasReport.getEasKey()))) {
            printWriter.print(lexicon.getText("unlicensedView"));
            return;
        }
        String string4 = EasServlet.getPostField("public", hashtable);
        boolean bl = string4 != null && string4.equals("true");
        BUser bUser = this.getUser(httpServletRequest);
        if (bUser == null) {
            printWriter.print(lexicon.getText("unauthorized"));
            return;
        }
        boolean bl2 = this.eas.deleteReport(bUser, bl ? null : bUser.getUsername(), string2, string3);
        if (bl2) {
            printWriter.print("OK");
        }
        printWriter.flush();
    }

    private BPermissions getSecurityBits(String string) {
        BUser bUser = BEasService.getUser(string);
        if (bUser == null) {
            return BPermissions.none;
        }
        return bUser.getPermissionsFor((BIProtected)this.eas);
    }

    public void sendFile(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        try {
            String string2;
            BOrd bOrd = null;
            if (string.startsWith("help")) {
                string2 = string.substring(4, string.length());
                bOrd = BOrd.make((String)("module://eas" + string2));
            } else {
                bOrd = string.startsWith("/eas") ? BOrd.make((String)("module:/" + string)) : BOrd.make((String)string.substring(1));
            }
            string2 = (BIFile)bOrd.resolve().get();
            String string3 = string2.getExtension().toLowerCase();
            if (string3.startsWith("htm")) {
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType(string2.getMimeType());
                InputStream inputStream = string2.getInputStream();
                Template template = new Template(new HtmlWriter((Writer)httpServletResponse.getWriter()), new BufferedReader(new InputStreamReader(inputStream)), this);
                MergedLexicon mergedLexicon = MergedLexicon.make(Lexicon.make((String)"eas", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)), Lexicon.make((String)"baja", (String)WebUtil.getLanguage((HttpServletRequest)httpServletRequest, null)));
                EasTemplateArg easTemplateArg = new EasTemplateArg(null, (Object)mergedLexicon);
                template.generate(easTemplateArg);
                inputStream.close();
            } else {
                byte[] byArray = string2.read();
                httpServletResponse.setContentType(string2.getMimeType());
                httpServletResponse.setContentLength(byArray.length);
                httpServletResponse.getOutputStream().write(byArray);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpServletResponse.sendError(404);
            return;
        }
    }

    private void getLogInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Lexicon lexicon) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<body>");
        printWriter.println("<a href=\"/eas\">" + lexicon.getText("vesMain") + "</a>");
        printWriter.println("<br>");
        printWriter.println("<h2>" + lexicon.getText("easLogs") + "</h2>");
        printWriter.println("<hr>");
        Vector vector = this.easSession.getDataPointExec().getAllDataPointNames();
        if (vector != null && vector.size() > 0) {
            printWriter.println("<table border=1>");
            printWriter.print("<tr>");
            printWriter.print("<th>" + lexicon.getText("name") + "  (" + lexicon.getText("resultSize") + vector.size() + ")</th>");
            printWriter.println("</tr>");
            Object[] objectArray = vector.toArray();
            SortUtil.sort((Object[])objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                printWriter.println("<tr>");
                printWriter.print("  <td>");
                printWriter.print("<a href=\"/ord?history:");
                printWriter.print(string);
                printWriter.print("|view:history:HistoryTable\">");
                printWriter.print(SlotPath.unescape((String)string));
                printWriter.print("</a>");
                printWriter.println("</td>");
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EasTemplateArg {
        private Object Arg1 = null;
        private Object Arg2 = null;

        public EasTemplateArg(Object object) {
            this.Arg1 = object;
        }

        public EasTemplateArg(Object object, Object object2) {
            this.Arg1 = object;
            this.Arg2 = object2;
        }
    }
}

