/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.BDatabaseConfiguration;
import com.tridium.eas.util.SqlUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MSSqlServer
extends SqlUtil {
    private static boolean sqlStatementsPrepared = false;
    private static PreparedStatement psDbExists;
    private static PreparedStatement psGetDbFilenames;
    private static PreparedStatement psDropDb;
    private static PreparedStatement psGetTableSummary;
    private static PreparedStatement psGetTableList;
    private static PreparedStatement psTableExists;
    private static PreparedStatement psBackupDb;
    private static PreparedStatement psGetTSColumnName;
    private static PreparedStatement psGetColumnNameType;
    private static PreparedStatement psRenameTable;
    private static PreparedStatement psGetTableListNumCol;
    public static boolean cancelBackup;

    public static synchronized void prepareSqlStatements(Connection connection) {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT filename FROM [").append(databaseName).append("].[dbo].[sysfiles]");
            psGetDbFilenames = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT name FROM master.dbo.sysdatabases WHERE name = N'").append(databaseName).append("'");
            psDbExists = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [COLUMN_NAME], [IS_NULLABLE], [DATA_TYPE], [CHARACTER_MAXIMUM_LENGTH], [NUMERIC_PRECISION] FROM [").append(databaseName).append("].[INFORMATION_SCHEMA].[COLUMNS] where [table_name] = ? ").append("and [table_catalog] = '").append(databaseName).append("' and [table_schema] ='dbo' Order by [ordinal_position]");
            psGetTableSummary = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [name] FROM [").append(databaseName).append("].[dbo].[sysobjects] WHERE xtype = 'U' order by name");
            psGetTableList = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [name] FROM [").append(databaseName).append("].[dbo].[sysobjects] WHERE xtype = 'U' and [info] = ? order by name");
            psGetTableListNumCol = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [id] FROM [").append(databaseName).append("].[dbo].sysobjects WHERE [name] = ? and xtype = 'U'");
            psTableExists = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [COLUMN_NAME] FROM [").append(databaseName).append("].[INFORMATION_SCHEMA].[COLUMNS] where [TABLE_NAME] = ? and [DATA_TYPE] = 'datetime' order by [ORDINAL_POSITION]");
            psGetTSColumnName = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT [COLUMN_NAME], [DATA_TYPE] FROM [").append(databaseName).append("].[INFORMATION_SCHEMA].[COLUMNS] where [TABLE_NAME] = ? order by [ORDINAL_POSITION]");
            psGetColumnNameType = connection.prepareStatement(stringBuffer.toString());
            stringBuffer = new StringBuffer(100);
            stringBuffer.append("USE[").append(databaseName).append("] ").append("exec sp_rename ? , ?");
            psRenameTable = connection.prepareStatement(stringBuffer.toString());
            sqlStatementsPrepared = true;
        }
        catch (Exception exception) {
            sqlStatementsPrepared = false;
            log.error("Cannot prepare sql statement", (Throwable)exception);
        }
    }

    public static synchronized File backupDatabase() throws Exception {
        File file = null;
        Connection connection = dbConfig.getConnection();
        connection.setAutoCommit(true);
        if (MSSqlServer.databaseExists(connection) && MSSqlServer.databaseFilesExist()) {
            String string = databaseDataFile.getPath().trim();
            String string2 = string.substring(0, string.lastIndexOf("."));
            file = new File(string2 + "_Backup.DAT");
            if (file.exists()) {
                file.delete();
            }
            while (!cancelBackup) {
                try {
                    System.out.println("Attempting to backup database...");
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("use master ").append("if not exists (select * from dbo.sysdevices where name = '").append(databaseName).append("_Backup') ").append("exec sp_addumpdevice 'disk', '").append(databaseName).append("_Backup', ? ").append("Backup database ").append(databaseName).append(" to ").append(databaseName).append("_Backup");
                    psBackupDb = connection.prepareStatement(stringBuffer.toString());
                    psBackupDb.setString(1, file.getPath());
                    psBackupDb.execute();
                    break;
                }
                catch (Exception exception) {
                    try {
                        exception.printStackTrace();
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception2) {}
                }
            }
            if (cancelBackup) {
                log.warning("Database backup cancelled.");
            }
            cancelBackup = false;
        }
        dbConfig.freeConnection(connection);
        return file;
    }

    public static void renameTable(Connection connection, String string, String string2) throws SQLException {
        try {
            psRenameTable.setString(1, string);
            psRenameTable.setString(2, string2);
            psRenameTable.execute();
        }
        catch (Exception exception) {
            log.error("Could not rename database table (oldName=" + string + ", newName=" + string2 + ")", (Throwable)exception);
        }
    }

    public static void backupTable(Connection connection, String string) throws SQLException {
        for (int i = 0; i < 100; ++i) {
            String string2 = string + "_old" + i;
            if (MSSqlServer.doesTableExist(connection, string2)) continue;
            MSSqlServer.renameTable(connection, string, string2);
            return;
        }
        throw new IllegalStateException("Way too many old tables!");
    }

    public static synchronized boolean doesTableExist(Connection connection, String string) throws SQLException {
        boolean bl = false;
        psTableExists.setString(1, string);
        ResultSet resultSet = psTableExists.executeQuery();
        bl = resultSet.next();
        return bl;
    }

    public static synchronized void dropDatabase(Connection connection) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'").append(databaseName).append("')").append(" DROP DATABASE [").append(databaseName).append("]");
            psDropDb = connection.prepareStatement(stringBuffer.toString());
            psDropDb.execute();
        }
        catch (SQLException sQLException) {
            log.error("Error when dropping database.", (Throwable)sQLException);
        }
    }

    public static boolean databaseExists(Connection connection) throws SQLException {
        boolean bl = false;
        if (databaseName == null) {
            return bl;
        }
        try {
            ResultSet resultSet = psDbExists.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException sQLException) {
            log.error("Error when checking database existence.", (Throwable)sQLException);
        }
        return bl;
    }

    public static synchronized void setDatabaseFilenames(BDatabaseConfiguration bDatabaseConfiguration, Connection connection) throws SQLException {
        try {
            String string;
            ResultSet resultSet = psGetDbFilenames.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString(1);
                bDatabaseConfiguration.setSqlServerDbDataFilename(string.trim());
            }
            if (resultSet.next()) {
                string = resultSet.getString(1);
                bDatabaseConfiguration.setSqlServerDbLogFilename(string.trim());
            }
        }
        catch (SQLException sQLException) {
            log.error("Error setting database file names.", (Throwable)sQLException);
        }
    }

    public static boolean databaseFilesExist() {
        boolean bl = false;
        try {
            if (databaseDataFile.exists() && databaseLogFile.exists()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            log.error("Error checking for database file existence.", (Throwable)exception);
        }
        return bl;
    }

    public static void deleteDatabaseFiles() {
        try {
            databaseDataFile.delete();
            databaseLogFile.delete();
        }
        catch (Exception exception) {
            log.error("Error deleting database files.", (Throwable)exception);
        }
    }

    public static synchronized void createDatabase(Connection connection) throws SQLException {
        Comparable<File> comparable;
        Comparable<StringBuffer> comparable2;
        boolean bl = false;
        connection.setAutoCommit(true);
        if (databaseRemote) {
            return;
        }
        if (MSSqlServer.databaseExists(connection)) {
            if (databaseRemote || MSSqlServer.databaseFilesExist()) {
                bl = false;
            } else {
                MSSqlServer.dropDatabase(connection);
                MSSqlServer.deleteDatabaseFiles();
                bl = true;
            }
        } else {
            MSSqlServer.deleteDatabaseFiles();
            bl = true;
        }
        if (!bl) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            string = databaseDataFile.getPath();
            string.trim();
            comparable2 = new File(string.substring(0, string.lastIndexOf("\\")));
            ((File)comparable2).mkdirs();
            string2 = databaseLogFile.getPath();
            string2.trim();
            comparable = new File(string2.substring(0, string2.lastIndexOf("\\")));
            ((File)comparable).mkdirs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        comparable2 = new StringBuffer(100);
        ((StringBuffer)comparable2).append("create database ").append(databaseName).append(" on (Name='").append(databaseName).append("_Data', filename='").append(string).append("', filegrowth = 10%)").append(" log on (name='").append(databaseName).append("_Log', filename='").append(string2).append("', filegrowth=10%)");
        comparable = new StringBuffer(100);
        ((StringBuffer)comparable).append("exec sp_dboption N'").append(databaseName).append("', N'autoclose', N'true' ").append("exec sp_dboption N'").append(databaseName).append("', N'bulkcopy', N'true' ").append("exec sp_dboption N'").append(databaseName).append("', N'trunc. log', N'true' ").append("exec sp_dboption N'").append(databaseName).append("', N'torn page detection', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'read only', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'dbo use', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'single', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'autoshrink', N'true' ").append("exec sp_dboption N'").append(databaseName).append("', N'ANSI null default', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'recursive triggers', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'ANSI nulls', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'concat null yields null', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'cursor close on commit', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'default to local cursor', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'quoted identifier', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'ANSI warnings', N'false' ").append("exec sp_dboption N'").append(databaseName).append("', N'auto create statistics', N'true' ").append("exec sp_dboption N'").append(databaseName).append("', N'auto update statistics', N'true' ");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("use [").append(databaseName).append("] ").append("if not exists (select * from master.dbo.syslogins where loginname = N'").append(databaseUser).append("') ").append("exec sp_addlogin N'").append(databaseUser).append("', '").append(databasePass).append("', N'").append(databaseName).append("', N'us_english'");
        Statement statement = connection.createStatement();
        try {
            connection.setAutoCommit(true);
            statement.execute(((StringBuffer)comparable2).toString());
            statement.execute(((StringBuffer)comparable).toString());
            statement.execute(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        statement.close();
    }

    static {
        cancelBackup = false;
    }
}

