/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.util.DBSpecific;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class DBSpecificSQLServer
extends DBSpecific {
    SimpleDateFormat fmt = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    String dbfmt = "'MM-DD-YYYY HH24:MI:SS'";
    private String dbName = null;

    public String dateSelect(String string) {
        StringBuffer stringBuffer = new StringBuffer(70);
        stringBuffer.append("TO_CHAR(");
        stringBuffer.append(string);
        stringBuffer.append(',');
        stringBuffer.append(this.dbfmt);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String date2db(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(date);
        int n = calendar.get(15);
        calendar.add(14, -n);
        Date date2 = calendar.getTime();
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("TO_DATE('");
        String string = this.fmt.format(date2);
        stringBuffer.append(string);
        stringBuffer.append("',");
        stringBuffer.append(this.dbfmt);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Date char2date(String string) {
        Date date = null;
        if (string != null) {
            date = this.fmt.parse(string, new ParsePosition(0));
        }
        return date;
    }

    public Date db2date(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return this.char2date(string);
    }

    public String nextval(String string) {
        return "select " + string + ".nextval from DUAL";
    }

    public int getSQL_Error(SQLException sQLException) {
        String string = sQLException.getSQLState();
        if (string.equals("42S01")) {
            return 955;
        }
        if (string.equals("42S11")) {
            return 955;
        }
        if (string.equals("42S21")) {
            return 955;
        }
        return -1;
    }

    public String typeBoolean() {
        return "BIT";
    }

    public String typeInt8() {
        return "TINYINT";
    }

    public String typeInt16() {
        return "SMALLINT";
    }

    public String typeInt32() {
        return "INT";
    }

    public String typeInt64() {
        return "BIGINT";
    }

    public String typeReal32() {
        return "REAL";
    }

    public String typeReal64() {
        return "FLOAT";
    }

    public String typeVarchar(int n) {
        return "VARCHAR(" + n + ")";
    }

    public String typeNumeric(int n, int n2) {
        throw new IllegalArgumentException("typeNumeric not supported");
    }

    public String typeLongBit() {
        return "IMAGE";
    }

    public String typeTimestamp() {
        return "DATETIME";
    }

    public String getCreateSchema(String string) {
        return null;
    }

    public void setDbName(String string) {
        this.dbName = string;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getFullTableName(String string, String string2) {
        if (this.dbName == null || this.dbName.trim().length() == 0) {
            return "[dbo]." + string2;
        }
        return "[" + this.dbName + "].[dbo]." + string2;
    }

    public String getDbTableName(Connection connection, String string, String string2) {
        return this.getFullTableName(string, string2);
    }
}

