/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.util.DBSpecific;
import com.tridium.eas.util.Oracle;
import com.tridium.eas.util.SqlUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class DBSpecificOracle
extends DBSpecific {
    SimpleDateFormat fmt = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    String dbfmt = "'MM-DD-YYYY HH24:MI:SS'";
    private String schemaName = null;
    private String dbName = null;

    public String dateSelect(String string) {
        StringBuffer stringBuffer = new StringBuffer(70);
        stringBuffer.append("TO_CHAR(");
        stringBuffer.append(string);
        stringBuffer.append(',');
        stringBuffer.append(this.dbfmt);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String date2db(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(date);
        int n = calendar.get(15);
        calendar.add(14, -n);
        Date date2 = calendar.getTime();
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("TO_DATE('");
        String string = this.fmt.format(date2);
        stringBuffer.append(string);
        stringBuffer.append("',");
        stringBuffer.append(this.dbfmt);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Date char2date(String string) {
        Date date = null;
        if (string != null) {
            date = this.fmt.parse(string, new ParsePosition(0));
        }
        return date;
    }

    public Date db2date(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return this.char2date(string);
    }

    public String nextval(String string) {
        return "select " + string + ".nextval from DUAL";
    }

    public String typeBoolean() {
        return "NUMBER(1)";
    }

    public String typeInt8() {
        return "NUMBER(3)";
    }

    public String typeInt16() {
        return "NUMBER(5)";
    }

    public String typeInt32() {
        return "NUMBER(10)";
    }

    public String typeInt64() {
        return "NUMBER(20)";
    }

    public String typeReal32() {
        return "NUMBER(20,10)";
    }

    public String typeReal64() {
        return "NUMBER(38,19)";
    }

    public String typeVarchar(int n) {
        return "VARCHAR2(" + n + ")";
    }

    public String typeNumeric(int n, int n2) {
        return "NUMBER(" + n + "," + n2 + ")";
    }

    public String typeLongBit() {
        return "LONG RAW";
    }

    public String typeTimestamp() {
        return "DATE";
    }

    public String getCreateSchema(String string) {
        return null;
    }

    public void setDbName(String string) {
        this.dbName = SqlUtil.databaseName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getFullTableName(String string, String string2) {
        return Oracle.getFullName(string2);
    }

    public String getDbTableName(Connection connection, String string, String string2) {
        String string3 = null;
        try {
            string3 = Oracle.getOracleTableName(connection, string2);
            if (string3 == null) {
                if (Oracle.makeOracleTableName(connection, string2)) {
                    string3 = Oracle.getOracleTableName(connection, string2);
                } else {
                    System.out.println("Cannot create table " + string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }
}

