/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.sql.PooledConnection;
import net.sourceforge.jtds.jdbcx.JtdsDataSource;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class ConnectionPool {
    private Connection[] pool;
    private boolean[] used;
    private String url = null;
    private String user = null;
    private String password = null;
    private NewConnectionCallback cb;
    private JtdsDataSource sqlDs = null;
    private OracleConnectionPoolDataSource oracleDs = null;
    private static final Log log = Log.getLog((String)"eas");

    public ConnectionPool(String string, String string2, String string3, int n) {
        this.pool = new Connection[n];
        this.used = new boolean[n];
        this.url = string;
        this.user = string2;
        this.password = string3;
    }

    public ConnectionPool(JtdsDataSource jtdsDataSource, int n) {
        this.sqlDs = jtdsDataSource;
        this.pool = new Connection[n];
        this.used = new boolean[n];
    }

    public ConnectionPool(OracleConnectionPoolDataSource oracleConnectionPoolDataSource, int n) {
        this.oracleDs = oracleConnectionPoolDataSource;
        this.pool = new Connection[n];
        this.used = new boolean[n];
    }

    public Connection newConnection() throws SQLException {
        Connection connection = null;
        if (this.sqlDs != null) {
            net.sourceforge.jtds.jdbcx.PooledConnection pooledConnection = new net.sourceforge.jtds.jdbcx.PooledConnection(this.sqlDs.getConnection());
            connection = pooledConnection.getConnection();
        } else if (this.oracleDs != null) {
            PooledConnection pooledConnection = this.oracleDs.getPooledConnection();
            connection = pooledConnection.getConnection();
        } else {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        if (this.cb != null) {
            this.cb.newConnection(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection get() throws SQLException, InterruptedException {
        int n = -1;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            while ((n = this.getNextUnused()) == -1) {
                this.wait();
            }
            this.used[n] = true;
        }
        if (this.pool[n] == null) {
            this.pool[n] = this.newConnection();
        }
        this.pool[n].setAutoCommit(false);
        return this.pool[n];
    }

    private int getNextUnused() {
        for (int i = 0; i < this.used.length; ++i) {
            if (this.used[i]) continue;
            return i;
        }
        return -1;
    }

    public void free(Connection connection) throws SQLException {
        boolean bl = connection.isClosed();
        if (bl) {
            log.warning("Closed pooled connection");
        } else {
            connection.commit();
            connection.setAutoCommit(true);
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != connection) continue;
                if (bl) {
                    this.pool[i] = null;
                }
                this.used[i] = false;
                this.notifyAll();
                return;
            }
            throw new IllegalArgumentException("Connection not in pool");
        }
    }

    public void setNewConnectionCallback(NewConnectionCallback newConnectionCallback) {
        this.cb = newConnectionCallback;
    }

    public void closeAll() throws SQLException {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null) continue;
            this.pool[i].close();
        }
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        for (int i = 0; i < this.pool.length; ++i) {
            String string = i < 10 ? " " + i : String.valueOf(i);
            if (this.used[i]) {
                printWriter.println("    " + string + " used: " + this.pool[i]);
                continue;
            }
            printWriter.println("    " + string + " free: " + this.pool[i]);
        }
    }

    public static interface NewConnectionCallback {
        public void newConnection(Connection var1) throws SQLException;
    }
}

