/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.util.BitOp;

public class BoolArray {
    private static final byte[] cntab = new byte[]{0, 1, 2, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private int capacity;
    private int size;
    private int[] v;
    private static int[] m = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    public BoolArray(int n) {
        this.capacity = this.size = n;
        if ((n & 0x1F) != 0) {
            this.capacity = (this.capacity & 0xFFFFFFE0) + 32;
        }
        this.v = new int[this.capacity / 32];
    }

    public BoolArray(int n, boolean bl) {
        this(n);
        this.setAll(bl);
    }

    public BoolArray(boolean[] blArray) {
        this.set(blArray);
    }

    public BoolArray(BoolArray boolArray) {
        this.v = new int[boolArray.v.length];
        this.capacity = boolArray.capacity;
        this.size = boolArray.size;
        int n = this.v.length;
        while (--n >= 0) {
            this.v[n] = boolArray.v[n];
        }
    }

    public BoolArray(BoolArray boolArray, int n) {
        this(n);
        this.setAll(true);
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i % boolArray.size)) continue;
            this.setf(i);
        }
    }

    public BoolArray(BoolArray boolArray, BoolArray boolArray2, BitOp bitOp) {
        if (boolArray.size() != boolArray2.size()) {
            throw new IllegalArgumentException("a.size() != b.size()");
        }
        this.v = new int[boolArray.v.length];
        this.capacity = boolArray.capacity;
        this.size = boolArray.size;
        int n = this.v.length;
        while (--n >= 0) {
            this.v[n] = bitOp.ex(boolArray.v[n], boolArray2.v[n]);
        }
    }

    public void set(boolean[] blArray) {
        this.capacity = this.size = blArray.length;
        if ((this.size & 0x1F) != 0) {
            this.capacity = (this.capacity & 0xFFFFFFE0) + 32;
        }
        int n = this.capacity / 32;
        if (this.v == null || this.v.length != n) {
            this.v = new int[n];
        }
        this.setAll(true);
        for (int i = 0; i < this.size; ++i) {
            if (blArray[i]) continue;
            int n2 = i / 32;
            this.v[n2] = this.v[n2] & ~m[i & 0x1F];
        }
    }

    public int size() {
        return this.size;
    }

    public boolean allTrue() {
        int n = this.v.length;
        while (--n >= 0) {
            if (this.v[n] == -1) continue;
            return false;
        }
        return true;
    }

    public int falseCount() {
        return this.size - this.trueCount();
    }

    public int trueCount() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.v.length;
        while (--n4 > 0) {
            n2 = this.v[n4];
            n = 32;
            while (--n >= 0) {
                if (n2 < 0) {
                    ++n3;
                }
                n2 <<= 1;
            }
        }
        n2 = this.v[n4];
        n = this.capacity - this.size;
        int n5 = 32;
        while (--n5 >= n) {
            if (n2 < 0) {
                ++n3;
            }
            n2 <<= 1;
        }
        return n3;
    }

    public void not() {
        int n = this.v.length;
        while (--n >= 0) {
            this.v[n] = ~this.v[n];
        }
    }

    public void or(BoolArray boolArray) {
        int n = this.v.length;
        while (--n >= 0) {
            int n2 = n;
            this.v[n2] = this.v[n2] | boolArray.v[n];
        }
    }

    public void bop(BoolArray boolArray, BitOp bitOp) {
        int n = this.v.length;
        while (--n >= 0) {
            this.v[n] = bitOp.ex(this.v[n], boolArray.v[n]);
        }
    }

    public void and(BoolArray boolArray) {
        if (this.v.length <= boolArray.v.length) {
            int n = this.v.length;
            while (--n >= 0) {
                int n2 = n;
                this.v[n2] = this.v[n2] & boolArray.v[n];
            }
        } else {
            int n;
            for (n = 0; n < boolArray.v.length; ++n) {
                int n3 = n;
                this.v[n3] = this.v[n3] & boolArray.v[n];
            }
            while (n < this.v.length) {
                this.v[n++] = 0;
            }
        }
    }

    public void setAll(boolean bl) {
        int n = bl ? -1 : 0;
        int n2 = this.v.length;
        while (--n2 >= 0) {
            this.v[n2] = n;
        }
    }

    public boolean get(int n) {
        return (this.v[n / 32] & m[n & 0x1F]) != 0;
    }

    public boolean[] get() {
        boolean[] blArray = new boolean[this.size];
        int n = 0;
        for (int i = 0; i < this.v.length; ++i) {
            int n2 = this.v[i];
            int n3 = 32;
            while (--n3 >= 0 && n < this.size) {
                blArray[n++] = n2 < 0;
                n2 <<= 1;
            }
        }
        return blArray;
    }

    public boolean[] get(boolean[] blArray) {
        int n = 0;
        int n2 = this.v.length / 32;
        while (--n2 >= 0) {
            int n3 = this.v[n2];
            int n4 = 32;
            while (--n4 >= 0) {
                blArray[n++] = (n3 & m[n2 & 0x1F]) != 0;
            }
        }
        return blArray;
    }

    public void sett(int n) {
        int n2 = n / 32;
        this.v[n2] = this.v[n2] | m[n & 0x1F];
    }

    public void setf(int n) {
        int n2 = n / 32;
        this.v[n2] = this.v[n2] & ~m[n & 0x1F];
    }

    public void set(boolean bl, int n) {
        if (bl) {
            this.sett(n);
        } else {
            this.setf(n);
        }
    }
}

