/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.util;

import com.tridium.eas.BEasService;
import com.tridium.eas.util.Comparable;
import com.tridium.eas.util.Comparator;
import java.util.Vector;

public class Alg {
    private static final float[] studentP = new float[]{0.5f, 0.5f, 0.1f, 0.05f, 0.02f, 0.01f, 0.001f, 1.0E-4f};
    private static final float[] studentT = new float[]{1.0f, 1.0f, 6.314f, 12.706f, 31.821f, 63.657f, 636.619f, 2.0f, 0.816f, 2.92f, 4.303f, 6.965f, 9.925f, 31.598f, 3.0f, 0.765f, 2.353f, 3.182f, 4.541f, 5.841f, 12.941f, 4.0f, 0.741f, 2.132f, 2.776f, 3.747f, 4.604f, 8.61f, 5.0f, 0.727f, 2.015f, 2.571f, 3.365f, 4.032f, 6.859f, 6.0f, 0.718f, 1.943f, 2.447f, 3.143f, 3.707f, 5.959f, 7.0f, 0.711f, 1.895f, 2.365f, 2.998f, 3.499f, 5.405f, 8.0f, 0.706f, 1.86f, 2.306f, 2.896f, 3.355f, 5.041f, 9.0f, 0.703f, 1.833f, 2.262f, 2.821f, 3.25f, 4.781f, 10.0f, 0.7f, 1.812f, 2.228f, 2.764f, 3.169f, 4.587f, 11.0f, 0.697f, 1.796f, 2.201f, 2.718f, 3.106f, 4.437f, 12.0f, 0.695f, 1.782f, 2.179f, 2.681f, 3.055f, 4.318f, 13.0f, 0.694f, 1.771f, 2.16f, 2.65f, 3.012f, 4.221f, 14.0f, 0.692f, 1.761f, 2.145f, 2.624f, 2.977f, 4.14f, 15.0f, 0.691f, 1.753f, 2.131f, 2.602f, 2.947f, 4.073f, 16.0f, 0.69f, 1.746f, 2.12f, 2.583f, 2.921f, 4.015f, 17.0f, 0.689f, 1.74f, 2.11f, 2.567f, 2.898f, 3.965f, 18.0f, 0.688f, 1.734f, 2.101f, 2.552f, 2.878f, 3.922f, 19.0f, 0.688f, 1.729f, 2.093f, 2.539f, 2.861f, 3.883f, 20.0f, 0.687f, 1.725f, 2.086f, 2.528f, 2.845f, 3.85f, 21.0f, 0.686f, 1.721f, 2.08f, 2.518f, 2.831f, 3.819f, 22.0f, 0.686f, 1.717f, 2.074f, 2.508f, 2.819f, 3.792f, 23.0f, 0.685f, 1.714f, 2.069f, 2.5f, 2.807f, 3.767f, 24.0f, 0.685f, 1.711f, 2.064f, 2.492f, 2.797f, 3.745f, 25.0f, 0.684f, 1.708f, 2.06f, 2.485f, 2.787f, 3.725f, 26.0f, 0.684f, 1.706f, 2.056f, 2.479f, 2.779f, 3.707f, 27.0f, 0.684f, 1.703f, 2.052f, 2.473f, 2.771f, 3.69f, 28.0f, 0.683f, 1.701f, 2.048f, 2.467f, 2.763f, 3.674f, 29.0f, 0.683f, 1.699f, 2.045f, 2.462f, 2.756f, 3.659f, 30.0f, 0.683f, 1.697f, 2.042f, 2.457f, 2.75f, 3.646f, 40.0f, 0.681f, 1.684f, 2.021f, 2.423f, 2.704f, 3.551f, 60.0f, 0.679f, 1.671f, 2.0f, 2.39f, 2.66f, 3.46f, 120.0f, 0.677f, 1.658f, 1.98f, 2.358f, 2.617f, 3.373f, 999.0f, 0.674f, 1.645f, 1.96f, 2.326f, 2.576f, 3.291f};

    public static void sort(Object[] objectArray, Comparator comparator) {
        int n = objectArray.length;
        for (int i = n / 2; i >= 1; i /= 2) {
            for (int j = i; j < n; ++j) {
                Object object = objectArray[j];
                for (int k = j; k >= i && comparator.compare(object, objectArray[k - i]) < 0; k -= i) {
                    objectArray[k] = objectArray[k - i];
                }
                objectArray[k] = object;
            }
        }
    }

    public static void sort(Vector vector, Comparator comparator) {
        int n = vector.size();
        for (int i = n / 2; i >= 1; i /= 2) {
            for (int j = i; j < n; ++j) {
                int n2;
                Object e = vector.elementAt(j);
                for (n2 = j; n2 >= i && comparator.compare(e, vector.elementAt(n2 - i)) < 0; n2 -= i) {
                    vector.setElementAt(vector.elementAt(n2 - i), n2);
                }
                vector.setElementAt(e, n2);
            }
        }
    }

    public static void sort(Comparable[] comparableArray) {
        int n = comparableArray.length;
        for (int i = n / 2; i >= 1; i /= 2) {
            for (int j = i; j < n; ++j) {
                Comparable comparable = comparableArray[j];
                for (int k = j; k >= i && comparable.compareTo(comparableArray[k - i]) < 0; k -= i) {
                    comparableArray[k] = comparableArray[k - i];
                }
                comparableArray[k] = comparable;
            }
        }
    }

    public static Object find(Object[] objectArray, Object object) {
        if (objectArray == null || object == null) {
            return null;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (!objectArray[n].equals(object)) continue;
            return objectArray[n];
        }
        return null;
    }

    public static Object find(Vector vector, Object object) {
        if (vector == null || object == null) {
            return null;
        }
        int n = vector.size();
        while (--n >= 0) {
            if (!vector.elementAt(n).equals(object)) continue;
            return vector.elementAt(n);
        }
        return null;
    }

    public static Object find(Vector vector, Object object, Comparator comparator) {
        if (vector == null || object == null) {
            return null;
        }
        int n = vector.size();
        while (--n >= 0) {
            if (comparator.compare(vector.elementAt(n), object) != 0) continue;
            return vector.elementAt(n);
        }
        return null;
    }

    public static Object bsearch(Comparable[] comparableArray, Object object) {
        if (comparableArray == null || object == null) {
            return null;
        }
        return Alg.find(comparableArray, object);
    }

    public static Object bsearch(Vector vector, Object object, Comparator comparator) {
        if (vector == null || object == null) {
            return null;
        }
        return Alg.find(vector, object, comparator);
    }

    public static long getGreatestCommonDivisor(long l, long l2) {
        l = Math.abs(l);
        l2 = Math.abs(l2);
        if (l == 0L) {
            return l2;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = l;
        long l4 = l2;
        while (true) {
            if (l3 > l4) {
                l3 -= l4;
                continue;
            }
            if (l3 >= l4) break;
            l4 -= l3;
        }
        return l3;
    }

    public static long getLeastCommonMultiple(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        return Math.abs(l * l2) / Alg.getGreatestCommonDivisor(l, l2);
    }

    public static double getCorrelationT(double d, int n) {
        if (n == 0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d * Math.sqrt((double)n / (1.0 - d * d));
    }

    public static double getStudentP(double d, int n) {
        if (n <= 0) {
            return 0.5;
        }
        int n2 = (n - 1) * 7;
        if (n2 >= studentT.length) {
            n2 = studentT.length - 7;
        }
        while (n2 >= 0 && studentT[n2] > (float)n) {
            n2 -= 7;
        }
        int n3 = n2 + 7;
        ++n2;
        while (n2 < n3) {
            if (d < (double)studentT[n2]) {
                int n4 = n2 - n3 + 6;
                if (n4 <= 0) {
                    return 0.5;
                }
                float f = studentP[n4];
                if (f <= 0.001f) {
                    return f;
                }
                float f2 = studentP[n2 - n3 + 7];
                return (double)f - (double)(f - f2) * (d - (double)studentT[n2 - 1]) / (double)(studentT[n2] - studentT[n2 - 1]);
            }
            ++n2;
        }
        return 1.0E-5f;
    }

    public static double getStudentT(double d, int n) {
        if (BEasService.log.isTraceOn()) {
            BEasService.log.trace("Alg: getStudentT(p=" + d + ", v=" + n);
        }
        if (d > 0.5) {
            return 0.0;
        }
        if (n <= 0) {
            return 0.0;
        }
        int n2 = (n - 1) * 7;
        if (n2 >= studentT.length) {
            n2 = studentT.length - 7;
        }
        while (n2 >= 0 && studentT[n2] > (float)n) {
            n2 -= 7;
        }
        if (d <= (double)studentP[studentP.length - 2]) {
            return studentT[n2 + studentP.length - 2];
        }
        for (int i = 1; i <= studentP.length - 2; ++i) {
            if (!(d > (double)studentP[i])) continue;
            int n3 = n2 + i;
            float f = studentT[n3];
            if (i == 1) {
                return f;
            }
            float f2 = studentT[n3 - 1];
            return (double)f2 - (double)(f2 - f) * ((double)studentP[i - 1] - d) / (double)(studentP[i - 1] - studentP[i]);
        }
        return Double.NaN;
    }
}

