/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.UnitTreeComboBox;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnitWidget
extends JPanel
implements ActionListener {
    private ArrayList listeners;
    private String actionCommand;
    private UnitTreeComboBox treeCombo;
    private UnitComboBox unitCombo;
    private CardLayout cards = new CardLayout();
    private boolean constrained = false;
    private JPanel panel;
    private JLabel label;
    private CardLayout panelLayout;

    public UnitWidget(ResourceManager resourceManager) {
        super(false);
        this.setLayout(this.cards);
        this.treeCombo = new UnitTreeComboBox(resourceManager, false);
        this.treeCombo.addActionListener(this);
        this.add("tree", this.treeCombo);
        this.unitCombo = new UnitComboBox();
        this.unitCombo.addActionListener(this);
        this.add("combo", this.unitCombo);
        this.cards.show(this, "tree");
        this.listeners = new ArrayList();
        this.actionCommand = this.toString();
    }

    public UnitWidget(ResourceManager resourceManager, Lexicon lexicon) {
        super(false);
        this.setLayout(this.cards);
        this.treeCombo = new UnitTreeComboBox(resourceManager, false, lexicon);
        this.treeCombo.addActionListener(this);
        this.add("tree", this.treeCombo);
        this.unitCombo = new UnitComboBox(lexicon);
        this.unitCombo.addActionListener(this);
        this.add("combo", this.unitCombo);
        this.cards.show(this, "tree");
        this.listeners = new ArrayList();
        this.actionCommand = this.toString();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private void fireActionEvent() {
        this.fireActionEvent(new ActionEvent(this, 0, this.actionCommand));
    }

    private void fireActionEvent(ActionEvent actionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.constrained && actionEvent.getSource() == this.treeCombo) {
            this.unitCombo.setSelectedUnit(this.treeCombo.getSelectedUnit());
            this.fireActionEvent();
        } else if (this.constrained && actionEvent.getSource() == this.unitCombo) {
            this.treeCombo.setSelectedItem(this.unitCombo.getSelectedUnit());
            this.fireActionEvent();
        }
        if (this.label != null) {
            this.label.setText(this.getSelectedUnit() == null ? "" : this.getSelectedUnit().toString());
        }
    }

    public void setMeasure(UnitDatabase.Quantity quantity) {
        if (quantity != null) {
            this.constrained = true;
            BUnit bUnit = this.getSelectedUnit();
            this.unitCombo.setMeasure(quantity);
            this.treeCombo.setSelectedItem(this.unitCombo.getSelectedItem());
            this.cards.show(this, "combo");
        }
    }

    public UnitDatabase.Quantity getMeasure() {
        if (this.constrained) {
            return this.unitCombo.getMeasure();
        }
        return null;
    }

    public void setUnits(BUnit[] bUnitArray) {
        if (bUnitArray != null) {
            this.constrained = true;
            this.unitCombo.setUnits(bUnitArray);
            this.treeCombo.setSelectedItem(this.unitCombo.getSelectedItem());
            this.cards.show(this, "combo");
        }
    }

    public void setSelectedUnit(BUnit bUnit) {
        this.treeCombo.setSelectedItem(bUnit);
        this.unitCombo.setSelectedUnit(bUnit);
    }

    public UnitDatabase.Quantity getSelectedMeasure() {
        if (this.constrained) {
            return this.unitCombo.getMeasure();
        }
        return this.treeCombo.getSelectedMeasure();
    }

    public BUnit getSelectedUnit() {
        if (this.constrained) {
            return this.unitCombo.getSelectedUnit();
        }
        return (BUnit)this.treeCombo.getSelectedItem();
    }

    public void removeConstraints() {
        this.constrained = false;
        this.cards.show(this, "tree");
        this.setMeasure(null);
    }

    public JPanel getPanel() {
        this.panelLayout = new CardLayout();
        this.panel = new JPanel(this.panelLayout, false);
        this.panel.add("enabled", this);
        this.label = new JLabel();
        if (this.getSelectedUnit() != null) {
            this.label.setText(this.getSelectedUnit().toString());
        }
        this.panel.add("disabled", this.label);
        return this.panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.panel != null) {
            this.panelLayout.show(this.panel, bl ? "enabled" : "disabled");
        }
    }
}

