/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.TreeComboBox;
import com.tridium.eas.ui.widgets.TreeComboBoxRenderer;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class UnitTreeComboBox
extends TreeComboBox {
    public UnitTreeComboBox(ResourceManager resourceManager, boolean bl) {
        super(resourceManager);
        DefaultMutableTreeNode defaultMutableTreeNode = bl ? new DefaultMutableTreeNode("Type") : new DefaultMutableTreeNode("Unit");
        UnitDatabase.Quantity[] quantityArray = UnitDatabase.getDefault().getQuantities();
        for (int i = 0; i < quantityArray.length; ++i) {
            UnitDatabase.Quantity quantity = quantityArray[i];
            BUnit[] bUnitArray = quantity.getUnits();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(quantity);
            if (bUnitArray != null && bUnitArray.length > 0) {
                for (int j = 0; j < bUnitArray.length; ++j) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(bUnitArray[j]));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            if (!bl) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.setTree(new JTree(defaultMutableTreeNode));
    }

    public UnitTreeComboBox(ResourceManager resourceManager, boolean bl, Lexicon lexicon) {
        super(resourceManager, lexicon);
        DefaultMutableTreeNode defaultMutableTreeNode = bl ? new DefaultMutableTreeNode("Type") : new DefaultMutableTreeNode("Unit");
        UnitDatabase.Quantity[] quantityArray = UnitDatabase.getDefault().getQuantities();
        for (int i = 0; i < quantityArray.length; ++i) {
            UnitDatabase.Quantity quantity = quantityArray[i];
            BUnit[] bUnitArray = quantity.getUnits();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(quantity);
            if (bUnitArray != null && bUnitArray.length > 0) {
                for (int j = 0; j < bUnitArray.length; ++j) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(bUnitArray[j]));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue;
            }
            if (!bl) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setCellRenderer(new TreeComboBoxRenderer(jTree.getCellRenderer(), lexicon));
        this.setTree(jTree);
    }

    public BUnit getSelectedUnit() {
        if (this.getSelectedItem() instanceof BUnit) {
            return (BUnit)this.getSelectedItem();
        }
        return null;
    }

    public UnitDatabase.Quantity getSelectedMeasure() {
        if (this.getSelectedItem() instanceof UnitDatabase.Quantity) {
            return (UnitDatabase.Quantity)this.getSelectedItem();
        }
        if (this.getSelectedItem() instanceof BUnit) {
            return UnitDatabase.getDefault().getQuantity((BUnit)this.getSelectedItem());
        }
        return null;
    }

    protected String getLabelText() {
        if (this.lex != null) {
            return this.getSelectedItem() == null ? "" : this.lex.getText(this.getSelectedItem().toString());
        }
        return this.getSelectedItem() == null ? "" : this.getSelectedItem().toString();
    }
}

