/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.tree.TreePath;

public class TreeNodeIterator
implements Iterator {
    protected Enumeration childEnum = null;
    protected TreeNodeIterator currentChildIterator = null;
    protected FilterTreeNode nextNode = null;
    protected boolean nextWasChecked = false;

    public TreeNodeIterator(FilterTreeModel filterTreeModel) {
        this((FilterTreeNode)filterTreeModel.getRoot());
    }

    public TreeNodeIterator(FilterTreeNode filterTreeNode) {
        this.nextNode = filterTreeNode;
        this.childEnum = null;
        this.currentChildIterator = null;
        this.nextWasChecked = false;
    }

    public boolean hasNext() {
        this.nextWasChecked = true;
        while (true) {
            if (this.currentChildIterator == null) {
                if (this.childEnum == null) {
                    if (this.nextNode == null) {
                        return false;
                    }
                    this.childEnum = this.nextNode.children();
                    return true;
                }
                if (this.childEnum.hasMoreElements()) {
                    this.currentChildIterator = new TreeNodeIterator((FilterTreeNode)this.childEnum.nextElement());
                    continue;
                }
                this.childEnum = null;
                this.nextNode = null;
                return false;
            }
            if (this.currentChildIterator.hasNext()) {
                this.nextNode = (FilterTreeNode)this.currentChildIterator.next();
                return true;
            }
            this.currentChildIterator = null;
        }
    }

    public Object next() {
        if (!this.nextWasChecked && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextWasChecked = false;
        if (this.nextNode == null) {
            throw new NoSuchElementException();
        }
        return this.nextNode;
    }

    public FilterTreeNode nextTreeNode() {
        return (FilterTreeNode)this.next();
    }

    public TreePath nextTreePath() {
        return this.nextTreeNode().getPath();
    }

    public void remove() {
    }
}

