/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.TreeComboBox;
import java.awt.Component;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TreeComboBoxTableEditor
implements TableCellEditor {
    private TreeComboBox treeComboBox = null;
    private Vector cellEditorListeners = null;

    public TreeComboBoxTableEditor(TreeComboBox treeComboBox) {
        this.treeComboBox = treeComboBox;
        this.cellEditorListeners = new Vector();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.treeComboBox.setSelectedItem(object);
        return this.treeComboBox;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorListeners.add(cellEditorListener);
    }

    public Object getCellEditorValue() {
        return this.treeComboBox.getSelectedItem();
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.treeComboBox.setPopupVisible(false);
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.treeComboBox.setPopupVisible(false);
        this.fireEditingCanceled();
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorListeners.remove(cellEditorListener);
    }

    public void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.cellEditorListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((CellEditorListener)enumeration.nextElement()).editingStopped(changeEvent);
        }
    }

    public void fireEditingCanceled() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.cellEditorListeners.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingStopped(changeEvent);
        }
    }
}

