/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.TreeComboBoxRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.util.Lexicon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeComboBox
extends JComponent {
    private JTree tree = null;
    private JLabel label = null;
    private JButton button = null;
    private JWindow popup = null;
    private int maximumRowCount = 10;
    private String actionCommand = null;
    private ArrayList actionListeners = null;
    protected boolean processFocusEvent = true;
    protected Lexicon lex;

    public TreeComboBox(ResourceManager resourceManager, TreeNode treeNode) {
        this(resourceManager, new DefaultTreeModel(treeNode));
    }

    public TreeComboBox(ResourceManager resourceManager, TreeNode treeNode, boolean bl) {
        this(resourceManager, new DefaultTreeModel(treeNode, bl));
    }

    public TreeComboBox(ResourceManager resourceManager) {
        this(resourceManager, new JTree());
    }

    public TreeComboBox(ResourceManager resourceManager, Lexicon lexicon) {
        this(resourceManager, new JTree(), lexicon);
    }

    public TreeComboBox(ResourceManager resourceManager, Vector vector) {
        this(resourceManager, new JTree(vector));
    }

    public TreeComboBox(ResourceManager resourceManager, TreeModel treeModel) {
        this(resourceManager, new JTree(treeModel));
    }

    public TreeComboBox(ResourceManager resourceManager, JTree jTree) {
        this.actionListeners = new ArrayList();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BasicBorders.getTextFieldBorder());
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBackground(Color.white);
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreeComboBox.this.togglePopupVisible();
            }
        });
        this.add((Component)this.label, "Center");
        Image image = resourceManager.loadImage("/com/tridium/eas/ui/images/downArrow.png");
        this.button = new JButton(new ImageIcon(image));
        this.button.setFocusPainted(false);
        this.button.setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
        this.button.setMaximumSize(this.button.getPreferredSize());
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeComboBox.this.togglePopupVisible();
            }
        });
        this.add((Component)this.button, "East");
        this.setTree(jTree);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void componentShown(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                TreeComboBox.this.setPopupBounds();
            }
        });
    }

    public TreeComboBox(ResourceManager resourceManager, JTree jTree, Lexicon lexicon) {
        this.lex = lexicon;
        jTree.setCellRenderer(new TreeComboBoxRenderer(jTree.getCellRenderer(), lexicon));
        this.actionListeners = new ArrayList();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BasicBorders.getTextFieldBorder());
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBackground(Color.white);
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreeComboBox.this.togglePopupVisible();
            }
        });
        this.add((Component)this.label, "Center");
        Image image = resourceManager.loadImage("/com/tridium/eas/ui/images/downArrow.png");
        this.button = new JButton(new ImageIcon(image));
        this.button.setFocusPainted(false);
        this.button.setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
        this.button.setMaximumSize(this.button.getPreferredSize());
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeComboBox.this.togglePopupVisible();
            }
        });
        this.add((Component)this.button, "East");
        this.setTree(jTree);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void componentShown(ComponentEvent componentEvent) {
                TreeComboBox.this.setPopupBounds();
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                TreeComboBox.this.setPopupBounds();
            }

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                TreeComboBox.this.setPopupBounds();
            }
        });
    }

    public void setPopupBounds() {
        try {
            Point point = this.getLocationOnScreen();
            Rectangle rectangle = this.getBounds();
            this.getPopup().setBounds(point.x, point.y + rectangle.height, rectangle.width, this.tree.getRowHeight() * this.getMaximumRowCount());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
        jTree.setSelectionModel(new DefaultTreeSelectionModel(){

            public void setSelectionPaths(TreePath[] treePathArray) {
                if (treePathArray.length == 0) {
                    super.setSelectionPaths(treePathArray);
                } else {
                    TreeNode treeNode = (TreeNode)treePathArray[0].getLastPathComponent();
                    if (treeNode.isLeaf()) {
                        super.setSelectionPaths(new TreePath[]{treePathArray[0]});
                    }
                }
            }

            public void setSelectionPath(TreePath treePath) {
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode.isLeaf()) {
                    super.setSelectionPath(treePath);
                }
            }
        });
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreeComboBox.this.fireActionEvent();
                TreeComboBox.this.label.setText(TreeComboBox.this.getLabelText());
                TreeComboBox.this.hidePopup();
            }
        });
        if (this.getPopup() != null) {
            this.getPopup().getContentPane().add(new JScrollPane(jTree));
        }
        this.label.setPreferredSize(new Dimension(jTree.getPreferredSize().width + this.button.getPreferredSize().width, this.label.getPreferredSize().height));
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setMaximumRowCount(int n) {
        this.maximumRowCount = n;
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setPopupVisible(boolean bl) {
        if (this.getPopup() != null) {
            if (bl) {
                this.setPopupBounds();
                TreePath treePath = this.tree.getSelectionPath();
                this.collapseAll();
                if (treePath != null) {
                    this.tree.setSelectionPath(treePath);
                }
            }
            this.getPopup().setVisible(bl);
        }
    }

    public void togglePopupVisible() {
        if (this.getPopup() != null) {
            this.setPopupVisible(!this.getPopup().isVisible());
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public boolean isPopupVisible() {
        return this.getPopup() != null && this.getPopup().isVisible();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionEvent() {
        this.fireActionEvent(new ActionEvent(this, 0, this.actionCommand));
    }

    private void fireActionEvent(ActionEvent actionEvent) {
        Iterator iterator = this.actionListeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public Object getSelectedItem() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
    }

    public void setSelectedItem(Object object) {
        TreePath treePath = this.getUserObjectTreePath((TreeNode)this.getTree().getModel().getRoot(), object);
        if (treePath != null) {
            this.getTree().getSelectionModel().setSelectionPath(treePath);
            this.label.setText(this.getLabelText());
        }
    }

    protected String getLabelText() {
        return this.getSelectedItem() == null ? "" : this.getSelectedItem().toString();
    }

    public void collapseAll() {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getTree().getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isRoot()) continue;
            this.getTree().collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public void expandPath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        TreePath treePath2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            treePath2 = i == 0 ? new TreePath(objectArray[i]) : treePath2.pathByAddingChild(objectArray[i]);
            this.getTree().expandPath(treePath2);
        }
    }

    protected TreePath getUserObjectTreePath(Object object) {
        return this.getUserObjectTreePath(new TreePath(this.getTree().getModel().getRoot()), object);
    }

    private TreePath getUserObjectTreePath(TreeNode treeNode, Object object) {
        return this.getUserObjectTreePath(new TreePath(treeNode), object);
    }

    private String nodeToString(TreeNode treeNode) {
        if (treeNode == null) {
            return "Null Node";
        }
        if (treeNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)treeNode).getUserObject().toString();
        }
        return treeNode.toString();
    }

    protected TreePath getUserObjectTreePath(TreePath treePath, Object object) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeNode).getUserObject().equals(object)) {
            return treePath;
        }
        if (treeNode.getChildCount() == 0) {
            return null;
        }
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = this.getUserObjectTreePath(treePath.pathByAddingChild(enumeration.nextElement()), object);
            if (treePath2 == null) continue;
            return treePath2;
        }
        return null;
    }

    protected JWindow getPopup() {
        if (this.popup == null && this.isDisplayable()) {
            this.popup = new JWindow(this.getParentWindow(this));
            this.popup.getContentPane().add(new JScrollPane(this.tree));
            this.popup.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (TreeComboBox.this.processFocusEvent) {
                        TreeComboBox.this.setPopupVisible(false);
                    }
                }
            });
            this.setPopupBounds();
        }
        return this.popup;
    }

    protected Window getParentWindow(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return this.getParentWindow(component.getParent());
    }
}

