/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.UnitComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TemperatureEditor
extends JComponent {
    private NumberTextField degreeField = new NumberTextField(3);
    private UnitComboBox unitChoice;
    private boolean editable = true;

    public TemperatureEditor() {
        BUnit bUnit = BUnit.getUnit((String)"fahrenheit");
        this.unitChoice = new UnitComboBox(UnitDatabase.getDefault().getQuantity(bUnit));
        this.unitChoice.setSelectedUnit(bUnit);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.degreeField);
        this.add(this.unitChoice);
    }

    public TemperatureEditor(Lexicon lexicon) {
        BUnit bUnit = BUnit.getUnit((String)"fahrenheit");
        this.unitChoice = new UnitComboBox(UnitDatabase.getDefault().getQuantity(bUnit), lexicon);
        this.unitChoice.setSelectedUnit(bUnit);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.degreeField);
        this.add(this.unitChoice);
    }

    public TemperatureEditor(int n, BUnit bUnit) {
        this();
        this.setValue(n);
        this.setUnit(bUnit);
    }

    public TemperatureEditor(int n, BUnit bUnit, Lexicon lexicon) {
        this(lexicon);
        this.setValue(n);
        this.setUnit(bUnit);
    }

    public void setValue(double d) {
        this.degreeField.setText(d);
    }

    public double getValue() {
        return this.degreeField.getDoubleValue();
    }

    public void setUnit(BUnit bUnit) {
        BUnit bUnit2 = BUnit.getUnit((String)"fahrenheit");
        if (!UnitDatabase.getDefault().getQuantity(bUnit).getName().equals(UnitDatabase.getDefault().getQuantity(bUnit2).getName())) {
            throw new IllegalArgumentException("Unit must be a temperature.");
        }
        this.unitChoice.setSelectedUnit(bUnit);
    }

    public BUnit getUnit() {
        return this.unitChoice.getSelectedUnit();
    }

    public void setEditable(boolean bl) {
        if (bl == this.editable) {
            return;
        }
        this.editable = bl;
        this.degreeField.setEditable(this.editable);
        this.unitChoice.setEnabled(this.editable);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.degreeField.getPreferredSize();
        Dimension dimension2 = this.unitChoice.getPreferredSize();
        n = dimension.width + dimension2.width + 1;
        n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    public void doLayout() {
        int n = 0;
        Dimension dimension = this.degreeField.getPreferredSize();
        Dimension dimension2 = this.unitChoice.getPreferredSize();
        n = Math.max(dimension.height, dimension2.height);
        this.degreeField.setBounds(0, 0, dimension.width, n);
        this.unitChoice.setBounds(dimension.width + 1, 0, dimension2.width, n);
    }

    public static void main(String[] stringArray) {
        TemperatureEditor temperatureEditor = new TemperatureEditor();
        JFrame jFrame = new JFrame();
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)temperatureEditor, "Center");
        jFrame.setBounds(200, 200, 200, 150);
        jFrame.setVisible(true);
    }
}

