/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.EasTextField;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberTextField
extends EasTextField {
    private boolean integerOnly = false;
    private boolean allowNegative = true;
    private DecimalFormat formatter;

    public NumberTextField() {
        this(false);
    }

    public NumberTextField(boolean bl) {
        this.integerOnly = bl;
        this.formatter = new DecimalFormat();
    }

    public NumberTextField(int n, int n2) {
        this(n, n2, false);
    }

    public NumberTextField(int n, int n2, boolean bl) {
        super(n, n2);
        this.formatter = new DecimalFormat();
        this.integerOnly = bl;
    }

    public NumberTextField(int n) {
        this(n, false);
    }

    public NumberTextField(int n, boolean bl) {
        super(n);
        this.formatter = new DecimalFormat();
        this.integerOnly = bl;
    }

    public void setMaximumFractionDigits(int n) {
        this.formatter.setMaximumFractionDigits(n);
    }

    public int getMaximumFractionDigits() {
        return this.formatter.getMaximumFractionDigits();
    }

    public void setFormatter(DecimalFormat decimalFormat) {
        this.formatter = decimalFormat;
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    public boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean bl) {
        this.allowNegative = bl;
    }

    public float getFloatValue() {
        String string = this.getText();
        if (string.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public double getDoubleValue() {
        String string = this.getText();
        if (string.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public int getIntValue() {
        return (int)this.getFloatValue();
    }

    public void setText(int n) {
        super.setText(this.formatter.format(n));
    }

    public void setText(float f) {
        super.setText(this.formatter.format(f));
    }

    public void setText(double d) {
        super.setText(this.formatter.format(d));
    }

    public void setText(long l) {
        super.setText(this.formatter.format(l));
    }

    public void setText(String string) {
        try {
            this.setText(this.formatter.parse(string).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    private class NumberDocument
    extends PlainDocument {
        private int maxLength;

        private NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || NumberTextField.this.getMaxLength() >= 0 && NumberTextField.this.getText().length() + string.length() >= NumberTextField.this.getMaxLength()) {
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            String string2 = NumberTextField.this.getText();
            boolean bl = string2.indexOf(NumberTextField.this.formatter.getDecimalFormatSymbols().getDecimalSeparator()) != -1;
            boolean bl2 = string2.indexOf(NumberTextField.this.formatter.getDecimalFormatSymbols().getMinusSign()) != -1;
            DecimalFormatSymbols decimalFormatSymbols = NumberTextField.this.formatter.getDecimalFormatSymbols();
            for (int i = 0; i < cArray2.length; ++i) {
                if (!Character.isDigit(cArray[i]) && (n2 + n <= 0 || NumberTextField.this.integerOnly || bl || cArray[i] != decimalFormatSymbols.getDecimalSeparator()) && (n + n2 != 0 || cArray[i] != decimalFormatSymbols.getMinusSign() || !NumberTextField.this.allowNegative || bl2)) continue;
                cArray2[n2++] = cArray[i];
                if (cArray[i] == decimalFormatSymbols.getDecimalSeparator()) {
                    bl = true;
                }
                if (cArray[i] != decimalFormatSymbols.getMinusSign()) continue;
                bl2 = true;
            }
            if (NumberTextField.this.getMaxLength() < 0 || NumberTextField.this.getText().length() + n2 <= NumberTextField.this.getMaxLength()) {
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }
}

