/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.baja.util.Lexicon;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class IntervalEditor
extends JComponent
implements MouseListener,
ActionListener,
FocusListener,
KeyListener {
    private static final int INIT_DELAY = 3;
    private IntervalField intervalField;
    private JButton upButton;
    private JButton downButton;
    private JButton activeButton;
    private Timer timer;
    private int pulseDelay = 0;
    private Vector listeners;
    private Lexicon lex = null;

    public IntervalEditor(boolean bl) {
        this(bl, 0L);
    }

    public IntervalEditor(long l) {
        this(false, l);
    }

    public IntervalEditor() {
        this(false, 0L);
    }

    public IntervalEditor(Lexicon lexicon) {
        this(false, 0L);
        this.lex = lexicon;
    }

    public IntervalEditor(boolean bl, long l) {
        this.intervalField = new IntervalField(bl, l);
        this.add(this.intervalField);
        this.upButton = new JButton(new ArrowIcon(4, 3, true));
        this.upButton.addMouseListener(this);
        this.upButton.addFocusListener(this);
        this.upButton.addKeyListener(this);
        this.add(this.upButton);
        this.downButton = new JButton(new ArrowIcon(4, 3, false));
        this.downButton.addMouseListener(this);
        this.downButton.addFocusListener(this);
        this.downButton.addKeyListener(this);
        this.add(this.downButton);
    }

    public long getValue() {
        return this.intervalField.getValue();
    }

    public void setValue(long l) {
        this.intervalField.setValue(l);
    }

    public void setStep(long l) {
        this.intervalField.setStep(l);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(actionListener);
    }

    void fireActionEvent() {
        if (this.listeners == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(actionEvent);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.intervalField.getPreferredSize();
        int n = dimension.width + dimension.height;
        int n2 = dimension.height;
        return new Dimension(n, n2);
    }

    public void doLayout() {
        Dimension dimension = this.intervalField.getPreferredSize();
        this.intervalField.setBounds(0, 0, dimension.width, dimension.height);
        int n = dimension.height / 2;
        int n2 = dimension.height;
        this.upButton.setBounds(dimension.width, 0, n2, n);
        this.downButton.setBounds(dimension.width, n, n2, n);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.intervalField.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.intervalField.repaint();
    }

    public boolean containsFocus() {
        return this.intervalField.hasFocus() || this.upButton.hasFocus() || this.downButton.hasFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (this.timer == null) {
            this.timer = new Timer(50, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
        }
        if ((object = mouseEvent.getSource()) == this.upButton) {
            this.intervalField.incrementSelection();
            this.activeButton = this.upButton;
            this.pulseDelay = 3;
            this.timer.start();
        } else if (object == this.downButton) {
            this.intervalField.decrementSelection();
            this.activeButton = this.downButton;
            this.pulseDelay = 3;
            this.timer.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.activeButton = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            if (this.pulseDelay != 0) {
                --this.pulseDelay;
                return;
            }
            if (this.activeButton == this.upButton) {
                this.intervalField.incrementSelection();
            } else if (this.activeButton == this.downButton) {
                this.intervalField.decrementSelection();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            Object object;
            if (this.timer == null) {
                this.timer = new Timer(50, this);
                this.timer.setRepeats(true);
                this.timer.setCoalesce(true);
            }
            if ((object = keyEvent.getSource()) == this.upButton) {
                this.intervalField.incrementSelection();
                this.activeButton = this.upButton;
                this.pulseDelay = 3;
                this.timer.start();
            } else if (object == this.downButton) {
                this.intervalField.decrementSelection();
                this.activeButton = this.downButton;
                this.pulseDelay = 3;
                this.timer.start();
            }
        } else {
            this.intervalField.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.activeButton != null) {
            this.activeButton = null;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public class IntervalField
    extends JComponent
    implements KeyListener,
    FocusListener,
    MouseListener {
        private boolean showSign;
        private int sign;
        private int day;
        private int hour;
        private int minute;
        private int thisSign;
        private int thisDay;
        private int thisHour;
        private int thisMinute;
        private Font font;
        private FontMetrics fm;
        private int digitWidth;
        private Border border;
        private Insets borderInsets;
        private Color fg;
        private Color bg;
        private Color selFg;
        private Color selBg;
        private int baseline;
        private int[] fieldLocs;
        private int[] fieldWidths;
        private int fieldHeight;
        private long step = 0L;
        private static final long DAY_MILLIS = 86400000L;
        private static final long HOUR_MILLIS = 3600000L;
        private static final long MINUTE_MILLIS = 60000L;
        private static final int MARGIN = 2;
        private static final int SIGN = 0;
        private static final int DAY = 1;
        private static final int HOUR = 2;
        private static final int MINUTE = 3;
        private int selection = -1;

        public IntervalField(boolean bl, long l) {
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addMouseListener(this);
            this.showSign = bl;
            this.step = l;
            this.setValue(0L);
        }

        public void setStep(long l) {
            this.step = l;
            if (l != 0L) {
                this.setValue(this.getValue() - this.getValue() % l);
            }
        }

        public long getValue() {
            return (long)this.sign * (86400000L * (long)this.day + 3600000L * (long)this.hour + 60000L * (long)this.minute);
        }

        public void setValue(long l) {
            long l2 = l;
            if (this.step != 0L) {
                l2 -= l2 % this.step;
            }
            this.sign = l >= 0L ? 1 : -1;
            this.day = (int)((l2 /= (long)this.sign) / 86400000L);
            this.hour = (int)((l2 %= 86400000L) / 3600000L);
            this.minute = (int)((l2 %= 3600000L) / 60000L);
            this.repaint();
        }

        public void setFont(Font font) {
            this.font = font;
            this.fm = null;
        }

        private void updateUiData() {
            if (this.fm == null) {
                if (this.font == null) {
                    this.font = new Font(Theme.widget().getLargeFont().getName(), 0, 10);
                }
                this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
                this.border = UIManager.getBorder("TextField.border");
                this.borderInsets = this.border.getBorderInsets(this);
                this.setBorder(this.border);
                this.fg = UIManager.getColor("TextField.foreground");
                this.bg = UIManager.getColor("TextField.background");
                this.selFg = UIManager.getColor("TextField.selectionForeground");
                this.selBg = UIManager.getColor("TextField.selectionBackground");
                this.digitWidth = this.fm.stringWidth("0");
            }
        }

        public Dimension getPreferredSize() {
            this.updateUiData();
            int n = 0;
            int n2 = 0;
            n = IntervalEditor.this.lex != null ? this.fm.stringWidth("+00" + IntervalEditor.this.lex.getText("d") + " 00" + IntervalEditor.this.lex.getText("h") + " 00" + IntervalEditor.this.lex.getText("mo")) + 4 + this.borderInsets.left + this.borderInsets.right : this.fm.stringWidth("+00d 00h 00m") + 4 + this.borderInsets.left + this.borderInsets.right;
            n2 = this.fm.getAscent() + 4 + this.borderInsets.top + this.borderInsets.bottom;
            if (n2 % 2 != 0) {
                ++n2;
            }
            return new Dimension(n, n2);
        }

        public void doLayout() {
            this.updateUiData();
            this.baseline = this.fm.getAscent() + this.borderInsets.top;
            if (this.fieldLocs == null) {
                this.layoutFields();
            }
        }

        private void layoutFields() {
            this.fieldHeight = this.getHeight() - this.borderInsets.top - this.borderInsets.bottom;
            this.fieldWidths = new int[4];
            this.fieldWidths[0] = this.fm.stringWidth("-");
            this.fieldWidths[1] = this.fm.stringWidth("00");
            this.fieldWidths[2] = this.fm.stringWidth("00");
            this.fieldWidths[3] = this.fm.stringWidth("00");
            int n = this.fm.stringWidth(" ");
            this.fieldLocs = new int[4];
            this.fieldLocs[0] = this.border.getBorderInsets((Component)this).left;
            this.fieldLocs[1] = this.fieldLocs[0] + this.fieldWidths[0] + n;
            if (IntervalEditor.this.lex != null) {
                this.fieldLocs[2] = this.fieldLocs[1] + this.fieldWidths[1] + this.fm.stringWidth(IntervalEditor.this.lex.getText("d")) + n;
                this.fieldLocs[3] = this.fieldLocs[2] + this.fieldWidths[2] + this.fm.stringWidth(IntervalEditor.this.lex.getText("h")) + n;
            } else {
                this.fieldLocs[2] = this.fieldLocs[1] + this.fieldWidths[1] + this.fm.stringWidth("d") + n;
                this.fieldLocs[3] = this.fieldLocs[2] + this.fieldWidths[2] + this.fm.stringWidth("h") + n;
            }
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.bg);
            graphics.fillRect(0, 0, n, n2);
            graphics.setFont(this.font);
            int n3 = 0;
            if (IntervalEditor.this.containsFocus() && this.selection == 0) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[0] - 1, this.borderInsets.top, this.fieldWidths[0] + 3, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            if (this.sign < 0) {
                graphics.drawString("-", this.fieldLocs[0], this.baseline);
            } else if (this.showSign) {
                graphics.drawString("+", this.fieldLocs[0], this.baseline);
            } else {
                graphics.setColor(this.selFg);
                graphics.fillRect(this.fieldLocs[0] - 1, this.borderInsets.top, this.fieldWidths[0] + 3, this.fieldHeight - 1);
            }
            if (IntervalEditor.this.containsFocus() && this.selection == 1) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[1] - 1, this.borderInsets.top, this.fieldWidths[1] + 2, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            n3 = this.day < 10 ? this.digitWidth : 0;
            graphics.drawString(Integer.toString(this.day), this.fieldLocs[1] + n3, this.baseline);
            graphics.setColor(this.fg);
            if (IntervalEditor.this.lex != null) {
                graphics.drawString(IntervalEditor.this.lex.getText("d"), this.fieldLocs[1] + this.fieldWidths[1], this.baseline);
            } else {
                graphics.drawString("d", this.fieldLocs[1] + this.fieldWidths[1], this.baseline);
            }
            if (IntervalEditor.this.containsFocus() && this.selection == 2) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[2] - 1, this.borderInsets.top, this.fieldWidths[1] + 2, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            n3 = this.hour < 10 ? this.digitWidth : 0;
            graphics.drawString(Integer.toString(this.hour), this.fieldLocs[2] + n3, this.baseline);
            graphics.setColor(this.fg);
            if (IntervalEditor.this.lex != null) {
                graphics.drawString(IntervalEditor.this.lex.getText("h"), this.fieldLocs[2] + this.fieldWidths[2], this.baseline);
            } else {
                graphics.drawString("h", this.fieldLocs[2] + this.fieldWidths[2], this.baseline);
            }
            if (IntervalEditor.this.containsFocus() && this.selection == 3) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[3] - 1, this.borderInsets.top, this.fieldWidths[3] + 2, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            n3 = this.minute < 10 ? this.digitWidth : 0;
            graphics.drawString(Integer.toString(this.minute), this.fieldLocs[3] + n3, this.baseline);
            graphics.setColor(this.fg);
            if (IntervalEditor.this.lex != null) {
                graphics.drawString(IntervalEditor.this.lex.getText("mo"), this.fieldLocs[3] + this.fieldWidths[3], this.baseline);
            } else {
                graphics.drawString("m", this.fieldLocs[3] + this.fieldWidths[3], this.baseline);
            }
        }

        public void incrementSelection() {
            if (this.selection == -1) {
                this.selection = 3;
                this.repaint();
                return;
            }
            if (this.selection == 0 && this.showSign) {
                this.sign *= -1;
            } else if (this.step == 0L) {
                if (this.selection == 1) {
                    ++this.day;
                    if (this.day > 99) {
                        this.day = 0;
                    }
                } else if (this.selection == 2) {
                    ++this.hour;
                    if (this.hour > 23) {
                        this.hour = 0;
                    }
                } else if (this.selection == 3) {
                    ++this.minute;
                    if (this.minute > 59) {
                        this.minute = 0;
                    }
                }
            } else {
                long l = 0L;
                if (this.selection == 1 && this.step < 86400000L) {
                    l = 86400000L - 86400000L % this.step;
                } else if (this.selection == 2 && this.step < 3600000L) {
                    l = 3600000L - 3600000L % this.step;
                } else if (this.selection != 0) {
                    l = this.step;
                }
                this.setValue(this.getValue() + l);
            }
            this.repaint();
            IntervalEditor.this.fireActionEvent();
        }

        public void decrementSelection() {
            if (this.selection == -1) {
                this.selection = 3;
                this.repaint();
                return;
            }
            if (this.selection == 0 && this.showSign) {
                this.sign *= -1;
            } else if (this.step == 0L) {
                if (this.selection == 1) {
                    --this.day;
                    if (this.day == -1) {
                        this.day = 0;
                    }
                } else if (this.selection == 2) {
                    --this.hour;
                    if (this.hour == -1) {
                        this.hour = 23;
                    }
                } else if (this.selection == 3) {
                    --this.minute;
                    if (this.minute == -1) {
                        this.minute = 59;
                    }
                }
            } else {
                long l = 0L;
                if (this.selection == 1 && this.step < 86400000L) {
                    l = 86400000L - 86400000L % this.step;
                } else if (this.selection == 2 && this.step < 3600000L) {
                    l = 3600000L - 3600000L % this.step;
                } else if (this.selection != 0) {
                    l = this.step;
                }
                this.setValue(this.getValue() - l);
            }
            this.repaint();
            IntervalEditor.this.fireActionEvent();
        }

        public void modifySelection(char c) {
            if (this.selection == -1 || this.step != 0L) {
                return;
            }
            if (this.showSign && c == '-') {
                this.sign = -1;
            } else if (this.showSign && c == '+') {
                this.sign = 1;
            } else if (Character.isDigit(c)) {
                if (this.selection == 0) {
                    return;
                }
                if (this.selection == 1) {
                    int n = this.day * 10 + c - 48;
                    if (n > 99) {
                        n = c - 48;
                    }
                    if (n >= 0) {
                        this.day = n;
                    }
                    this.repaint();
                    IntervalEditor.this.fireActionEvent();
                } else if (this.selection == 2) {
                    int n = this.hour * 10 + c - 48;
                    if (n > 23) {
                        n = c - 48;
                    }
                    if (n >= 0) {
                        this.hour = n;
                    }
                    this.repaint();
                    IntervalEditor.this.fireActionEvent();
                } else if (this.selection == 3) {
                    int n = this.minute * 10 + c - 48;
                    if (n > 59) {
                        n = c - 48;
                    }
                    if (n >= 0) {
                        this.minute = n;
                    }
                    this.repaint();
                    IntervalEditor.this.fireActionEvent();
                }
            }
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.selection == -1) {
                this.selection = 3;
            }
            this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaint();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    this.incrementSelection();
                    break;
                }
                case 40: {
                    this.decrementSelection();
                    break;
                }
                case 39: {
                    this.selection = this.selection == -1 ? 0 : (this.selection + 1) % 4;
                    this.repaint();
                    break;
                }
                case 37: {
                    if (this.selection == -1) {
                        this.selection = 0;
                    } else {
                        --this.selection;
                        if (this.selection < 0) {
                            this.selection = 3;
                        }
                    }
                    this.repaint();
                    break;
                }
                default: {
                    this.modifySelection(keyEvent.getKeyChar());
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            int n = mouseEvent.getX();
            for (int i = 0; i < 4; ++i) {
                if (n < this.fieldLocs[i] || n >= this.fieldLocs[i] + this.fieldWidths[i]) continue;
                if (this.showSign || !this.showSign && i != 0) {
                    this.selection = i;
                }
                this.repaint();
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    public class ArrowIcon
    implements Icon {
        private boolean up = true;
        private int width;
        private int height;

        public ArrowIcon(boolean bl) {
            this(3, 2, bl);
        }

        public ArrowIcon(int n, int n2, boolean bl) {
            this.width = n;
            this.height = n2;
            this.up = bl;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getForeground());
            if (this.up) {
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n + 2, n2 + 1);
            } else {
                graphics.drawLine(n, n2, n + 2, n2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            }
        }
    }
}

