/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.ui.widgets.DataPointTreeNode;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.DynamicGroupTreeNode;
import com.tridium.eas.ui.widgets.GroupTreeNode;
import com.tridium.eas.ui.widgets.MeterTreeNode;
import com.tridium.eas.ui.widgets.NullSelectionUserObject;
import com.tridium.eas.ui.widgets.SiteTreeNode;
import com.tridium.eas.ui.widgets.TreeNodeComparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class FilterTreeNode
implements TreeNode {
    private FilterTreeNode parent;
    private Object target;
    private DbObjectValidator validator;
    private TreePath path;
    public static final TreeNode[] NO_CHILDREN = new TreeNode[0];

    public FilterTreeNode(Object object, FilterTreeNode filterTreeNode) {
        this(object, filterTreeNode, null);
    }

    protected FilterTreeNode(Object object, FilterTreeNode filterTreeNode, DbObjectValidator dbObjectValidator) {
        this.target = object;
        this.parent = filterTreeNode;
        this.validator = dbObjectValidator;
        this.path = filterTreeNode == null ? new TreePath(this) : filterTreeNode.getPath().pathByAddingChild(this);
    }

    public Object getUserObject() {
        return this.target;
    }

    public boolean isChildAllowed(Object object) {
        if (object == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        return this.validator.allowLoadUserObject(object.getClass()) && this.validator.allowShowUserObject(object);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreePath getPath() {
        return this.path;
    }

    public abstract String getNodeText();

    protected abstract TreeNode[] getChildren();

    public abstract boolean isLoaded();

    public abstract void reload();

    public String toString() {
        return this.getNodeText();
    }

    public Enumeration children() {
        return new ArrayEnumerator(this.getChildren());
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return this.getChildren()[n];
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public int getIndex(TreeNode treeNode) {
        TreeNode[] treeNodeArray = this.getChildren();
        int n = treeNodeArray.length;
        for (int i = 0; i < n; ++i) {
            if (treeNodeArray[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return false;
    }

    protected DbObjectValidator getValidator() {
        return this.validator;
    }

    protected TreeNode[] createChildren(Object[] objectArray) {
        TreeSet<TreeNode> treeSet = new TreeSet<TreeNode>(new TreeNodeComparator());
        int n = objectArray == null ? 0 : objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null || !this.isChildAllowed(objectArray[i])) continue;
            treeSet.add(FilterTreeNode.create(objectArray[i], this, this.validator));
        }
        TreeNode[] treeNodeArray = new TreeNode[treeSet.size()];
        treeSet.toArray(treeNodeArray);
        return treeNodeArray;
    }

    public int addChild(Object object) {
        return -1;
    }

    public int removeChild(TreeNode treeNode) {
        return -1;
    }

    public static TreeNode create(Object object, FilterTreeNode filterTreeNode, DbObjectValidator dbObjectValidator) {
        FilterTreeNode filterTreeNode2 = null;
        filterTreeNode2 = object instanceof Site ? new SiteTreeNode((Site)object, filterTreeNode, dbObjectValidator) : (object instanceof Meter ? new MeterTreeNode((Meter)object, filterTreeNode, dbObjectValidator) : (object instanceof DataPoint ? new DataPointTreeNode((DataPoint)object, filterTreeNode, dbObjectValidator) : (object instanceof DynGroup ? new DynamicGroupTreeNode((DynGroup)object, filterTreeNode, dbObjectValidator) : (object instanceof StaticGroup ? new GroupTreeNode((Group)object, filterTreeNode, dbObjectValidator) : (object instanceof NullSelectionUserObject ? ((NullSelectionUserObject)object).createTreeNode(filterTreeNode) : null)))));
        return filterTreeNode2;
    }

    static class ArrayEnumerator
    implements Enumeration {
        private int index;
        private int arraySize;
        private Object[] array;

        public ArrayEnumerator(Object[] objectArray) {
            this.array = objectArray;
            this.arraySize = objectArray == null ? 0 : objectArray.length;
            this.index = 0;
        }

        public boolean hasMoreElements() {
            return this.index < this.arraySize;
        }

        public Object nextElement() {
            if (this.index == this.arraySize) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }
    }
}

