/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasTreeCellRenderer;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.FilterTreePopupHandler;
import com.tridium.eas.ui.widgets.MatchingUserObjectTreeNodeIterator;
import com.tridium.eas.ui.widgets.TextTransferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilterTree
extends JTree
implements MouseListener,
DragGestureListener,
DragSourceListener,
EasDataListener {
    private FilterTreePopupHandler popupHandler;
    private DragSource dragSource;

    public FilterTree(ResourceManager resourceManager) {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new EasTreeCellRenderer(resourceManager));
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(this);
    }

    public FilterTreeModel getFilterTreeModel() {
        return this.getModel() instanceof FilterTreeModel ? (FilterTreeModel)this.getModel() : null;
    }

    public void setPopupHandler(FilterTreePopupHandler filterTreePopupHandler) {
        this.popupHandler = filterTreePopupHandler;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = (mouseEvent.getModifiers() & 4) != 0;
        boolean bl2 = mouseEvent.isControlDown();
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            this.clearSelection();
            return;
        }
        if (bl) {
            if (bl2) {
                this.addSelectionPath(treePath);
            } else {
                this.setSelectionPath(treePath);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        if (this.popupHandler == null) {
            return;
        }
        boolean bl2 = bl = (mouseEvent.getModifiers() & 4) != 0;
        if (!bl) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        this.popupHandler.openPopup(this, treePath == null ? null : (FilterTreeNode)treePath.getLastPathComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return;
        }
        FilterTreeNode filterTreeNode = (FilterTreeNode)treePath.getLastPathComponent();
        System.out.println("dragGestureRecognized: " + filterTreeNode.getNodeText());
        dragGestureEvent.startDrag(null, new TextTransferable(filterTreeNode.getNodeText()), this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        System.out.println("dropDropEnd: " + dragSourceDropEvent.getDragSourceContext().getComponent());
        System.out.println("  success: " + dragSourceDropEvent.getDropSuccess());
        int n = dragSourceDropEvent.getDropAction();
        if (n == 1) {
            System.out.println("  action : Copy");
        } else if (n == 2) {
            System.out.println("  action : Move");
        } else {
            System.out.println("  action: " + n);
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("dragEnter: " + dragSourceDragEvent.getDragSourceContext().getComponent());
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        System.out.println("dragExit: " + dragSourceEvent.getDragSourceContext().getComponent());
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("dragOver: " + dragSourceDragEvent.getDragSourceContext().getComponent());
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("dropActionChanged: " + dragSourceDragEvent.getDragSourceContext().getComponent());
    }

    public void refreshUserObject(Object object) {
        this.getFilterTreeModel().refreshData(object);
    }

    public void revalidateUserObject(Object object) {
        try {
            if (object instanceof DataPoint) {
                this.getFilterTreeModel().refreshData(((DataPoint)object).getLinkedGroups());
                this.getFilterTreeModel().refreshData(((DataPoint)object).getMeter());
                if (((DataPoint)object).getSite() != null) {
                    this.getFilterTreeModel().refreshData(((DataPoint)object).getSite());
                }
            } else if (object instanceof Meter) {
                this.getFilterTreeModel().refreshData(((Meter)object).getSite());
            } else if (object instanceof Group) {
                this.getFilterTreeModel().refreshData(((Group)object).getParents());
            }
            this.getFilterTreeModel().refreshData(object);
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (this.getFilterTreeModel() == null) {
            return;
        }
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            this.getFilterTreeModel().refreshData(objectArray[i]);
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        if (this.getFilterTreeModel() == null) {
            return;
        }
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            this.revalidateUserObject(objectArray[i]);
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        if (this.getFilterTreeModel() == null) {
            return;
        }
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            this.getFilterTreeModel().removeData(objectArray[i]);
        }
    }

    public Object getSelectedUserObject() {
        FilterTreeNode filterTreeNode = (FilterTreeNode)this.getLastSelectedPathComponent();
        return filterTreeNode == null ? null : filterTreeNode.getUserObject();
    }

    public boolean isSelected(Class clazz) {
        Object object = this.getSelectedUserObject();
        return object != null && clazz.isAssignableFrom(object.getClass());
    }

    public Object[] getSelectedUserObjects() {
        TreePath[] treePathArray = this.getSelectionPaths();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                FilterTreeNode filterTreeNode = (FilterTreeNode)treePathArray[i].getLastPathComponent();
                if (arrayList.contains(filterTreeNode.getUserObject())) continue;
                arrayList.add(filterTreeNode.getUserObject());
            }
        }
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public void setSelectedUserObject(Object object) {
        if (object == null) {
            this.clearSelection();
        } else {
            boolean bl = true;
            MatchingUserObjectTreeNodeIterator matchingUserObjectTreeNodeIterator = new MatchingUserObjectTreeNodeIterator(object, this);
            while (matchingUserObjectTreeNodeIterator.hasNext()) {
                TreePath treePath = matchingUserObjectTreeNodeIterator.nextTreePath();
                this.expandFullPath(treePath);
                if (bl) {
                    bl = false;
                    this.setSelectionPath(treePath);
                    continue;
                }
                this.addSelectionPath(treePath);
            }
        }
    }

    public void setSelectedUserObjects(Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            this.clearSelection();
        } else {
            boolean bl = true;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null) continue;
                MatchingUserObjectTreeNodeIterator matchingUserObjectTreeNodeIterator = new MatchingUserObjectTreeNodeIterator(object, this);
                while (matchingUserObjectTreeNodeIterator.hasNext()) {
                    TreePath treePath = matchingUserObjectTreeNodeIterator.nextTreePath();
                    this.expandFullPath(treePath);
                    if (bl) {
                        bl = false;
                        this.setSelectionPath(treePath);
                        continue;
                    }
                    this.addSelectionPath(treePath);
                }
            }
            if (bl) {
                this.clearSelection();
            }
        }
    }

    public void expandFullPath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        TreePath treePath2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            treePath2 = i == 0 ? new TreePath(objectArray[i]) : treePath2.pathByAddingChild(objectArray[i]);
            Object object = ((FilterTreeNode)objectArray[i]).getUserObject();
            this.setExpandedState(treePath2, true);
        }
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                FilterTree.this.expandPath(treeModelEvent.getTreePath());
            }
        });
    }
}

