/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import java.awt.Color;
import java.security.AccessControlException;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class EasTextField
extends JTextField {
    private boolean useLabelAppearanceWhenDisabled = false;
    private Color defaultDisabledTextColor = this.getDisabledTextColor();
    private Color enabledBackground = this.getBackground();
    private Border enabledBorder = this.getBorder();
    private Color disabledBackground = null;
    private int maxLength = -1;

    public EasTextField() {
        this.maxLength = -1;
    }

    public EasTextField(int n) {
        this(n, -1);
    }

    public EasTextField(int n, int n2) {
        super(n);
        this.maxLength = n2;
    }

    public void setUseLabelAppearanceWhenDisabled(boolean bl) {
        this.useLabelAppearanceWhenDisabled = bl;
        if (bl) {
            this.setDisabledTextColor(Color.darkGray);
            this.disabledBackground = UIManager.getColor("Label.background");
        } else {
            this.setDisabledTextColor(this.defaultDisabledTextColor);
            this.disabledBackground = this.enabledBackground;
        }
        this.setEnabled(this.isEnabled());
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.setBorder(this.enabledBorder);
            this.setBackground(this.enabledBackground);
        } else {
            this.setBorder(null);
            this.setBackground(this.disabledBackground);
        }
        super.setEnabled(bl);
    }

    public boolean useLabelAppearanceWhenDisabled() {
        return this.useLabelAppearanceWhenDisabled();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    protected Document createDefaultModel() {
        return new FixedSizeDocument();
    }

    public void paste() {
        try {
            super.paste();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private class FixedSizeDocument
    extends PlainDocument {
        private FixedSizeDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || EasTextField.this.getMaxLength() < 0 || EasTextField.this.getText().length() + string.length() <= EasTextField.this.getMaxLength()) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

