/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.Group;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import javax.swing.tree.TreeNode;

public class DynamicGroupTreeNode
extends FilterTreeNode {
    private DynGroup group;
    private TreeNode[] children;

    public DynamicGroupTreeNode(DynGroup dynGroup, FilterTreeNode filterTreeNode, DbObjectValidator dbObjectValidator) {
        super(dynGroup, filterTreeNode, dbObjectValidator);
        this.group = dynGroup;
    }

    public String getNodeText() {
        return this.group.getName();
    }

    protected TreeNode[] getChildren() {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.children;
    }

    public void reload() {
        this.loadChildren();
    }

    public void loadChildren() {
        try {
            Group[] groupArray = this.group.getSubIDs();
            if (groupArray == null || groupArray.length == 0) {
                groupArray = this.group.getChildren();
            }
            this.children = this.createChildren(groupArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.children = new FilterTreeNode[0];
        }
    }

    public boolean isLoaded() {
        return this.children != null;
    }
}

