/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.CheckMarkIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckList
extends JComponent
implements ComponentListener,
ListSelectionListener {
    private JList list;
    private CheckListSelectionModel selModel;
    private Icon selectedIcon;
    private Icon deselectedIcon;
    private Vector listeners;
    private boolean noEvents = false;

    public CheckList() {
        this.list = new JList();
        this.common();
    }

    public CheckList(ListModel listModel) {
        this.list = new JList(listModel);
        this.common();
    }

    public CheckList(Object[] objectArray) {
        this.list = new JList<Object>(objectArray);
        this.common();
    }

    public CheckList(Vector vector) {
        this.list = new JList(vector);
        this.common();
    }

    private void common() {
        this.addComponentListener(this);
        this.selectedIcon = new CheckMarkIcon(Color.red, true);
        this.deselectedIcon = new DefaultDeselectedIcon(this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
        this.list.setCellRenderer(new CheckListCellRenderer());
        this.selModel = new CheckListSelectionModel();
        this.list.addMouseListener(this.selModel);
        this.list.setSelectionModel(this.selModel);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        this.list.setEnabled(bl);
        super.setEnabled(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 10, dimension.height);
    }

    public void setOpaque(boolean bl) {
        this.list.setOpaque(bl);
    }

    public boolean isOpaque() {
        return this.list.isOpaque();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
        if (this.deselectedIcon instanceof DefaultDeselectedIcon) {
            this.deselectedIcon = new DefaultDeselectedIcon(this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
        }
    }

    public Icon getDeselectedIcon() {
        return this.deselectedIcon;
    }

    public void setDeselectedIcon(Icon icon) {
        this.deselectedIcon = icon;
    }

    public boolean isSelected(int n) {
        return this.list.isSelectedIndex(n);
    }

    public void setSelected(int n, boolean bl) {
        if (bl) {
            this.list.addSelectionInterval(n, n);
        } else {
            this.list.removeSelectionInterval(n, n);
        }
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public void setListData(Object[] objectArray) {
        this.list.setListData(objectArray);
        this.list.revalidate();
    }

    public void setSelectedIndices(int[] nArray) {
        this.list.setSelectedIndices(nArray);
        this.list.revalidate();
    }

    public void setSelectedValues(Vector vector) {
        this.list.clearSelection();
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            for (int j = 0; j < n; ++j) {
                Object e2 = listModel.getElementAt(j);
                if (!e.equals(e2)) continue;
                this.setSelected(j, true);
            }
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        this.list.clearSelection();
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                for (int j = 0; j < n; ++j) {
                    Object e = listModel.getElementAt(j);
                    if (!object.equals(e)) continue;
                    this.setSelected(j, true);
                }
            }
        }
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public int[] getSelectedIndices() {
        return this.list.getSelectedIndices();
    }

    public int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    public int getFirstVisibleIndex() {
        return this.list.getFirstVisibleIndex();
    }

    public int getLastVisibleIndex() {
        return this.list.getLastVisibleIndex();
    }

    public void setVisibleRowCount(int n) {
        this.list.setVisibleRowCount(n);
    }

    public void ensureIndexIsVisible(int n) {
        this.list.ensureIndexIsVisible(n);
    }

    public void setNoEvents(boolean bl) {
        this.noEvents = bl;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(2, 2);
            this.list.addListSelectionListener(this);
        }
        this.listeners.addElement(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listSelectionListener);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.noEvents || this.listeners == null) {
            return;
        }
        if (listSelectionEvent.getSource() == this.list) {
            ListSelectionEvent listSelectionEvent2 = new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), false);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ListSelectionListener)this.listeners.elementAt(i)).valueChanged(listSelectionEvent2);
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.list.revalidate();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    private class CheckListSelectionModel
    extends DefaultListSelectionModel
    implements MouseListener {
        private boolean mouseDown = false;
        private boolean wasAdjusting = false;

        public void setSelectionInterval(int n, int n2) {
            if (this.mouseDown) {
                return;
            }
            if (n == n2 && this.isSelectedIndex(n)) {
                this.removeSelectionInterval(n, n);
                return;
            }
            super.addSelectionInterval(n, n2);
        }

        public void setAnchorSelectionIndex(int n) {
        }

        public void setLeadSelectionIndex(int n) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseDown = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseDown = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class DefaultDeselectedIcon
    implements Icon {
        private int width;
        private int height;

        public DefaultDeselectedIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    protected class CheckListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setIcon(CheckList.this.selectedIcon);
            } else {
                this.setIcon(CheckList.this.deselectedIcon);
            }
            this.setText(object.toString());
            return this;
        }
    }
}

