/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports.admin;

import com.tridium.eas.api.ReportUtil;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.reports.admin.ReconciliationNode;
import com.tridium.eas.ui.reports.admin.ReconciliationPopup;
import com.tridium.eas.ui.reports.admin.ReconciliationTemplateNode;
import com.tridium.eas.ui.reports.admin.ReconciliationTemplatePopup;
import com.tridium.eas.ui.reports.admin.ReportDetailPanel;
import com.tridium.eas.ui.reports.admin.ReportNode;
import com.tridium.eas.ui.reports.admin.ReportPopup;
import com.tridium.eas.ui.reports.admin.ReportTemplateNode;
import com.tridium.eas.ui.reports.admin.ReportTemplatePopup;
import com.tridium.eas.ui.reports.admin.ReportTreeCellRenderer;
import com.tridium.eas.ui.reports.admin.ReportTreeModel;
import com.tridium.eas.ui.reports.admin.ReportTreeNode;
import com.tridium.eas.ui.widgets.EasButton;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.baja.util.Lexicon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReportAdmin
extends EasApplication
implements MouseListener,
TreeSelectionListener {
    private JTree reportTree;
    private ReportTreeModel treeModel;
    private JSplitPane split;
    private ReportDetailPanel detailPanel;
    private ReportPopup reportPopup;
    private ReportTemplatePopup templatePopup;
    private ReconciliationPopup reconciliationPopup;
    private ReconciliationTemplatePopup reconciliationTemplatePopup;
    private JButton deleteButton;

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("reportAdministration");
    }

    public String getId() {
        return "reportAdmin";
    }

    public final void initApplication(boolean bl) {
    }

    protected JComponent getApplicationToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.deleteButton = new EasButton(new ImageIcon(this.loadImage("/com/tridium/eas/ui/images/delete.png")));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this);
        jToolBar.add(this.deleteButton);
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        this.split = new JSplitPane();
        this.reportTree = new JTree();
        this.reportTree.setCellRenderer(new ReportTreeCellRenderer(this));
        this.reportTree.setShowsRootHandles(true);
        this.reportTree.getSelectionModel().setSelectionMode(1);
        this.reportTree.addMouseListener(this);
        this.reportTree.addTreeSelectionListener(this);
        this.split.setLeftComponent(new JScrollPane(this.reportTree));
        this.detailPanel = new ReportDetailPanel(this);
        this.split.setRightComponent(this.detailPanel);
        return this.split;
    }

    protected void startApplication() {
        this.treeModel = new ReportTreeModel(this);
        this.reportTree.setModel(this.treeModel);
        this.split.setDividerLocation(0.3);
    }

    protected void buttonPressed(JButton jButton) {
        if (jButton == this.deleteButton) {
            ReconciliationNode reconciliationNode;
            TreePath treePath = this.reportTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            ReportTreeNode reportTreeNode = (ReportTreeNode)treePath.getLastPathComponent();
            if (reportTreeNode instanceof ReportNode) {
                ReportNode reportNode = (ReportNode)reportTreeNode;
                if (this.deleteReport(reportNode.getId(), reportNode.getName(), reportNode.isPublic(), true)) {
                    this.treeModel.remove(reportTreeNode);
                }
            } else if (reportTreeNode instanceof ReconciliationNode && this.deleteReconciliation(reconciliationNode = (ReconciliationNode)reportTreeNode, true)) {
                this.treeModel.remove(reportTreeNode);
            }
        } else {
            super.buttonPressed(jButton);
        }
    }

    public boolean deleteReport(String string, String string2, boolean bl, boolean bl2) {
        String string3;
        int n;
        Lexicon lexicon = BEasApplet.lex;
        if (bl2 && (n = JOptionPane.showConfirmDialog(this, string3 = lexicon.getText("deleteWarning") + "\n\"" + string2 + "\"?", lexicon.getText("confirmDelete"), 0)) != 0) {
            return false;
        }
        string3 = this.getSession().getUserName();
        if (bl && !this.getSession().hasAdminWrite()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("/eas/reportCommand/delete?reportId=");
        stringBuffer.append(string);
        stringBuffer.append("&reportName=");
        stringBuffer.append(ReportUtil.reportNameToUrlParameter(string2));
        stringBuffer.append("&public=");
        stringBuffer.append(bl);
        String string4 = null;
        try {
            string4 = this.getSession().getText(stringBuffer.toString());
            if (!string4.equals("OK")) {
                string4 = lexicon.getText("reportNotDeleted") + ".\n" + string4;
                JOptionPane.showMessageDialog(this, string4, lexicon.getText("deleteSavedReport"), 0);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, lexicon.getText("reportNotDeleted") + ".", lexicon.getText("deleteSavedReport"), 0);
            return false;
        }
    }

    public boolean deleteReconciliation(ReconciliationNode reconciliationNode, boolean bl) {
        String string;
        int n;
        Lexicon lexicon = BEasApplet.lex;
        if (bl && (n = JOptionPane.showConfirmDialog(this, string = lexicon.getText("deleteWarning") + "\n\"" + reconciliationNode.getName() + "\"?", lexicon.getText("confirmDelete"), 0)) != 0) {
            return false;
        }
        if (!this.getSession().hasAdminWrite()) {
            return false;
        }
        try {
            if (EasCostClient.deleteReconciliationReport(reconciliationNode.getSession(), reconciliationNode.getMeterId(), reconciliationNode.getBillCycle())) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JOptionPane.showMessageDialog(this, lexicon.getText("reportNotDeleted") + ".", lexicon.getText("deleteSavedReport"), 0);
        return false;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.reportTree.getSelectionPath();
        if (treePath == null) {
            this.detailPanel.clear();
        } else {
            ReportTreeNode reportTreeNode = (ReportTreeNode)treePath.getLastPathComponent();
            if (reportTreeNode instanceof ReportNode) {
                ReportNode reportNode = (ReportNode)reportTreeNode;
                boolean bl = !reportNode.isPublic() || this.getSession().hasAdminWrite();
                this.deleteButton.setEnabled(bl);
                this.detailPanel.displayDetails(reportNode.getId(), reportNode.getName(), reportNode.isPublic());
            } else if (reportTreeNode instanceof ReconciliationNode) {
                ReconciliationNode reconciliationNode = (ReconciliationNode)reportTreeNode;
                boolean bl = this.getSession().hasAdminWrite();
                this.deleteButton.setEnabled(bl);
                this.detailPanel.displayDetails(reconciliationNode.getId(), reconciliationNode.getName(), reconciliationNode.getMeterName());
            } else {
                this.deleteButton.setEnabled(false);
                this.detailPanel.clear();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath;
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiers() & 4) != 0;
        if (mouseEvent.getClickCount() == 2 && !bl) {
            treePath = this.reportTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode instanceof ReportNode) {
                ReportNode reportNode = (ReportNode)treeNode;
                reportNode.go(this);
            } else if (treeNode instanceof ReconciliationTemplateNode) {
                ReconciliationTemplateNode reconciliationTemplateNode = (ReconciliationTemplateNode)treeNode;
                reconciliationTemplateNode.go(this);
            }
        }
        if ((treePath = this.reportTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) == null) {
            this.reportTree.clearSelection();
            return;
        }
        if (bl) {
            this.reportTree.setSelectionPath(treePath);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiers() & 4) != 0;
        if (bl) {
            TreePath treePath = this.reportTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode instanceof ReportNode) {
                ReportNode reportNode = (ReportNode)treeNode;
                if (this.reportPopup == null) {
                    this.reportPopup = new ReportPopup(this, this.treeModel);
                }
                this.reportPopup.arm(reportNode);
                this.reportPopup.show(this.reportTree, mouseEvent.getX(), mouseEvent.getY());
            } else if (treeNode instanceof ReportTemplateNode) {
                ReportTemplateNode reportTemplateNode = (ReportTemplateNode)treeNode;
                if (!reportTemplateNode.isSegregated()) {
                    return;
                }
                if (this.templatePopup == null) {
                    this.templatePopup = new ReportTemplatePopup(this);
                }
                this.templatePopup.arm(reportTemplateNode);
                this.templatePopup.show(this.reportTree, mouseEvent.getX(), mouseEvent.getY());
            } else if (treeNode instanceof ReconciliationNode) {
                ReconciliationNode reconciliationNode = (ReconciliationNode)treeNode;
                if (this.reconciliationPopup == null) {
                    this.reconciliationPopup = new ReconciliationPopup(this, this.treeModel);
                }
                this.reconciliationPopup.arm(reconciliationNode);
                this.reconciliationPopup.show(this.reportTree, mouseEvent.getX(), mouseEvent.getY());
            } else if (treeNode instanceof ReconciliationTemplateNode) {
                ReconciliationTemplateNode reconciliationTemplateNode = (ReconciliationTemplateNode)treeNode;
                if (!reconciliationTemplateNode.isSegregated()) {
                    return;
                }
                if (this.reconciliationTemplatePopup == null) {
                    this.reconciliationTemplatePopup = new ReconciliationTemplatePopup(this);
                }
                this.reconciliationTemplatePopup.arm(reconciliationTemplateNode);
                this.reconciliationTemplatePopup.show(this.reportTree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        UIManager.getDefaults().put("ComboBox.disabledBackground", UIManager.getColor("ComboBox.background"));
        UIManager.getDefaults().put("ComboBox.disabledForeground", UIManager.getColor("ComboBox.foreground"));
    }
}

