/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.FuncDataSummary;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.reports.SpectrumSummaryParameters;
import java.awt.Color;
import javax.baja.units.BUnit;

public class SpectrumSummarySeries
extends TimeSeries {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private ReportInput input;
    private SpectrumSummaryParameters params;
    private TSDataSummary result;
    private double[] range;
    private long[] tsRange;

    public SpectrumSummarySeries(ReportInput reportInput, SpectrumSummaryParameters spectrumSummaryParameters) {
        this.input = reportInput;
        this.params = spectrumSummaryParameters;
    }

    public void load() {
        ReportPeriod reportPeriod = this.params.getPeriod();
        int n = this.input.getInputItemCount();
        DataPoint[] dataPointArray = new DataPoint[n];
        for (int i = 0; i < n; ++i) {
            SiteDataPoint siteDataPoint = (SiteDataPoint)this.input.getInputItem(i);
            dataPointArray[i] = siteDataPoint.getDataPoint();
        }
        try {
            this.result = FuncDataSummary.getResult(dataPointArray, this.input.getUnit(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), 127, 0, new TimeInterval(15L, 3), false, null, false, 0.0, null, this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), this.input.hasNormalizingPoint(), this.input.getNormalizingPoint());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSeriesName() {
        return null;
    }

    public long getTimestamp(int n) {
        return this.result.getLocalTime(n);
    }

    public int getRowCount() {
        return this.result.getSize();
    }

    public String getValueName(int n) {
        return this.input.getName();
    }

    public int getValueType() {
        return 0;
    }

    public double getValue(int n, int n2) {
        return this.result.getDataSummary(n).getTotalConsumption();
    }

    public boolean isValid(int n, int n2) {
        return this.result.getDataSummary(n).isValid();
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public double getMin(int n) {
        return this.getMin();
    }

    public double getMax(int n) {
        return this.getMax();
    }

    public double getMin() {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[0];
    }

    public double getMax() {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[1];
    }

    private void computeRange() {
        this.range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        this.tsRange = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getValue(i, 0);
            long l = this.getTimestamp(i);
            this.range[0] = Math.min(this.range[0], d);
            this.range[1] = Math.max(this.range[1], d);
            this.tsRange[0] = Math.min(this.tsRange[0], l);
            this.tsRange[1] = Math.max(this.tsRange[1], l);
        }
    }

    public BUnit getValueUnits() {
        return this.result.getValueUnit();
    }
}

