/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.widgets.ValueColor;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.util.Lexicon;

public class SpectrumSummaryParameters
extends ReportParameters {
    private ValueColor low;
    private ValueColor middle;
    private ValueColor high;

    public SpectrumSummaryParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public SpectrumSummaryParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, ValueColor valueColor, ValueColor valueColor2, ValueColor valueColor3, Lexicon lexicon, boolean bl, int n, double d) {
        super(reportInputArray, reportPeriod, 0, lexicon, bl, n, d);
        this.low = valueColor;
        this.middle = valueColor2;
        this.high = valueColor3;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        ReportPeriod reportPeriod = reportParameters.getPeriod();
        this.setPeriod(new ReportPeriod(reportPeriod.getCustomPeriod(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), 127, this.lex));
        this.low = new ValueColor(Color.blue);
        this.middle = new ValueColor(Color.white);
        this.high = new ValueColor(Color.red);
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public ValueColor getLowValueColor() {
        return this.low;
    }

    public ValueColor getMiddleValueColor() {
        return this.middle;
    }

    public ValueColor getHighValueColor() {
        return this.high;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.low = new ValueColor();
        this.low.load(dataInput);
        this.middle = new ValueColor();
        this.middle.load(dataInput);
        this.high = new ValueColor();
        this.high.load(dataInput);
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        this.low.save(dataOutput);
        this.middle.save(dataOutput);
        this.high.save(dataOutput);
    }
}

