/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.reports.ReportInputItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class SiteInputItem
extends ReportInputItem {
    private Site site;
    private DataPoint mainElectricDataPoint;
    private DataPoint mainGasDataPoint;
    private DataPoint oaTempDataPoint;
    private boolean associatedDpLookup = false;
    private Lexicon lex;

    public SiteInputItem() {
    }

    public SiteInputItem(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public SiteInputItem(Site site, Lexicon lexicon) {
        this.site = site;
        this.lex = lexicon;
    }

    public int getType() {
        return 0;
    }

    public String getText() {
        return this.getSiteName();
    }

    public Site getSite() {
        return this.site;
    }

    protected void setSite(Site site) {
        this.site = site;
    }

    public double getFloorAreaValue() {
        return this.getSite().getProperty("floorarea").getDouble();
    }

    public BUnit getFloorAreaUnit() {
        return this.getSite().getProperty("floorarea").getUnitObject();
    }

    public String getSiteName() {
        return this.getSite().getName();
    }

    public DataPoint getMainGasDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainGasDataPoint;
    }

    public DataPoint getMainElectricDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainElectricDataPoint;
    }

    public DataPoint getOutdoorAirTempDataPoint() {
        this.setAssociatedDataPoints();
        return this.oaTempDataPoint;
    }

    private void setAssociatedDataPoints() {
        if (!this.associatedDpLookup) {
            this.associatedDpLookup = true;
            try {
                DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
                for (int i = 0; i < dataPointArray.length; ++i) {
                    if (dataPointArray[i].getRcType() == RcType.ELECTRIC.getCode()) {
                        this.mainElectricDataPoint = dataPointArray[i];
                        continue;
                    }
                    if (dataPointArray[i].getRcType() == RcType.GAS.getCode()) {
                        this.mainGasDataPoint = dataPointArray[i];
                        continue;
                    }
                    if (dataPointArray[i].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode()) continue;
                    this.oaTempDataPoint = dataPointArray[i];
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
                this.associatedDpLookup = false;
            }
        }
    }

    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.getSite().getId());
    }

    public boolean load(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        long l = dataInput.readLong();
        Site site = (Site)Group.get(l, easSession);
        site.load(false);
        this.setSite(site);
        if (site == null) {
            throw new EasException(this.lex.getText("deletedSite"));
        }
        return true;
    }
}

