/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.reports.SiteInputItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class SiteDataPoint
extends SiteInputItem {
    private DataPoint dataPoint;
    private String dpName;
    private DataPoint mainGasDataPoint;
    private DataPoint mainElectricDataPoint;
    private DataPoint oaTempDataPoint;
    private boolean associatedDpLookup = false;
    private Lexicon lex;

    public SiteDataPoint() {
    }

    public SiteDataPoint(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public SiteDataPoint(DataPoint dataPoint, Lexicon lexicon) throws EasException {
        this(dataPoint.getSite(), dataPoint, lexicon);
    }

    public SiteDataPoint(Site site, DataPoint dataPoint, Lexicon lexicon) {
        super(site, lexicon);
        this.dataPoint = dataPoint;
        this.lex = lexicon;
    }

    public Site getSite() {
        if (super.getSite() == null && this.dataPoint != null) {
            try {
                this.setSite(this.dataPoint.getSite());
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        return super.getSite();
    }

    public int getType() {
        return 1;
    }

    public String getText() {
        return this.getSiteName() + ": " + this.getDataPointName();
    }

    public String toString() {
        return this.getText();
    }

    public BUnit getUnit() {
        try {
            return this.dataPoint.getUnit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public DataPoint getDataPoint() {
        return this.dataPoint;
    }

    public String getDataPointName() {
        if (this.dpName == null) {
            try {
                this.dpName = this.dataPoint.getDescr();
                if (this.dataPoint.getMeter() != null) {
                    this.dpName = this.dataPoint.getMeter().getName() + ": " + this.dpName;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dpName = this.lex.getText("error");
            }
        }
        return this.dpName;
    }

    public DataPoint getMainGasDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainGasDataPoint;
    }

    public DataPoint getMainElectricDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainElectricDataPoint;
    }

    public DataPoint getOutdoorAirTempDataPoint() {
        this.setAssociatedDataPoints();
        return this.oaTempDataPoint;
    }

    public double getFloorAreaValue() {
        try {
            return this.getDataPoint().getFloorAreaValue();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return 0.0;
        }
    }

    public BUnit getFloorAreaUnit() {
        try {
            return this.getDataPoint().getFloorAreaUnit();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return null;
        }
    }

    private void setAssociatedDataPoints() {
        if (!this.associatedDpLookup) {
            this.associatedDpLookup = true;
            try {
                int n;
                DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
                for (n = 0; n < dataPointArray.length; ++n) {
                    if (!dataPointArray[n].isMain()) continue;
                    if (dataPointArray[n].getRcType() == RcType.ELECTRIC.getCode()) {
                        this.mainElectricDataPoint = dataPointArray[n];
                        continue;
                    }
                    if (dataPointArray[n].getRcType() == RcType.GAS.getCode()) {
                        this.mainGasDataPoint = dataPointArray[n];
                        continue;
                    }
                    if (dataPointArray[n].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode()) continue;
                    this.oaTempDataPoint = dataPointArray[n];
                }
                dataPointArray = this.getSite().getLinkedDataPoints();
                for (n = 0; n < dataPointArray.length; ++n) {
                    if (!dataPointArray[n].isMain()) continue;
                    if (dataPointArray[n].getRcType() == RcType.ELECTRIC.getCode()) {
                        this.mainElectricDataPoint = dataPointArray[n];
                        continue;
                    }
                    if (dataPointArray[n].getRcType() == RcType.GAS.getCode()) {
                        this.mainGasDataPoint = dataPointArray[n];
                        continue;
                    }
                    if (dataPointArray[n].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode()) continue;
                    this.oaTempDataPoint = dataPointArray[n];
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
                this.associatedDpLookup = false;
            }
        }
    }

    public void save(DataOutput dataOutput) throws IOException {
        super.save(dataOutput);
        dataOutput.writeLong(this.dataPoint.getId());
    }

    public boolean load(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        super.load(easSession, dataInput);
        long l = dataInput.readLong();
        this.dataPoint = DataPoint.get(l, easSession, false);
        this.dataPoint.load();
        if (this.dataPoint == null) {
            throw new EasException("Attempted To Load A Data Point Which Has Been Deleted");
        }
        return true;
    }
}

