/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.cost.ui.reports.contribution.CostContributionParameters;
import com.tridium.eas.cost.ui.reports.ranking.CostRankingParameters;
import com.tridium.eas.ui.reports.AggregationAnalysisParameters;
import com.tridium.eas.ui.reports.AvgProfileParameters;
import com.tridium.eas.ui.reports.CorrelationReportParameters;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EnterpriseRankingParameters;
import com.tridium.eas.ui.reports.EquipmentOperationParameters;
import com.tridium.eas.ui.reports.ExceptionReportParameters;
import com.tridium.eas.ui.reports.LoadDurationParameters;
import com.tridium.eas.ui.reports.PointTrendingParameters;
import com.tridium.eas.ui.reports.RelContributionParameters;
import com.tridium.eas.ui.reports.ReportConst;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.reports.SpectrumSummaryParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public abstract class ReportParameters
implements ReportConst {
    private static final int PARAMS_VERSION = -413;
    private static final int PARTITION_PARAMS_VERSION = -412;
    private static final int DATA_CLEANSE_PARAMS_VERSION = -411;
    private ReportInput[] inputs;
    private ReportPeriod period;
    private int normalization = 0;
    private boolean autoRun = false;
    private double normTemperature = 65.0;
    private BUnit normTemperatureUnit = BUnit.getUnit((String)"fahrenheit");
    public Lexicon lex;
    private boolean dataCleanse = false;
    private int dataCleanseWindow = 4;
    private double dataCleansePercentage = 100.0;

    public ReportParameters() {
    }

    public ReportParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, Lexicon lexicon, boolean bl, int n2, double d) {
        this(reportInputArray, reportPeriod, n, 65.0, BUnit.getUnit((String)"fahrenheit"), false, lexicon, bl, n2, d);
    }

    public ReportParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, boolean bl, Lexicon lexicon, boolean bl2, int n2, double d) {
        this(reportInputArray, reportPeriod, n, 65.0, BUnit.getUnit((String)"fahrenheit"), bl, lexicon, bl2, n2, d);
    }

    public ReportParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, double d, BUnit bUnit, boolean bl, Lexicon lexicon, boolean bl2, int n2, double d2) {
        this.inputs = reportInputArray;
        this.period = reportPeriod;
        this.normalization = n;
        this.autoRun = bl;
        this.normTemperature = d;
        this.normTemperatureUnit = bUnit;
        this.lex = lexicon;
        this.dataCleanse = bl2;
        this.dataCleanseWindow = n2;
        this.dataCleansePercentage = d2;
    }

    public ReportInput[] addInputs(EasReport easReport, ReportInput[] reportInputArray) {
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ReportInput reportInput = reportInputArray[i];
            int n3 = reportInput.getInputItemCount();
            boolean bl = true;
            for (int j = 0; j < n3; ++j) {
                DataPoint dataPoint;
                ReportInputItem reportInputItem = reportInput.getInputItem(j);
                if (!this.isCompatibleItemType(reportInputItem, easReport.getInputItemClass())) {
                    bl = false;
                    break;
                }
                if (!(reportInputItem instanceof SiteDataPoint) || easReport.allowDataPoint(dataPoint = ((SiteDataPoint)reportInputItem).getDataPoint())) continue;
                bl = false;
                break;
            }
            boolean bl2 = bl = bl && (n3 <= 1 || easReport.allowAggregation());
            if (!bl || n2 != 0 && !easReport.allowMultipleInputs()) continue;
            ++n2;
            easReport.addInput(reportInput, false);
        }
        return easReport.getInputList().getModel().getInputs();
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
    }

    public final boolean load(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        int n;
        int n2 = dataInput.readInt();
        ArrayList<ReportInput> arrayList = new ArrayList<ReportInput>();
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            ReportInput reportInput = new ReportInput(this.lex);
            try {
                bl = reportInput.load(easSession, dataInput) && bl;
                arrayList.add(reportInput);
                continue;
            }
            catch (EasException easException) {
                easException.printStackTrace();
                bl = false;
            }
        }
        this.inputs = new ReportInput[arrayList.size()];
        arrayList.toArray(this.inputs);
        this.period = new ReportPeriod(this.lex);
        this.period.load(dataInput);
        n = dataInput.readInt();
        boolean bl2 = n == -412;
        boolean bl3 = bl2 || n == -411 || n == -413;
        this.normalization = bl3 ? dataInput.readInt() : n;
        this.normTemperature = dataInput.readDouble();
        String string = dataInput.readUTF();
        this.normTemperatureUnit = BUnit.getUnit((String)string);
        this.autoRun = dataInput.readBoolean();
        if (bl3) {
            this.dataCleanse = dataInput.readBoolean();
            this.dataCleanseWindow = dataInput.readInt();
            this.dataCleansePercentage = dataInput.readDouble();
        }
        if (bl2) {
            dataInput.readLong();
        }
        bl = this.loadParams(easSession, dataInput) && bl;
        return bl;
    }

    protected abstract boolean loadParams(EasSession var1, DataInput var2) throws IOException, EasException;

    public final void save(DataOutput dataOutput) throws IOException {
        ArrayList<ReportInput> arrayList = new ArrayList<ReportInput>();
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                if (this.inputs[i].getAggregateParent() != null) continue;
                arrayList.add(this.inputs[i]);
            }
        }
        dataOutput.writeInt(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ReportInput)iterator.next()).save(dataOutput);
        }
        this.period.save(dataOutput);
        dataOutput.writeInt(-413);
        dataOutput.writeInt(this.normalization);
        dataOutput.writeDouble(this.normTemperature);
        dataOutput.writeUTF(this.normTemperatureUnit.getUnitName());
        dataOutput.writeBoolean(this.autoRun);
        dataOutput.writeBoolean(this.dataCleanse);
        dataOutput.writeInt(this.dataCleanseWindow);
        dataOutput.writeDouble(this.dataCleansePercentage);
        this.saveParams(dataOutput);
    }

    protected abstract void saveParams(DataOutput var1) throws IOException;

    public int getInputCount() {
        return this.inputs == null ? 0 : this.inputs.length;
    }

    public ReportInput[] getInputs() {
        return this.inputs;
    }

    public ReportPeriod getPeriod() {
        return this.period;
    }

    public int getNormalization() {
        return this.normalization;
    }

    public boolean isNormalizedByTemperature() {
        return (this.getNormalization() & 4) > 0;
    }

    public boolean isNormalizedByFloorArea() {
        return (this.getNormalization() & 2) > 0;
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public void setAutoRun(boolean bl) {
        this.autoRun = bl;
    }

    public double getNormalTemperature() {
        return this.normTemperature;
    }

    public void setNormalTemperature(double d) {
        this.normTemperature = d;
    }

    public BUnit getNormalTemperatureUnit() {
        return this.normTemperatureUnit;
    }

    public void setNormalTemperatureUnit(BUnit bUnit) {
        this.normTemperatureUnit = bUnit;
    }

    public boolean getDataCleanse() {
        return this.dataCleanse;
    }

    public void setDataCleanse(boolean bl) {
        this.dataCleanse = bl;
    }

    public int getDataCleanseWindow() {
        return this.dataCleanseWindow;
    }

    public void setDataCleanseWindow(int n) {
        this.dataCleanseWindow = n;
    }

    public double getDataCleansePercentage() {
        return this.dataCleansePercentage;
    }

    public void setDataCleansePercentage(double d) {
        this.dataCleansePercentage = d;
    }

    public boolean isCompatibleItemType(ReportInputItem reportInputItem, Class clazz) {
        return clazz.equals(reportInputItem.getClass());
    }

    protected void setPeriod(ReportPeriod reportPeriod) {
        this.period = reportPeriod;
    }

    protected void setInputs(ReportInput[] reportInputArray) {
        this.inputs = reportInputArray;
    }

    protected void setNormalization(int n) {
        this.normalization = n;
    }

    public static ReportParameters createParametersForId(String string, Lexicon lexicon) {
        if (string.equals("avgProfile")) {
            return new AvgProfileParameters(lexicon);
        }
        if (string.equals("entRanking")) {
            return new EnterpriseRankingParameters(lexicon);
        }
        if (string.equals("correlationReport")) {
            return new CorrelationReportParameters(lexicon);
        }
        if (string.equals("pointTrending")) {
            return new PointTrendingParameters(lexicon);
        }
        if (string.equals("exception")) {
            return new ExceptionReportParameters(lexicon);
        }
        if (string.equals("aggAnalysis")) {
            return new AggregationAnalysisParameters(lexicon);
        }
        if (string.equals("spectrum")) {
            return new SpectrumSummaryParameters(lexicon);
        }
        if (string.equals("relContribution")) {
            return new RelContributionParameters(lexicon);
        }
        if (string.equals("equipOp")) {
            return new EquipmentOperationParameters(lexicon);
        }
        if (string.equals("loadDuration")) {
            return new LoadDurationParameters(lexicon);
        }
        if (string.equals("costRank")) {
            return new CostRankingParameters(lexicon);
        }
        if (string.equals("costContribution")) {
            return new CostContributionParameters(lexicon);
        }
        return null;
    }
}

