/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SeriesLabel;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class ReportInput
implements SeriesLabel {
    private String name;
    protected String autoName;
    private BUnit unit;
    private ReportInputItem[] inputItems;
    private Color color;
    private DataPoint normalizer = null;
    private boolean disaggregated = false;
    private ReportInput aggregateParent;
    private boolean enabled = true;
    private Lexicon lex;
    private static final int VERSION = -2;

    public ReportInput(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public ReportInput(String string, BUnit bUnit, Lexicon lexicon) {
        this(string, bUnit, (ReportInputItem[])null, lexicon);
    }

    public ReportInput(String string, BUnit bUnit, ReportInputItem reportInputItem, Lexicon lexicon) {
        this(string, bUnit, new ReportInputItem[]{reportInputItem}, lexicon);
    }

    public ReportInput(String string, BUnit bUnit, ReportInputItem[] reportInputItemArray, Lexicon lexicon) {
        this.name = string;
        this.unit = bUnit;
        this.inputItems = reportInputItemArray;
        this.enabled = true;
        this.lex = lexicon;
    }

    public ReportInput getCopy() {
        ReportInput reportInput = new ReportInput(this.name, this.unit, this.inputItems, this.lex);
        reportInput.setColor(this.color);
        reportInput.setDisaggregated(this.disaggregated);
        reportInput.setAggregateParent(this.aggregateParent);
        reportInput.setEnabled(this.enabled);
        reportInput.autoName = this.autoName;
        reportInput.setNormalizingPoint(this.getNormalizingPoint());
        return reportInput;
    }

    public int getInputItemCount() {
        return this.inputItems == null ? 0 : this.inputItems.length;
    }

    public ReportInputItem getInputItem(int n) {
        return this.inputItems[n];
    }

    public ReportInputItem[] getInputItems() {
        return this.inputItems;
    }

    public String getName() {
        if (this.name == null) {
            if (this.autoName == null) {
                int n = this.getInputItemCount();
                if (n == 1) {
                    return this.inputItems[0].getText();
                }
                this.autoName = n + " " + this.lex.getText("items");
            }
            return this.autoName;
        }
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isAutoName() {
        return this.name == null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public BUnit getUnit() {
        return this.unit;
    }

    public void setUnit(BUnit bUnit) {
        this.unit = bUnit;
    }

    public ReportInputItem removeInputItem(int n) {
        this.autoName = null;
        if (n < 0 || n >= this.inputItems.length) {
            return null;
        }
        ReportInputItem reportInputItem = this.inputItems[n];
        ReportInputItem[] reportInputItemArray = new ReportInputItem[this.inputItems.length - 1];
        if (n > 0) {
            System.arraycopy(this.inputItems, 0, reportInputItemArray, 0, n);
        }
        if (n < this.inputItems.length - 1) {
            System.arraycopy(this.inputItems, n + 1, reportInputItemArray, n, this.inputItems.length - n - 1);
        }
        this.inputItems = reportInputItemArray;
        return reportInputItem;
    }

    public void addInputItem(ReportInputItem reportInputItem) {
        this.name = null;
        this.autoName = null;
        ReportInputItem[] reportInputItemArray = new ReportInputItem[this.inputItems.length + 1];
        System.arraycopy(this.inputItems, 0, reportInputItemArray, 0, this.inputItems.length);
        reportInputItemArray[this.inputItems.length] = reportInputItem;
        this.inputItems = reportInputItemArray;
    }

    public void addInputItems(ReportInputItem[] reportInputItemArray) {
        this.name = null;
        this.autoName = null;
        ReportInputItem[] reportInputItemArray2 = new ReportInputItem[this.inputItems.length + reportInputItemArray.length];
        System.arraycopy(this.inputItems, 0, reportInputItemArray2, 0, this.inputItems.length);
        System.arraycopy(reportInputItemArray, 0, reportInputItemArray2, this.inputItems.length, reportInputItemArray.length);
        this.inputItems = reportInputItemArray2;
    }

    public double getFloorAreaValue() {
        double d = 0.0;
        for (int i = 0; i < this.getInputItemCount(); ++i) {
            d += this.getFloorAreaUnit().fromNormal(this.getInputItem(i).getFloorAreaUnit().toNormal(this.getInputItem(i).getFloorAreaValue()));
        }
        return d;
    }

    public BUnit getFloorAreaUnit() {
        return BUnit.getUnit((String)"square foot");
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isAggregate() {
        return this.getInputItemCount() > 1;
    }

    public void setDisaggregated(boolean bl) {
        this.disaggregated = bl;
    }

    public boolean isDisaggregated() {
        return this.disaggregated;
    }

    public void setAggregateParent(ReportInput reportInput) {
        this.aggregateParent = reportInput;
    }

    public ReportInput getAggregateParent() {
        return this.aggregateParent;
    }

    public boolean hasNormalizingPoint() {
        return this.normalizer != null;
    }

    public DataPoint getNormalizingPoint() {
        return this.normalizer;
    }

    public void setNormalizingPoint(DataPoint dataPoint) {
        this.normalizer = dataPoint;
    }

    public boolean isCompatible(ReportInput reportInput) {
        if (reportInput == this) {
            return true;
        }
        BUnit bUnit = this.getUnit();
        BUnit bUnit2 = reportInput.getUnit();
        if (bUnit != null && bUnit2 != null) {
            return bUnit.isConvertible(bUnit2);
        }
        return false;
    }

    public void save(DataOutput dataOutput) throws IOException {
        String string = this.name == null ? "" : this.name;
        dataOutput.writeUTF(string);
        boolean bl = this.unit != null;
        dataOutput.writeBoolean(bl);
        if (bl) {
            dataOutput.writeUTF(this.unit.getUnitName());
        }
        if (this.color == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(this.color.getRGB());
        }
        dataOutput.writeInt(-2);
        int n = this.inputItems == null ? 0 : this.inputItems.length;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(this.inputItems[i].getType());
            this.inputItems[i].save(dataOutput);
        }
        dataOutput.writeBoolean(this.hasNormalizingPoint());
        if (this.hasNormalizingPoint()) {
            dataOutput.writeInt(this.getNormalizingPoint().getId());
        }
    }

    public boolean load(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        boolean bl;
        boolean bl2 = true;
        this.name = dataInput.readUTF();
        if (this.name.length() == 0) {
            this.name = null;
        }
        if (bl = dataInput.readBoolean()) {
            String string = dataInput.readUTF();
            this.unit = BUnit.getUnit((String)string);
        } else {
            this.unit = null;
        }
        int n = dataInput.readInt();
        this.color = n == -1 ? null : new Color(n);
        int n2 = dataInput.readInt();
        boolean bl3 = false;
        if (n2 == -2) {
            bl3 = true;
            n2 = dataInput.readInt();
        }
        ArrayList<ReportInputItem> arrayList = new ArrayList<ReportInputItem>();
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInput.readInt();
            ReportInputItem reportInputItem = ReportInputItem.createInputItem(n3, this.lex);
            try {
                if (reportInputItem.load(easSession, dataInput)) {
                    arrayList.add(reportInputItem);
                    continue;
                }
                bl2 = false;
                continue;
            }
            catch (EasException easException) {
                bl2 = false;
            }
        }
        if (arrayList.size() == 0) {
            throw new EasException("Attempted To Restore An Empty Input.");
        }
        this.inputItems = new ReportInputItem[arrayList.size()];
        arrayList.toArray(this.inputItems);
        this.normalizer = bl3 ? (dataInput.readBoolean() ? DataPoint.get(dataInput.readInt(), easSession) : null) : null;
        return bl2;
    }
}

