/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartConfig;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultBarConfig;
import com.tridium.eas.ui.chart.DefaultPieConfig;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.RelContributionParameters;
import com.tridium.eas.ui.reports.RelContributionSeries;
import com.tridium.eas.ui.reports.RelContributionTable;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class RelativeContribution
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "relContribution";
    private Chart chart;
    private Config config;
    private RelContributionTable table;
    private RelContributionSeries series;
    private boolean refreshingInputListDisabled = false;

    public String getName() {
        return this.lex.getText("relativeContribution");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setTitle(this.getName());
            this.chart.setDefaultUsesAxes(false);
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new RelContributionTable(this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        this.chart.setModel(chartModel);
        this.config.setChartType(4);
        this.getInputList().getModel().addEasDataListener(this);
        this.setRunReportEnabled(false);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public ReportParameters createEmptyParameters() {
        return new RelContributionParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new RelContributionParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getChartType(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        RelContributionParameters relContributionParameters = (RelContributionParameters)reportParameters;
        this.getInputList().getModel().setInputs(relContributionParameters.getInputs());
        this.config.setPeriod(relContributionParameters.getPeriod());
        this.config.setNormalization(relContributionParameters.getNormalization());
        this.config.setChartType(relContributionParameters.getChartType());
        this.config.setNormalTemperature(relContributionParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(relContributionParameters.getNormalTemperatureUnit());
        this.setDataCleanse(relContributionParameters.getDataCleanse());
        this.setDataCleanseWindow(relContributionParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(relContributionParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) {
        RelContributionParameters relContributionParameters = (RelContributionParameters)reportParameters;
        ReportPeriod reportPeriod = relContributionParameters.getPeriod();
        ChartModel chartModel = new ChartModel();
        chartModel.setTitle(this.getName());
        this.series = new RelContributionSeries(relContributionParameters);
        this.series.load();
        if (this.series.getValueCount() > 0) {
            chartModel.setSeries(this.series, this.getChartConfig(relContributionParameters.getChartType(), this.series), null, null);
            this.chart.setModel(chartModel);
            this.chart.setSubtitle(reportPeriod.getDateRangeString());
            this.table.setSeries(this.series);
        }
        this.table.resetSorting();
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public ChartConfig getChartConfig(int n, ValueColors valueColors) {
        if (n == 2) {
            return new DefaultBarConfig(valueColors, Color.black);
        }
        return new DefaultPieConfig(valueColors, Color.black);
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    protected void refreshInputListEnabledStates() {
        this.refreshingInputListDisabled = true;
        this.getInputList().getModel().enableAllInputs();
        ReportInput[] reportInputArray = this.getInputList().getModel().getInputs();
        boolean bl = false;
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            ReportInputItem[] reportInputItemArray;
            if (reportInputArray[i].isDisaggregated()) {
                this.getInputList().getModel().disableInput(i);
                continue;
            }
            if ((this.config.getNormalization() & 4) > 0) {
                reportInputItemArray = reportInputArray[i].getInputItems();
                for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                    if (((SiteDataPoint)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() == null) {
                        this.getInputList().getModel().disableInput(i);
                        continue;
                    }
                    bl = true;
                }
                continue;
            }
            if ((this.config.getNormalization() & 2) > 0) {
                reportInputItemArray = reportInputArray[i].getInputItems();
                for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                    try {
                        if (((SiteDataPoint)reportInputItemArray[n2]).getDataPoint().getFloorAreaValue() == 0.0) {
                            this.getInputList().getModel().disableInput(i);
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    catch (EasException easException) {
                        easException.printStackTrace();
                        this.getInputList().getModel().disableInput(i);
                    }
                }
                continue;
            }
            bl = true;
        }
        this.setRunReportEnabled(bl);
        this.refreshingInputListDisabled = false;
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        this.refreshInputListEnabledStates();
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.dataChanged(dataEditedEvent);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && !this.refreshingInputListDisabled && dataEditedEvent.getEditedData().length > 0) {
            this.refreshInputListEnabledStates();
            Object[] objectArray = dataEditedEvent.getEditedData();
            if (objectArray[0] instanceof ReportInput) {
                BUnit bUnit = ((ReportInput)objectArray[0]).getUnit();
                int n = this.getInputList().getItemCount();
                if (n > 1) {
                    for (int i = 0; i < n; ++i) {
                        this.getInputList().getItem(i).getInput().setUnit(bUnit);
                    }
                }
            }
        }
    }

    public boolean addInput(ReportInput reportInput, boolean bl) {
        if (this.getInputList().getItemCount() == 0 || this.getInputList().getItem(0).getInput().getUnit().isConvertible(reportInput.getUnit())) {
            if (this.getInputList().getItemCount() > 0) {
                reportInput.setUnit(this.getInputList().getItem(0).getInput().getUnit());
            }
            super.addInput(reportInput, bl);
            return true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.lex.getText("theInput") + " '");
            stringBuffer.append(reportInput.getName());
            stringBuffer.append("' " + this.lex.getText("badUnits") + " (");
            stringBuffer.append(reportInput.getUnit().toString());
            stringBuffer.append(") " + this.lex.getText("cannotConvert") + " ");
            String string = null;
            string = UnitDatabase.getDefault().getQuantity(this.getInputList().getItem(0).getInput().getUnit()) != null ? UnitDatabase.getDefault().getQuantity(this.getInputList().getItem(0).getInput().getUnit()).getName() : "";
            stringBuffer.append(string);
            stringBuffer.append(" " + this.lex.getText("units"));
            JOptionPane.showMessageDialog(this, stringBuffer, this.lex.getText("inputNotAdded"), 0);
        }
        return false;
    }

    public void reaggregate(ReportInput[] reportInputArray) {
        if (reportInputArray.length > 0) {
            ReportInput reportInput = reportInputArray[0].getAggregateParent();
            reportInput.setEnabled(true);
            this.refreshInputListEnabledStates();
            if (this.series != null) {
                this.series.reaggregate(reportInput, reportInputArray);
                ChartModel chartModel = this.chart.getModel();
                if (chartModel != null) {
                    chartModel.setSeries(this.series, this.getChartConfig(this.config.getChartType(), this.series), null, null);
                }
                this.table.setSeries(this.series);
            }
        }
    }

    public void disaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        this.getInputList().getModel().disableInput(reportInput);
        if (this.series != null) {
            this.series.disaggregate(reportInput, reportInputArray);
            ChartModel chartModel = this.chart.getModel();
            if (chartModel != null) {
                chartModel.setSeries(this.series, this.getChartConfig(this.config.getChartType(), this.series), null, null);
            }
            this.table.setSeries(this.series);
        }
    }

    private class Config
    extends JComponent {
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private NumberTextField normTemperatureTextBox;
        private UnitComboBox normTemperatureUnitComboBox;
        private JRadioButton chartTypePie;
        private JRadioButton chartTypeBar;

        public Config() {
            RelativeContribution.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.periodEditor = new ReportPeriodEditor(RelativeContribution.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(RelativeContribution.this.lex.getText("period")));
            this.add(this.periodEditor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(this.periodEditor, gridBagConstraints);
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(RelativeContribution.this.lex.getText("chartType")));
            this.add(jPanel);
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new GridLayout(2, 1));
            JPanel jPanel3 = new JPanel(false);
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.chartTypePie = new JRadioButton(RelativeContribution.this.lex.getText("pie"));
            this.chartTypePie.setFont(font);
            this.chartTypePie.setSelected(true);
            this.chartTypePie.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ((Config)Config.this).RelativeContribution.this.toggleGrid.setEnabled(false);
                        Config.this.handleChartTypeChange();
                    }
                }
            });
            buttonGroup.add(this.chartTypePie);
            jPanel3.add(this.chartTypePie);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(new JLabel(new ImageIcon(RelativeContribution.this.getResourceManager().loadImage("/com/tridium/eas/ui/images/pie.png"))));
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel(false);
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            this.chartTypeBar = new JRadioButton(RelativeContribution.this.lex.getText("stackingBar"));
            this.chartTypeBar.setFont(font);
            this.chartTypeBar.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ((Config)Config.this).RelativeContribution.this.toggleGrid.setEnabled(true);
                        Config.this.handleChartTypeChange();
                    }
                }
            });
            buttonGroup.add(this.chartTypeBar);
            jPanel4.add(this.chartTypeBar);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel4.add(new JLabel(new ImageIcon(RelativeContribution.this.getResourceManager().loadImage("/com/tridium/eas/ui/images/stackingBar.png"))));
            jPanel2.add(jPanel4);
            jPanel2.setMaximumSize(jPanel2.getMinimumSize());
            jPanel.add(jPanel2);
            jPanel.add(Box.createHorizontalGlue());
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            JPanel jPanel5 = new JPanel(false);
            this.add(jPanel5);
            jPanel5.setLayout(new GridBagLayout());
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RelativeContribution.this.refreshInputListEnabledStates();
                }
            };
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.weighty = 0.0;
            int n2 = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n2++;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normFloorArea = new JCheckBox(RelativeContribution.this.lex.getText("floorArea"));
            this.normFloorArea.setFont(font);
            this.normFloorArea.addActionListener(actionListener);
            this.normFloorArea.setSelected(false);
            jPanel5.add((Component)this.normFloorArea, gridBagConstraints2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n2++;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.0;
            this.normWeather = new JCheckBox(RelativeContribution.this.lex.getText("degreeDay"));
            this.normWeather.setFont(font);
            this.normWeather.addActionListener(actionListener);
            this.normWeather.setSelected(false);
            jPanel5.add((Component)this.normWeather, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normTemperatureTextBox = new NumberTextField(3);
            this.normTemperatureTextBox.setText(65);
            jPanel5.add((Component)this.normTemperatureTextBox, gridBagConstraints2);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normTemperatureUnitComboBox = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"fahrenheit")), RelativeContribution.this.lex);
            this.normTemperatureUnitComboBox.setSelectedUnit(BUnit.getUnit((String)"fahrenheit"));
            jPanel5.add((Component)this.normTemperatureUnitComboBox, gridBagConstraints2);
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 100.0;
            jPanel5.add(Box.createHorizontalGlue(), gridBagConstraints2);
            jPanel5.setBorder(BorderFactory.createTitledBorder(RelativeContribution.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
            JLabel jLabel = new JLabel("");
            this.add(jLabel);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public int getChartType() {
            if (this.chartTypeBar.isSelected()) {
                return 2;
            }
            return 4;
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public double getNormalTemperature() {
            return this.normTemperatureTextBox.getDoubleValue();
        }

        public void setNormalTemperature(double d) {
            this.normTemperatureTextBox.setText(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.normTemperatureUnitComboBox.getSelectedUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.normTemperatureUnitComboBox.setSelectedUnit(bUnit);
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) > 0);
            this.normWeather.setSelected((n & 4) > 0);
        }

        public void setChartType(int n) {
            this.chartTypeBar.setSelected(n == 2);
        }

        public void handleChartTypeChange() {
            if (RelativeContribution.this.series != null) {
                ChartModel chartModel = RelativeContribution.this.chart.getModel();
                if (chartModel != null) {
                    chartModel.setSeries(RelativeContribution.this.series, RelativeContribution.this.getChartConfig(this.getChartType(), RelativeContribution.this.series), null, null);
                }
                RelativeContribution.this.table.setSeries(RelativeContribution.this.series);
            }
        }
    }
}

