/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.reports.RelContributionSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ValuePercentPair;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import java.text.DecimalFormat;
import javax.baja.util.Lexicon;

public class RelContributionTableModel
extends AbstractRowMappedTableModel {
    private RelContributionSeries series = null;
    private double rawValueTotal = 0.0;
    private double normalizedValueTotal = 0.0;
    public static final int INPUT_COL = 0;
    public static final int RAW_VALUE_COL = 1;
    public static final int RAW_VALUE_PERCENT_COL = 2;
    public static final int NORMAL_VALUE_COL = 3;
    public static final int VALUE_COL = 4;
    public static final int VALUE_PERCENT_COL = 5;
    private static DecimalFormat percentFormat = new DecimalFormat("##0.0");
    private int[] col_list;
    private Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ReportInput;
    static /* synthetic */ Class class$java$lang$Number;

    public RelContributionTableModel(Lexicon lexicon) {
        this.lex = lexicon;
        this.col_list = new int[0];
    }

    public void setSeries(RelContributionSeries relContributionSeries) {
        int n;
        this.series = relContributionSeries;
        this.rawValueTotal = 0.0;
        for (n = 0; n < relContributionSeries.getValueCount(); ++n) {
            this.rawValueTotal += relContributionSeries.getRawValue(n);
        }
        this.normalizedValueTotal = 0.0;
        if (relContributionSeries.getParameters().getNormalization() != 0) {
            for (n = 0; n < relContributionSeries.getValueCount(); ++n) {
                this.normalizedValueTotal += relContributionSeries.getValue(0, n);
            }
        }
        if (relContributionSeries.getParameters().getNormalization() == 0) {
            this.col_list = new int[]{0, 4, 5};
        } else if ((relContributionSeries.getParameters().getNormalization() & 2) > 0) {
            this.col_list = new int[]{0, 1, 2, 3, 4, 5};
        } else if ((relContributionSeries.getParameters().getNormalization() & 4) > 0) {
            this.col_list = new int[]{0, 1, 2, 4, 5};
        }
        this.fireTableStructureChanged();
    }

    private ReportInput getInput(int n) {
        return this.series.getOriginalInput(n);
    }

    private ValuePercentPair getRawValue(int n) {
        return new ValuePercentPair(this.series.getRawValue(n), this.getRawPercent(n));
    }

    private double getRawPercent(int n) {
        if (this.getRawValueTotal() == 0.0) {
            return 0.0;
        }
        return this.series.getRawValue(n) / this.getRawValueTotal();
    }

    private double getRawValueTotal() {
        return this.rawValueTotal;
    }

    private Number getFloorAreaValue(int n) {
        return new Double(this.series.getFloorAreaValue(n));
    }

    private ValuePercentPair getNormalizedValue(int n) {
        return new ValuePercentPair(this.series.getValue(0, n), this.getNormalizedPercent(n));
    }

    private double getNormalizedValueTotal() {
        return this.normalizedValueTotal;
    }

    private double getNormalizedPercent(int n) {
        if (this.getNormalizedValueTotal() == 0.0) {
            return 0.0;
        }
        return this.series.getValue(0, n) / this.getNormalizedValueTotal();
    }

    public int getRowCount() {
        if (this.series == null) {
            return 0;
        }
        return this.series.getValueCount();
    }

    public String getColumnName(int n) {
        switch (this.col_list[n]) {
            case 0: {
                return " ";
            }
            case 1: {
                if (this.series == null) {
                    return this.lex.getText("data");
                }
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        return this.lex.getText("data") + " (" + this.series.getRawValueUnits().toString() + ")";
                    }
                }
                return this.lex.getText("rawData") + " (" + this.series.getRawValueUnits().toString() + ")";
            }
            case 2: {
                if (this.series == null) {
                    return this.lex.getText("%");
                }
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        return this.lex.getText("data") + " (" + this.lex.getText("%") + ")";
                    }
                }
                return this.lex.getText("rawData") + " (" + this.lex.getText("%") + ")";
            }
            case 3: {
                return this.lex.getText("floorArea") + " (" + this.series.getFloorAreaUnits().toString() + ")";
            }
            case 4: {
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        return this.lex.getText("data") + " (" + this.series.getRawValueUnits().toString() + ")";
                    }
                }
                return this.lex.getText("normalized") + " (" + this.series.getValueUnits().toString() + ")";
            }
            case 5: {
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        return this.lex.getText("data") + " (" + this.lex.getText("%") + ")";
                    }
                }
                return this.lex.getText("normalized") + " (" + this.lex.getText("%") + ")";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getColumnCount() {
        return this.col_list.length;
    }

    public Class getColumnClass(int n) {
        switch (this.col_list[n]) {
            case 0: {
                return class$com$tridium$eas$ui$reports$ReportInput == null ? (class$com$tridium$eas$ui$reports$ReportInput = RelContributionTableModel.class$("com.tridium.eas.ui.reports.ReportInput")) : class$com$tridium$eas$ui$reports$ReportInput;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return class$java$lang$Number == null ? (class$java$lang$Number = RelContributionTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
            case 3: {
                return class$java$lang$Number == null ? (class$java$lang$Number = RelContributionTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Object getModelValueAt(int n, int n2) {
        switch (this.col_list[n2]) {
            case 0: {
                return this.getInput(n);
            }
            case 1: {
                return this.getRawValue(n).getValue();
            }
            case 2: {
                try {
                    return percentFormat.parse(percentFormat.format(this.getRawValue(n).getPercent().floatValue() * 100.0f));
                }
                catch (Exception exception) {
                    return new Double(this.getRawValue(n).getPercent().doubleValue() * 100.0);
                }
            }
            case 3: {
                return this.getFloorAreaValue(n);
            }
            case 4: {
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        return this.getRawValue(n).getValue();
                    }
                }
                return this.getNormalizedValue(n).getValue();
            }
            case 5: {
                switch (this.series.getParameters().getNormalization()) {
                    case 0: {
                        try {
                            return percentFormat.parse(percentFormat.format(this.getRawValue(n).getPercent().doubleValue() * 100.0));
                        }
                        catch (Exception exception) {
                            return new Double(this.getRawValue(n).getPercent().doubleValue() * 100.0);
                        }
                    }
                }
                try {
                    return percentFormat.parse(percentFormat.format(this.getNormalizedValue(n).getPercent().doubleValue() * 100.0));
                }
                catch (Exception exception) {
                    return new Double(this.getNormalizedValue(n).getPercent().doubleValue() * 100.0);
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

