/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.FuncDataSummary;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.RelContributionParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.util.CompoundUnitUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class RelContributionSeries
extends Series
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private RelContributionParameters params;
    private ArrayList rawValueList = null;
    private ArrayList floorAreaValueList = null;
    private ArrayList normalizedValueList = null;
    private double normalizedValueTotal;
    private ArrayList inputList = null;
    private ArrayList origInputList = null;
    private double min;
    private double max;
    private BUnit dpUnit = null;
    private BUnit floorAreaUnit = null;
    private DecimalFormat smallFormat = new DecimalFormat("0.000");
    private DecimalFormat percentFormat = new DecimalFormat("#0.0%");

    public RelContributionSeries(RelContributionParameters relContributionParameters) {
        this.params = relContributionParameters;
        this.dpUnit = null;
        this.normalizedValueTotal = 0.0;
    }

    public String getSeriesName() {
        return " ";
    }

    public RelContributionParameters getParameters() {
        return this.params;
    }

    public void setParameters(RelContributionParameters relContributionParameters) {
        this.params = relContributionParameters;
    }

    public int getRowCount() {
        return 1;
    }

    public int getValueCount() {
        return this.normalizedValueList.size();
    }

    public double getMin(int n) {
        return this.getValue(0, n);
    }

    public double getMax(int n) {
        return this.getValue(0, n);
    }

    public double getValue(int n, int n2) {
        return (Double)this.normalizedValueList.get(n2);
    }

    public double getRawValue(int n) {
        return (Double)this.rawValueList.get(n);
    }

    public double getFloorAreaValue(int n) {
        return (Double)this.floorAreaValueList.get(n);
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getRawValueUnits() {
        return this.dpUnit;
    }

    public BUnit getFloorAreaUnits() {
        return this.floorAreaUnit;
    }

    public BUnit getValueUnits() {
        if ((this.params.getNormalization() & 2) == 0) {
            return this.dpUnit;
        }
        return CompoundUnitUtil.make(this.dpUnit, this.getFloorAreaUnits());
    }

    public void addInput(ReportInput reportInput) {
        if (!reportInput.isEnabled()) {
            return;
        }
        ReportPeriod reportPeriod = this.params.getPeriod();
        EasLocalTime easLocalTime = reportPeriod.getStartTime();
        EasLocalTime easLocalTime2 = reportPeriod.getEndTime();
        long l = easLocalTime.getTimestamp(BTimeZone.getLocal());
        long l2 = easLocalTime2.getTimestamp(BTimeZone.getLocal());
        this.floorAreaUnit = null;
        try {
            if (reportInput.isDisaggregated()) {
                return;
            }
            this.inputList.add(reportInput);
            this.origInputList.add(reportInput.getCopy());
            ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
            if (reportInputItemArray.length == 1) {
                SiteDataPoint siteDataPoint = (SiteDataPoint)reportInputItemArray[0];
                TSDataSummary tSDataSummary = siteDataPoint.getDataPoint().getDataSummary(reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportInput.getUnit(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval((int)((l2 - l) / 60000L), 3), this.params.isNormalizedByFloorArea(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperatureUnit(), this.params.getNormalTemperature(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                Double d = new Double(0.0);
                if (tSDataSummary.getDataSummary(0).isValid()) {
                    d = siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.DEMAND || siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.REACTIVE_POWER || siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.APPARENT_POWER ? new Double(tSDataSummary.getDataSummary(0).getPeakDemand()) : new Double(tSDataSummary.getDataSummary(0).getTotalConsumption());
                }
                this.normalizedValueList.add(d);
                this.normalizedValueTotal += d.doubleValue();
                if (this.params.getNormalization() != 0 && (tSDataSummary = siteDataPoint.getDataPoint().getDataSummary(reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportInput.getUnit(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval((int)((l2 - l) / 60000L), 3), false, false, this.params.getNormalTemperatureUnit(), this.params.getNormalTemperature(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint())).getDataSummary(0).isValid()) {
                    d = siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.DEMAND || siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.REACTIVE_POWER || siteDataPoint.getDataPoint().getRcSubTypeObj() == RcSubtype.APPARENT_POWER ? new Double(tSDataSummary.getDataSummary(0).getPeakDemand()) : new Double(tSDataSummary.getDataSummary(0).getTotalConsumption());
                }
                this.rawValueList.add(d);
                this.floorAreaValueList.add(new Double(siteDataPoint.getFloorAreaValue()));
                this.floorAreaUnit = siteDataPoint.getFloorAreaUnit();
                this.dpUnit = reportInput.getUnit();
                if (reportInput.hasNormalizingPoint()) {
                    this.dpUnit = CompoundUnitUtil.make(this.dpUnit, reportInput.getNormalizingPoint().getUnit());
                }
            } else if (reportInputItemArray.length > 1) {
                Object object;
                DataPoint[] dataPointArray = new DataPoint[reportInputItemArray.length];
                double d = 0.0;
                this.dpUnit = reportInput.getUnit();
                if (reportInput.hasNormalizingPoint()) {
                    this.dpUnit = CompoundUnitUtil.make(this.dpUnit, reportInput.getNormalizingPoint().getUnit());
                }
                for (int i = 0; i < reportInputItemArray.length; ++i) {
                    object = (SiteDataPoint)reportInputItemArray[i];
                    if (i == 0) {
                        this.floorAreaUnit = ((SiteDataPoint)object).getFloorAreaUnit();
                        d += ((SiteDataPoint)object).getFloorAreaValue();
                    } else {
                        d += this.floorAreaUnit.fromNormal(((SiteDataPoint)object).getFloorAreaUnit().toNormal(((SiteDataPoint)object).getFloorAreaValue()));
                    }
                    dataPointArray[i] = ((SiteDataPoint)object).getDataPoint();
                }
                this.floorAreaValueList.add(new Double(d));
                TSDataSummary tSDataSummary = FuncDataSummary.getResult(dataPointArray, reportInput.getUnit(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval((int)((l2 - l) / 60000L), 3), this.params.isNormalizedByFloorArea(), dataPointArray[0].getFloorAreaUnit(), this.params.isNormalizedByTemperature(), this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                object = new Double(0.0);
                if (tSDataSummary.getDataSummary(0).isValid()) {
                    object = dataPointArray[0].getRcSubTypeObj() == RcSubtype.DEMAND || dataPointArray[0].getRcSubTypeObj() == RcSubtype.REACTIVE_POWER || dataPointArray[0].getRcSubTypeObj() == RcSubtype.APPARENT_POWER ? new Double(tSDataSummary.getDataSummary(0).getPeakDemand()) : new Double(tSDataSummary.getDataSummary(0).getTotalConsumption());
                }
                this.normalizedValueTotal += ((Double)object).doubleValue();
                this.normalizedValueList.add(object);
                if (this.params.getNormalization() != 0 && (tSDataSummary = FuncDataSummary.getResult(dataPointArray, reportInput.getUnit(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), reportPeriod.getDaysOfWeek(), 0, new TimeInterval((int)((l2 - l) / 60000L), 3), false, dataPointArray[0].getFloorAreaUnit(), false, this.params.getNormalTemperature(), this.params.getNormalTemperatureUnit(), this.params.getDataCleanse(), this.params.getDataCleanseWindow(), this.params.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint())).getDataSummary(0).isValid()) {
                    object = dataPointArray[0].getRcSubTypeObj() == RcSubtype.DEMAND || dataPointArray[0].getRcSubTypeObj() == RcSubtype.REACTIVE_POWER || dataPointArray[0].getRcSubTypeObj() == RcSubtype.APPARENT_POWER ? new Double(tSDataSummary.getDataSummary(0).getPeakDemand()) : new Double(tSDataSummary.getDataSummary(0).getTotalConsumption());
                }
                this.rawValueList.add(object);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return;
        }
    }

    public void load() {
        ReportPeriod reportPeriod = this.params.getPeriod();
        ReportInput[] reportInputArray = this.params.getInputs();
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        this.rawValueList = new ArrayList();
        this.floorAreaValueList = new ArrayList();
        this.normalizedValueList = new ArrayList();
        this.inputList = new ArrayList();
        this.origInputList = new ArrayList();
        this.dpUnit = null;
        this.floorAreaUnit = null;
        for (int i = 0; i < n; ++i) {
            this.addInput(reportInputArray[i]);
        }
    }

    public void disaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        this.removeInput(reportInput);
        for (int i = 0; i < reportInputArray.length; ++i) {
            this.addInput(reportInputArray[i]);
        }
    }

    public void reaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        this.addInput(reportInput);
        for (int i = 0; i < reportInputArray.length; ++i) {
            this.removeInput(reportInputArray[i]);
        }
    }

    public double getMinRowTotal() {
        double d = 0.0;
        for (int i = 0; i < this.getValueCount(); ++i) {
            d += this.getValue(0, i);
        }
        return d;
    }

    public double getMaxRowTotal() {
        return this.getMinRowTotal();
    }

    public String getRowName(int n) {
        return "";
    }

    public ReportInput getOriginalInput(int n) {
        return (ReportInput)this.origInputList.get(n);
    }

    public ReportInput getInput(int n) {
        return (ReportInput)this.inputList.get(n);
    }

    protected void removeInput(ReportInput reportInput) {
        int n = this.inputList.indexOf(reportInput);
        if (n >= 0) {
            this.inputList.remove(n);
            this.rawValueList.remove(n);
            this.floorAreaValueList.remove(n);
            this.normalizedValueList.remove(n);
            this.normalizedValueTotal -= this.getValue(-1, n);
            this.origInputList.remove(n);
        }
    }

    public Color getValueColor(int n) {
        return this.getInput(n).getColor();
    }

    public String getValueName(int n) {
        return this.getInput(n).getName();
    }

    public String getValueLabel(int n, int n2) {
        double d = this.getValue(n, n2);
        double d2 = d / this.normalizedValueTotal;
        StringBuffer stringBuffer = new StringBuffer();
        if (d > 1.0) {
            stringBuffer.append(DecimalFormatter.format(d));
        } else {
            stringBuffer.append(this.smallFormat.format(d));
        }
        stringBuffer.append('(');
        stringBuffer.append(this.percentFormat.format(d2));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

